/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.model.freemarker;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.model.AbstractResourceConfigGraphModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerCSVNodeGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.Messages;
import org.jboss.tools.smooks.graphical.editors.template.FreemarkerTemplateContentGraphModelProviderImpl;
import org.jboss.tools.smooks.graphical.editors.template.IFreemarkerTemplateContentGraphModelProvider;
import org.jboss.tools.smooks.model.freemarker.Freemarker;
import org.jboss.tools.smooks.templating.model.ModelBuilderException;
import org.jboss.tools.smooks.templating.template.TemplateBuilder;
import org.jboss.tools.smooks.templating.template.exception.TemplateBuilderException;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerTemplateGraphicalModel
extends AbstractResourceConfigGraphModel {
    public static final int TYPE_CSV = 1;
    public static final int TYPE_EDI = 2;
    public static final int TYPE_XML = 3;
    public static final int TYPE_XSD = 4;
    public static final int TYPE_UNKNOWN = -1;
    private ISmooksModelProvider smooksModelProvider;
    private boolean firstLoadChildren = true;
    private IFreemarkerTemplateContentGraphModelProvider graphModelProvider = null;
    private TemplateBuilder templateBuilder = null;

    public FreemarkerTemplateGraphicalModel(Object data, ITreeContentProvider contentProvider, ILabelProvider labelProvider, ISmooksModelProvider domainProvider) {
        super(data, contentProvider, labelProvider, domainProvider);
        this.smooksModelProvider = domainProvider;
        this.graphModelProvider = this.createFreemarkerTemplateContentGraphModelProvider();
        try {
            this.templateBuilder = this.graphModelProvider.getTemplateBuilder(this);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ModelBuilderException e) {
            e.printStackTrace();
        }
        catch (TemplateBuilderException e) {
            e.printStackTrace();
        }
    }

    public TemplateBuilder getTemplateBuilder() {
        return this.templateBuilder;
    }

    protected IFreemarkerTemplateContentGraphModelProvider createFreemarkerTemplateContentGraphModelProvider() {
        return new FreemarkerTemplateContentGraphModelProviderImpl();
    }

    protected void initChildrenNodes() {
        Object data = this.getData();
        Freemarker freemarker = (Freemarker)(data = AdapterFactoryEditingDomain.unwrap((Object)data));
        if (freemarker != null) {
            List<AbstractSmooksGraphicalModel> graphModels = this.graphModelProvider.getFreemarkerTemplateContentGraphModel(this, this.getContentProvider(), this.getLabelProvider(), this.smooksModelProvider);
            for (AbstractSmooksGraphicalModel abstractSmooksGraphicalModel : graphModels) {
                this.getChildrenWithoutDynamic().add(abstractSmooksGraphicalModel);
                abstractSmooksGraphicalModel.setParent(this);
            }
        }
    }

    @Override
    protected TreeNodeModel createChildModel(Object model, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        if (this.getTemplateType() == 1) {
            return new FreemarkerCSVNodeGraphicalModel(model, contentProvider, labelProvider, this.domainProvider);
        }
        return null;
    }

    @Override
    public Image getImage() {
        ImageRegistry registry = SmooksConfigurationActivator.getDefault().getImageRegistry();
        if (this.getTemplateType() == 1) {
            return registry.get("icons/full/obj16/csvfile.gif");
        }
        if (this.getTemplateType() == 3) {
            return registry.get("icons/full/obj16/XMLFile.gif");
        }
        return registry.get("icons/full/obj16/unknown_obj.gif");
    }

    @Override
    public String getText() {
        if (this.getTemplateType() == 1) {
            return Messages.FreemarkerTemplateGraphicalModel_CSV_Template_Name;
        }
        if (this.getTemplateType() == 3) {
            return Messages.FreemarkerTemplateGraphicalModel_XML_Template_Name;
        }
        return super.getText();
    }

    @Override
    public List<AbstractSmooksGraphicalModel> getChildren() {
        if (this.firstLoadChildren) {
            try {
                this.initChildrenNodes();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.firstLoadChildren = false;
        }
        return this.getChildrenWithoutDynamic();
    }

    @Override
    public void addChild(AbstractSmooksGraphicalModel node) {
        super.addChild(node);
    }

    @Override
    public void addChild(int index, AbstractSmooksGraphicalModel node) {
        super.addChild(index, node);
    }

    @Override
    public boolean canLinkWithSource(Object model) {
        return false;
    }

    @Override
    public boolean canLinkWithTarget(Object model) {
        return false;
    }

    public int getTemplateType() {
        Object data = this.getData();
        Freemarker freemarker = (Freemarker)(data = AdapterFactoryEditingDomain.unwrap((Object)data));
        if (freemarker != null) {
            String type = SmooksModelUtils.getTemplateType((Freemarker)freemarker);
            if ("CSV".equals(type)) {
                return 1;
            }
            if ("XML".equals(type)) {
                return 3;
            }
        }
        return -1;
    }
}

