/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.model.xsl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.wst.xsl.core.XSLCore;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractXMLObject;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;
import org.jboss.tools.smooks.configuration.editors.xml.TagPropertyObject;
import org.jboss.tools.smooks.configuration.editors.xml.XMLUtils;
import org.jboss.tools.smooks.configuration.editors.xml.XSLModelAnalyzer;
import org.jboss.tools.smooks.configuration.editors.xml.XSLTagObject;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.model.InputDataTreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.model.xsl.XSLTemplateGraphicalModel;
import org.jboss.tools.smooks.model.xsl.Template;
import org.jboss.tools.smooks.model.xsl.Xsl;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLNodeGraphicalModel
extends TreeNodeModel {
    protected IEditingDomainProvider domainProvider = null;

    public XSLNodeGraphicalModel(Object data, ITreeContentProvider contentProvider, ILabelProvider labelProvider, IEditingDomainProvider domainProvider) {
        super(data, contentProvider, labelProvider);
        this.domainProvider = domainProvider;
    }

    public IEditingDomainProvider getDomainProvider() {
        return this.domainProvider;
    }

    public void setDomainProvider(IEditingDomainProvider domainProvider) {
        this.domainProvider = domainProvider;
    }

    protected TreeNodeModel createChildModel(Object model, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        return new XSLNodeGraphicalModel(model, contentProvider, labelProvider, this.domainProvider);
    }

    public boolean canLinkWithSource(Object model) {
        List<TreeNodeConnection> targetConnections = this.getTargetConnections();
        for (TreeNodeConnection treeNodeConnection : targetConnections) {
            if (treeNodeConnection.getSourceNode() != model) continue;
            return false;
        }
        return true;
    }

    public boolean canLinkWithTarget(Object model) {
        return false;
    }

    public void addSourceConnection(TreeNodeConnection connection) {
        super.addSourceConnection(connection);
    }

    public void removeTargetConnection(TreeNodeConnection connection) {
        Object data = this.getData();
        if (data instanceof TagPropertyObject) {
            ((TagPropertyObject)data).setValue(null);
        }
        if (data instanceof XSLTagObject) {
            if (XSLModelAnalyzer.isXSLTagObject((XSLTagObject)data)) {
                if (((XSLTagObject)data).isForeachElement() || ((XSLTagObject)data).isSortElement()) {
                    ((XSLTagObject)data).removeSelectProperty();
                }
                if (((XSLTagObject)data).isTemplateElement()) {
                    ((XSLTagObject)data).removeMatchProperty();
                    this.fireVisualChanged();
                }
            } else {
                AbstractSmooksGraphicalModel sourceModel = connection.getSourceNode();
                AbstractXMLObject xmlObject = null;
                if (sourceModel instanceof InputDataTreeNodeModel) {
                    xmlObject = (AbstractXMLObject)((InputDataTreeNodeModel)sourceModel).getData();
                }
                if (xmlObject != null) {
                    List<TagObject> relatedTags = ((XSLTagObject)data).getRelatedIgnoreXSLTagObjects();
                    XSLTagObject relatedTag = null;
                    for (TagObject object : relatedTags) {
                        String select;
                        IXMLStructuredObject node;
                        if (!(object instanceof XSLTagObject) || !((XSLTagObject)object).isValueOfElement() || (node = SmooksUIUtils.localXMLNodeWithPath(select = ((XSLTagObject)object).getSelectValue(), SmooksUIUtils.getRootParent(xmlObject))) != xmlObject) continue;
                        Element parentElement = ((XSLTagObject)data).getReferenceElement();
                        Element thisElement = ((XSLTagObject)object).getReferenceElement();
                        parentElement.removeChild(thisElement);
                        ((XSLTagObject)data).removeChildTag((XSLTagObject)object);
                        relatedTag = (XSLTagObject)object;
                        break;
                    }
                    if (relatedTag != null) {
                        ((XSLTagObject)data).getRelatedIgnoreXSLTagObjects().remove(relatedTag);
                    }
                }
            }
        }
        super.removeTargetConnection(connection);
        this.setXSLContents(this.getXSLContents());
    }

    public void addTargetConnection(TreeNodeConnection connection, AbstractSmooksGraphicalModel sourceNode) {
        Object data;
        AbstractSmooksGraphicalModel sourceModel = connection.getSourceNode();
        Object source = sourceModel.getData();
        String selectorString = null;
        if (source instanceof IXMLStructuredObject) {
            selectorString = SmooksUIUtils.generateFullPath((IXMLStructuredObject)source, "/");
        }
        if ((data = this.getData()) instanceof TagPropertyObject) {
            ((TagPropertyObject)data).setValue("{" + selectorString + "}");
        }
        if (data instanceof XSLTagObject) {
            if (XSLModelAnalyzer.isXSLTagObject((XSLTagObject)data)) {
                if (((XSLTagObject)data).isForeachElement() || ((XSLTagObject)data).isSortElement()) {
                    ((XSLTagObject)data).setSelectValue(selectorString);
                }
                if (((XSLTagObject)data).isTemplateElement()) {
                    ((XSLTagObject)data).setMatchValue(selectorString);
                    this.fireVisualChanged();
                }
            } else {
                XSLTagObject relateTag = null;
                if (relateTag == null) {
                    relateTag = new XSLTagObject();
                    Element element = ((XSLTagObject)data).getReferenceElement();
                    Document doc = element.getOwnerDocument();
                    Element rootElement = doc.getDocumentElement();
                    String namespace = rootElement.getNamespaceURI();
                    if (namespace == null) {
                        namespace = "http://www.w3.org/1999/XSL/Transform";
                    }
                    Element newElement = doc.createElementNS(namespace, "value-of");
                    element.appendChild(newElement);
                    relateTag.setName("value-of");
                    relateTag.setReferenceElement(newElement);
                    ((XSLTagObject)data).getRelatedIgnoreXSLTagObjects().add(relateTag);
                }
                relateTag.setSelectValue(selectorString);
            }
        }
        super.addTargetConnection(connection, sourceNode);
        this.setXSLContents(this.getXSLContents());
    }

    /*
     * Loose catch block
     */
    public static String getXSLContents(Element rootElement) {
        if (rootElement != null) {
            String string;
            ByteArrayOutputStream stream = null;
            stream = new ByteArrayOutputStream();
            XMLUtils.outDOMNode((Node)rootElement, stream);
            String string2 = string = new String(stream.toByteArray());
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable throwable) {}
            return string2;
            catch (Exception exception) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    public void removeChild(AbstractSmooksGraphicalModel node) {
        Object data = this.getData();
        Object childModel = node.getData();
        if (data instanceof XSLTagObject) {
            if (childModel instanceof XSLTagObject) {
                ((XSLTagObject)data).removeChildTag((XSLTagObject)childModel);
            }
            if (childModel instanceof TagPropertyObject) {
                ((XSLTagObject)data).removeProperty((TagPropertyObject)childModel);
            }
        }
        super.removeChild(node);
        this.setXSLContents(this.getXSLContents());
    }

    public void addChild(AbstractSmooksGraphicalModel node) {
        Object data = this.getData();
        Object childModel = node.getData();
        if (data instanceof XSLTagObject) {
            if (childModel instanceof XSLTagObject) {
                ((XSLTagObject)data).addChildTag((XSLTagObject)childModel);
            }
            if (childModel instanceof TagPropertyObject) {
                ((XSLTagObject)data).addProperty((TagPropertyObject)childModel);
            }
        }
        super.addChild(node);
        this.setXSLContents(this.getXSLContents());
    }

    public void moveChild(int index, AbstractSmooksGraphicalModel node) {
        try {
            AbstractXMLObject cfr_ignored_0 = (AbstractXMLObject)node.getData();
            AbstractXMLObject thisNode = (AbstractXMLObject)this.getData();
            thisNode.getReferenceElement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.moveChild(index, node);
        this.setXSLContents(this.getXSLContents());
    }

    protected String getXSLContents() {
        Object data = this.getData();
        Element rootElement = null;
        Element parentElement = null;
        if (data instanceof TagPropertyObject) {
            parentElement = ((TagPropertyObject)data).getReferenceAttibute().getOwnerElement();
        }
        if (data instanceof XSLTagObject) {
            parentElement = ((XSLTagObject)data).getReferenceElement();
        }
        if (parentElement != null) {
            Document d = parentElement.getOwnerDocument();
            rootElement = d.getDocumentElement();
        }
        return XSLNodeGraphicalModel.getXSLContents(rootElement);
    }

    protected void setXSLContents(String contents) {
        Template template = this.getXSLTemplate();
        EditingDomain domain = this.domainProvider.getEditingDomain();
        if (template != null) {
            String filePath = SmooksModelUtils.getAnyTypeText((AnyType)template);
            if (filePath != null) {
                filePath = filePath.trim();
            }
            if (filePath != null && !"".equals(filePath)) {
                IFile file = SmooksUIUtils.getFile(filePath, SmooksUIUtils.getResource((EObject)template).getProject());
                if (file != null && XSLCore.isXSLFile((IFile)file) && file.exists()) {
                    try {
                        if (contents == null) {
                            contents = "";
                        }
                        file.setContents((InputStream)new ByteArrayInputStream(contents.getBytes()), 1, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                SmooksModelUtils.setCDATAToSmooksType((EditingDomain)domain, (AnyType)template, (String)contents);
            }
        }
    }

    protected Template getXSLTemplate() {
        Object data;
        AbstractSmooksGraphicalModel parent = this;
        while (parent != null) {
            if (parent instanceof XSLTemplateGraphicalModel) break;
            parent = parent.getParent();
        }
        if (parent != null && parent instanceof XSLTemplateGraphicalModel && (data = ((XSLTemplateGraphicalModel)parent).getData()) instanceof Xsl) {
            return ((Xsl)data).getTemplate();
        }
        return null;
    }

    public void setName(String name, String namespaceURI, String namespacePrefix) {
        AbstractXMLObject obj = (AbstractXMLObject)this.getData();
        String oldName = obj.getName();
        if (oldName == null) {
            oldName = "";
        }
        if (oldName.equals(name)) {
            return;
        }
        obj.setName(name);
        this.setXSLContents(this.getXSLContents());
        if (this.support != null) {
            this.support.firePropertyChange("_pro_text_changed", oldName, name);
        }
    }
}

