/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.model.xsl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.xsl.core.XSLCore;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractXMLObject;
import org.jboss.tools.smooks.configuration.editors.xml.XMLStructuredDataContentProvider;
import org.jboss.tools.smooks.configuration.editors.xml.XSLModelAnalyzer;
import org.jboss.tools.smooks.model.xsl.Template;
import org.jboss.tools.smooks.model.xsl.Xsl;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;

public class XSLTemplateContentProvider
implements ITreeContentProvider {
    private ITreeContentProvider parentProvider = null;
    private ITreeContentProvider xmlObjectContentProvider = new XMLStructuredDataContentProvider();
    private Map<Object, Object> buffer = new HashMap<Object, Object>();

    public XSLTemplateContentProvider(ITreeContentProvider parentProvider) {
        this.parentProvider = parentProvider;
    }

    public void cleanBuffer() {
        if (this.buffer != null) {
            this.buffer.clear();
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Xsl) {
            Template template = ((Xsl)parentElement).getTemplate();
            if (template != null) {
                Object obj = this.buffer.get(template);
                if (obj == null) {
                    String filePath = SmooksModelUtils.getAnyTypeText((AnyType)template);
                    if (filePath != null) {
                        filePath = filePath.trim();
                    }
                    if (filePath != null && !"".equals(filePath)) {
                        IFile file = SmooksUIUtils.getFile(filePath, SmooksUIUtils.getResource((EObject)template).getProject());
                        if (file != null && XSLCore.isXSLFile((IFile)file)) {
                            new XSLModelAnalyzer();
                        }
                    } else {
                        String contents = SmooksModelUtils.getAnyTypeCDATA((AnyType)template);
                        if (contents != null) {
                            new XSLModelAnalyzer();
                        }
                    }
                }
                if (obj != null) {
                    this.buffer.put(template, obj);
                    return new Object[]{obj};
                }
            }
            return new Object[0];
        }
        if (parentElement instanceof AbstractXMLObject && XSLModelAnalyzer.isXSLTagObject((AbstractXMLObject)parentElement)) {
            return ((AbstractXMLObject)parentElement).getXMLNodeChildren().toArray();
        }
        return this.xmlObjectContentProvider.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.xmlObjectContentProvider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Xsl) {
            return true;
        }
        if (element instanceof AbstractXMLObject && XSLModelAnalyzer.isXSLTagObject((AbstractXMLObject)element)) {
            return !((AbstractXMLObject)element).getXMLNodeChildren().isEmpty();
        }
        return this.xmlObjectContentProvider.hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.parentProvider.getElements(inputElement);
    }

    public void dispose() {
        this.parentProvider.dispose();
        this.xmlObjectContentProvider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.parentProvider.inputChanged(viewer, oldInput, newInput);
    }
}

