/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors.template;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.graphical.editors.Messages;
import org.jboss.tools.smooks.graphical.editors.autolayout.IAutoLayout;
import org.jboss.tools.smooks.graphical.editors.editparts.freemarker.FreemarkerAutoLayout;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerActionCreator;
import org.jboss.tools.smooks.graphical.editors.process.TaskType;
import org.jboss.tools.smooks.graphical.editors.template.SmooksFreemarkerTemplateGraphicalEditor;
import org.jboss.tools.smooks.model.freemarker.Freemarker;
import org.jboss.tools.smooks.model.smooks.ParamType;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;

public class SmooksFreemarkerCSVTemplateGraphicalEditor
extends SmooksFreemarkerTemplateGraphicalEditor {
    public static final String ID = "__smooks_freemarker_csv_template_graphical_editpart";
    private IAutoLayout autoLayout = null;

    public SmooksFreemarkerCSVTemplateGraphicalEditor(ISmooksModelProvider provider) {
        super(provider);
    }

    protected void autoLayoutWhenCommandChange(Command command) {
        Collection affectedObjects = command.getAffectedObjects();
        for (Object object : affectedObjects) {
            TaskType task;
            if (!(object instanceof ParamType)) continue;
            EObject parent = ((ParamType)object).eContainer();
            if (!"csvFields".equals(((ParamType)object).getName()) || !(parent instanceof Freemarker) || (task = this.getTaskType()) == null || !task.inTheTask(parent)) continue;
            this.autoLayout(true);
            break;
        }
    }

    protected EditPartFactory createEdtiPartFactory() {
        return super.createEdtiPartFactory();
    }

    protected void validateTemplate(String type, AbstractSmooksGraphicalModel templateGraphModel) {
        if ("CSV".equals(type)) {
            this.validateCSVTemplate(templateGraphModel);
        }
    }

    protected void validateCSVTemplate(AbstractSmooksGraphicalModel templateGraphModel) {
        char quote;
        int s = -1;
        Object data = templateGraphModel.getData();
        char seperator = SmooksModelUtils.getFreemarkerCSVSeperator((Freemarker)((Freemarker)(data = AdapterFactoryEditingDomain.unwrap((Object)data))));
        if (seperator == '\u0000') {
            templateGraphModel.getMessage().add(Messages.SmooksFreemarkerTemplateGraphicalEditor_Warning_Separator_Empty);
            s = 2;
        }
        if ((quote = SmooksModelUtils.getFreemarkerCSVQuote((Freemarker)((Freemarker)data))) == '\u0000') {
            templateGraphModel.getMessage().add(Messages.SmooksFreemarkerTemplateGraphicalEditor_Warning_Quote_Empty);
            s = 2;
        }
        String[] fields = SmooksModelUtils.getFreemarkerCSVFileds((Freemarker)((Freemarker)data));
        boolean missFields = false;
        if (fields == null) {
            missFields = true;
        }
        if (s != -1) {
            templateGraphModel.setSeverity(s);
        }
        List<AbstractSmooksGraphicalModel> csvRecordNode = templateGraphModel.getChildren();
        for (AbstractSmooksGraphicalModel csvRecordGraphModel : csvRecordNode) {
            List<TreeNodeConnection> collectionConnections;
            if (missFields) {
                csvRecordGraphModel.getMessage().add(Messages.SmooksFreemarkerTemplateGraphicalEditor_Warning_CSV_Fields_Empty);
                csvRecordGraphModel.setSeverity(2);
            }
            if (!(collectionConnections = csvRecordGraphModel.getTargetConnections()).isEmpty()) continue;
            csvRecordGraphModel.addMessage(Messages.SmooksFreemarkerTemplateGraphicalEditor_Warning_Must_Link_to_Collection);
            csvRecordGraphModel.setSeverity(2);
            List<AbstractSmooksGraphicalModel> csvFields = csvRecordGraphModel.getChildren();
            for (AbstractSmooksGraphicalModel csvFieldsGModel : csvFields) {
                csvFieldsGModel.addMessage(Messages.SmooksFreemarkerTemplateGraphicalEditor_Warning_Must_Link_CSV_Record);
                csvFieldsGModel.setSeverity(4);
            }
        }
    }

    public IAutoLayout getAutoLayout() {
        if (this.autoLayout == null) {
            this.autoLayout = new FreemarkerAutoLayout();
        }
        return this.autoLayout;
    }

    protected void createActions() {
        super.createActions();
        FreemarkerActionCreator creator = new FreemarkerActionCreator();
        creator.registActions(this.getActionRegistry(), this.getSelectionActions(), (IEditorPart)this, this.smooksModelProvider);
    }

    public String getID() {
        return "__smooks_freemarker_template_graphical_editpart";
    }
}

