/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.smooks.graphical.wizard.Messages;
import org.jboss.tools.smooks.graphical.wizard.TemplateMessageTypeWizardNode;
import org.jboss.tools.smooks.graphical.wizard.freemarker.FreemarkerCSVTemplateCreationWizard;
import org.jboss.tools.smooks.graphical.wizard.freemarker.FreemarkerXMLTemplateCreationWizard;

public class TemplateWizardSelectionPage
extends WizardSelectionPage {
    List<TemplateMessageTypeWizardNode> registedWizard = new ArrayList<TemplateMessageTypeWizardNode>();
    private Label desLabel;

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        main.setLayout((Layout)gridLayout);
        Label label = new Label(main, 0);
        label.setText(Messages.TemplateWizardSelectionPage_Message_Type_Label);
        final Combo combo = new Combo(main, 2056);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                TemplateMessageTypeWizardNode node = TemplateWizardSelectionPage.this.registedWizard.get(combo.getSelectionIndex());
                TemplateWizardSelectionPage.this.setSelectedNode(node);
                TemplateWizardSelectionPage.this.updateDescriptionLabel(node);
            }
        });
        this.initInputTypeCombo(combo);
        GridData gd = new GridData(768);
        combo.setLayoutData((Object)gd);
        Composite separatorComposite = new Composite(main, 0);
        gd = new GridData();
        gd.heightHint = 12;
        separatorComposite.setLayoutData((Object)gd);
        this.desLabel = new Label(main, 0);
        gd = new GridData(768);
        this.desLabel.setLayoutData((Object)gd);
        this.setControl((Control)main);
        if (!this.registedWizard.isEmpty()) {
            combo.select(0);
            TemplateMessageTypeWizardNode node = this.registedWizard.get(combo.getSelectionIndex());
            this.setSelectedNode(node);
            this.updateDescriptionLabel(node);
        }
    }

    protected void updateDescriptionLabel(TemplateMessageTypeWizardNode node) {
        String des = null;
        if (node != null) {
            des = node.getDescription();
        }
        if (des == null) {
            des = "";
        }
        this.desLabel.setText(des);
    }

    private void initInputTypeCombo(Combo combo) {
        int i = 0;
        while (i < this.registedWizard.size()) {
            TemplateMessageTypeWizardNode type = this.registedWizard.get(i);
            combo.add(type.getName());
            ++i;
        }
    }

    public IWizardPage getNextPage() {
        if (this.getSelectedNode() == null) {
            return null;
        }
        boolean isCreated = this.getSelectedNode().isContentCreated();
        IWizard wizard = this.getSelectedNode().getWizard();
        if (wizard == null) {
            this.setSelectedNode(null);
            return null;
        }
        if (!isCreated) {
            wizard.addPages();
        }
        return wizard.getStartingPage();
    }

    public TemplateWizardSelectionPage(String pageName) {
        super(pageName);
        this.setDescription("Choose \"Message Type\" .");
        this.setTitle("Message Type Selection");
        TemplateMessageTypeWizardNode csvTypeNode = new TemplateMessageTypeWizardNode();
        csvTypeNode.setName(Messages.TemplateWizardSelectionPage_CSV_Node);
        csvTypeNode.setWizard((IWizard)new FreemarkerCSVTemplateCreationWizard());
        TemplateMessageTypeWizardNode xmlTypeNode = new TemplateMessageTypeWizardNode();
        xmlTypeNode.setName(Messages.TemplateWizardSelectionPage_XML_Node);
        xmlTypeNode.setWizard((IWizard)new FreemarkerXMLTemplateCreationWizard());
        this.registedWizard.add(xmlTypeNode);
        this.registedWizard.add(csvTypeNode);
    }

    public void activeSelectionWizard() {
    }
}

