/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.wizards;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModelFactory;
import org.jboss.tools.smooks.configuration.editors.javabean.JavabeanContentProvider;
import org.jboss.tools.smooks.configuration.editors.javabean.JavabeanlabelProvider;
import org.jboss.tools.smooks.configuration.editors.uitls.JavaTypeFieldDialog;
import org.jboss.tools.smooks.configuration.editors.uitls.ProjectClassLoader;
import org.jboss.tools.smooks.graphical.wizards.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanCreationWizardPage
extends WizardPage {
    private String beanID = null;
    private String beanClass = null;
    private IJavaProject project;
    private String collectionClass = null;
    private boolean isArray = false;
    private boolean isCollection = false;
    private List<String> exsitingBeanIDs = null;
    private JavaBeanModel javaBeanModel = null;
    private CheckboxTreeViewer viewer;
    private Button arrayButton;
    private Button collectionClassBrowseButton;
    private Text colllectionClassText;

    public JavaBeanCreationWizardPage(String pageName, String title, ImageDescriptor titleImage, IJavaProject project, List<String> exsitingBeanIDs) {
        super(pageName, title, titleImage);
        this.project = project;
        this.exsitingBeanIDs = exsitingBeanIDs;
        this.setTitle(Messages.JavaBeanCreationWizardPage_WizardTitle);
        this.setDescription(Messages.JavaBeanCreationWizardPage_WizardDes);
    }

    public JavaBeanCreationWizardPage(String pageName, IJavaProject project, List<String> exsitingBeanIDs) {
        super(pageName);
        this.project = project;
        this.exsitingBeanIDs = exsitingBeanIDs;
        this.setTitle(Messages.JavaBeanCreationWizardPage_WizardTitle);
        this.setDescription(Messages.JavaBeanCreationWizardPage_WizardDes);
    }

    public JavaBeanModel getJavaBeanModel() {
        return this.javaBeanModel;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        mainComposite.setLayout((Layout)gl);
        mainComposite.setLayoutData((Object)gd);
        this.createBeanIDControls(mainComposite);
        this.createBeanClassControls(mainComposite);
        Label seperator = new Label(mainComposite, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 18;
        seperator.setLayoutData((Object)gd);
        this.createBindingPropertyViewer(mainComposite);
        this.setControl((Control)mainComposite);
        this.setPageComplete(false);
    }

    private void createBindingPropertyViewer(Composite mainComposite) {
        GridData gd = new GridData(1808);
        this.viewer = new CheckboxTreeViewer(mainComposite, 2048);
        gd.horizontalSpan = 2;
        gd.heightHint = 250;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new JavabeanContentProvider(){

            public boolean hasChildren(Object bean) {
                return super.hasChildren(bean);
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new JavabeanlabelProvider());
        this.viewer.addTreeListener(new ITreeViewerListener(){
            private Map<String, Object> expandRecord = new HashMap<String, Object>();

            public void treeExpanded(TreeExpansionEvent event) {
                Object key;
                Object element = event.getElement();
                if (element instanceof TreeItem) {
                    element = ((TreeItem)element).getData();
                }
                if (element instanceof JavaBeanModel && (key = this.expandRecord.get(((JavaBeanModel)element).getID().toString())) == null) {
                    this.expandRecord.put(((JavaBeanModel)element).getID().toString(), new Object());
                    if (JavaBeanCreationWizardPage.this.viewer.getChecked(element)) {
                        for (IXMLStructuredObject child : ((JavaBeanModel)element).getChildren()) {
                            JavaBeanCreationWizardPage.this.viewer.setChecked((Object)child, true);
                        }
                    }
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                CheckboxTreeViewer viewer = (CheckboxTreeViewer)event.getSource();
                boolean checked = event.getChecked();
                if (checked) {
                    this.checkParents(element, viewer);
                    this.checkChildren((JavaBeanModel)element, true);
                } else {
                    this.unCheckChildren(element, viewer);
                }
            }

            private void unCheckChildren(Object element, CheckboxTreeViewer viewer) {
                ITreeContentProvider provider = (ITreeContentProvider)viewer.getContentProvider();
                if (element instanceof JavaBeanModel && provider.hasChildren(element) && ((JavaBeanModel)element).isExpaned()) {
                    Object[] children = provider.getChildren(element);
                    int i = 0;
                    while (i < children.length) {
                        Object child = children[i];
                        viewer.setChecked(child, false);
                        this.unCheckChildren(child, viewer);
                        ++i;
                    }
                }
            }

            private void checkChildren(JavaBeanModel model, boolean flag) {
                if (model.isExpaned()) {
                    for (JavaBeanModel javaBeanModel : model.getChildren()) {
                        JavaBeanCreationWizardPage.this.viewer.setChecked((Object)javaBeanModel, flag);
                        this.checkChildren(javaBeanModel, flag);
                    }
                }
            }

            private void checkParents(Object element, CheckboxTreeViewer viewer) {
                ITreeContentProvider provider = (ITreeContentProvider)viewer.getContentProvider();
                Object parent = provider.getParent(element);
                if (parent != null && !viewer.getChecked(parent)) {
                    viewer.setChecked(parent, true);
                    this.checkParents(parent, viewer);
                }
            }
        });
    }

    public Object[] getSelectionProperties() {
        if (this.viewer != null) {
            return this.viewer.getCheckedElements();
        }
        return null;
    }

    private void createBeanTypeControls(Composite mainComposite) {
        Label beanTypeLabel = new Label(mainComposite, 0);
        beanTypeLabel.setText(Messages.JavaBeanCreationWizardPage_BeanTypeLabel);
        Composite composite = new Composite(mainComposite, 0);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)gl);
        this.arrayButton = new Button(composite, 32);
        this.arrayButton.setText(Messages.JavaBeanCreationWizardPage_ArrayButtonText);
        final Button collectionButton = new Button(composite, 32);
        collectionButton.setText(Messages.JavaBeanCreationWizardPage_CollectionButtonLabel);
        Label beanClassLabel = new Label(mainComposite, 0);
        beanClassLabel.setText(Messages.JavaBeanCreationWizardPage_CollectionClassLabel);
        Composite beanClassComposite = new Composite(mainComposite, 0);
        GridLayout gl1 = new GridLayout();
        gl1.numColumns = 2;
        gl1.marginHeight = 0;
        gl1.marginWidth = 0;
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        beanClassComposite.setLayoutData((Object)gd);
        beanClassComposite.setLayout((Layout)gl);
        this.colllectionClassText = new Text(beanClassComposite, 2048);
        gd = new GridData(768);
        this.colllectionClassText.setLayoutData((Object)gd);
        this.colllectionClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.getSource();
                JavaBeanCreationWizardPage.this.collectionClass = t.getText();
                JavaBeanCreationWizardPage.this.refreshJavaBeanModel();
                JavaBeanCreationWizardPage.this.updateWizardPageStatus();
            }
        });
        this.colllectionClassText.setEnabled(false);
        beanClassComposite.setLayoutData((Object)gd);
        this.collectionClassBrowseButton = new Button(beanClassComposite, 0);
        this.collectionClassBrowseButton.setText(Messages.JavaBeanCreationWizardPage_BrowseButtonLabel);
        this.collectionClassBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String classString = JavaTypeFieldDialog.openJavaTypeDialog(JavaBeanCreationWizardPage.this.getShell(), JavaBeanCreationWizardPage.this.project);
                JavaBeanCreationWizardPage.this.colllectionClassText.setText(classString);
            }
        });
        this.collectionClassBrowseButton.setEnabled(false);
        this.arrayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    JavaBeanCreationWizardPage.this.isArray = true;
                    collectionButton.setSelection(false);
                    JavaBeanCreationWizardPage.this.isCollection = false;
                    JavaBeanCreationWizardPage.this.collectionClassBrowseButton.setEnabled(false);
                    JavaBeanCreationWizardPage.this.colllectionClassText.setEnabled(false);
                } else {
                    JavaBeanCreationWizardPage.this.isArray = false;
                }
                JavaBeanCreationWizardPage.this.refreshJavaBeanModel();
                JavaBeanCreationWizardPage.this.updateWizardPageStatus();
            }
        });
        collectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    JavaBeanCreationWizardPage.this.isCollection = true;
                    JavaBeanCreationWizardPage.this.arrayButton.setSelection(false);
                    JavaBeanCreationWizardPage.this.isArray = false;
                    JavaBeanCreationWizardPage.this.collectionClassBrowseButton.setEnabled(true);
                    JavaBeanCreationWizardPage.this.colllectionClassText.setEnabled(true);
                } else {
                    JavaBeanCreationWizardPage.this.isCollection = false;
                    JavaBeanCreationWizardPage.this.collectionClassBrowseButton.setEnabled(false);
                    JavaBeanCreationWizardPage.this.colllectionClassText.setEnabled(false);
                }
                JavaBeanCreationWizardPage.this.updateWizardPageStatus();
                JavaBeanCreationWizardPage.this.viewer.setInput((Object)"");
            }
        });
        collectionButton.setVisible(false);
    }

    protected void refreshJavaBeanModel() {
        if (this.beanClass == null || "".equals(this.beanClass.trim())) {
            this.viewer.setInput((Object)"");
        } else {
            try {
                ProjectClassLoader loader = new ProjectClassLoader(this.project);
                this.javaBeanModel = null;
                this.isCollection = this.isCollectionClass(this.beanClass);
                Class<?> clazz = loader.loadClass(this.beanClass);
                this.javaBeanModel = JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(clazz);
                if (this.javaBeanModel != null) {
                    if (this.beanID != null) {
                        this.javaBeanModel.setName(this.beanID);
                    }
                    if (!this.isCollection) {
                        this.viewer.setInput(this.javaBeanModel.getChildren());
                    }
                    this.viewer.setCheckedElements(this.javaBeanModel.getChildren().toArray());
                } else {
                    this.viewer.setInput((Object)"");
                }
            }
            catch (JavaModelException javaModelException) {
                this.viewer.setInput((Object)"");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.viewer.setInput((Object)"");
            }
        }
    }

    private void createBeanClassControls(Composite mainComposite) {
        Label beanClassLabel = new Label(mainComposite, 0);
        beanClassLabel.setText(Messages.JavaBeanCreationWizardPage_BeanClassLabel);
        Composite beanClassComposite = new Composite(mainComposite, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        beanClassComposite.setLayout((Layout)gl);
        final Text beanClassText = new Text(beanClassComposite, 2048);
        GridData gd = new GridData(768);
        beanClassText.setLayoutData((Object)gd);
        beanClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.getSource();
                JavaBeanCreationWizardPage.this.beanClass = t.getText();
                if (JavaBeanCreationWizardPage.this.beanClass != null) {
                    JavaBeanCreationWizardPage.this.beanClass = JavaBeanCreationWizardPage.this.beanClass.trim();
                }
                JavaBeanCreationWizardPage.this.isCollection = JavaBeanCreationWizardPage.this.isCollectionClass(JavaBeanCreationWizardPage.this.beanClass);
                JavaBeanCreationWizardPage.this.refreshJavaBeanModel();
                JavaBeanCreationWizardPage.this.updateWizardPageStatus();
            }
        });
        beanClassComposite.setLayoutData((Object)gd);
        Button javaTypeBrowseButton = new Button(beanClassComposite, 0);
        javaTypeBrowseButton.setText(Messages.JavaBeanCreationWizardPage_BrowseButtonLabel);
        javaTypeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String classString = JavaTypeFieldDialog.openJavaTypeDialog(JavaBeanCreationWizardPage.this.getShell(), JavaBeanCreationWizardPage.this.project, 2);
                beanClassText.setText(classString);
            }
        });
    }

    private boolean isCollectionClass(String classString) {
        if (this.project != null) {
            try {
                ProjectClassLoader loader = new ProjectClassLoader(this.project);
                Class<?> clazz = loader.loadClass(classString);
                if (Collection.class.isAssignableFrom(clazz)) {
                    return true;
                }
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    private void createBeanIDControls(Composite mainComposite) {
        Label beanIDLabel = new Label(mainComposite, 0);
        beanIDLabel.setText(Messages.JavaBeanCreationWizardPage_BeanIDLabel);
        Text beanIDText = new Text(mainComposite, 2048);
        GridData gd = new GridData(768);
        beanIDText.setLayoutData((Object)gd);
        beanIDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.getSource();
                JavaBeanCreationWizardPage.this.beanID = t.getText();
                JavaBeanCreationWizardPage.this.updateWizardPageStatus();
            }
        });
    }

    protected void updateWizardPageStatus() {
        String error = null;
        if (this.beanID == null || "".equals(this.beanID.trim())) {
            error = Messages.JavaBeanCreationWizardPage_BeanIDEmptyErrorMessage;
        } else if (this.exsitingBeanIDs != null) {
            this.beanID = this.beanID.trim();
            for (String id : this.exsitingBeanIDs) {
                if (!id.equals(this.beanID)) continue;
                error = String.valueOf(Messages.JavaBeanCreationWizardPage_BeanIDDuplicateErrorMessage1) + this.beanID + Messages.JavaBeanCreationWizardPage_BeanIDDuplicateErrorMessage2;
            }
        }
        if (this.beanClass == null || "".equals(this.beanClass.trim())) {
            error = Messages.JavaBeanCreationWizardPage_BeanClassEmptyErrorMessage;
        } else {
            try {
                this.beanClass = this.beanClass.trim();
                ProjectClassLoader loader = new ProjectClassLoader(this.project);
                Class<?> clazz = loader.loadClass(this.beanClass);
                if (Modifier.isAbstract((int)clazz.getModifiers())) {
                    error = Messages.JavaBeanCreationWizardPage_Error_Abstract;
                } else {
                    try {
                        clazz.getConstructor(null);
                    }
                    catch (SecurityException securityException) {
                        error = Messages.JavaBeanCreationWizardPage_Error_Cannot_Be_Instantiated;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        error = Messages.JavaBeanCreationWizardPage_Error_Class_Needs_Public_Default_Const;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                error = String.valueOf(Messages.JavaBeanCreationWizardPage_CatFindClassErrorMessage1) + this.beanClass + Messages.JavaBeanCreationWizardPage_27;
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }
}

