/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.launch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.smooks.configuration.ProcessNodeType;
import org.jboss.tools.smooks.configuration.RuntimeDependency;
import org.jboss.tools.smooks.configuration.RuntimeMetadata;
import org.jboss.tools.smooks.core.SmooksInputType;
import org.jboss.tools.smooks.launch.Messages;
import org.jboss.tools.smooks.launch.SmooksLauncher;
import org.jboss.tools.smooks.launch.serialize.MarshallingStrategy;
import org.jboss.tools.smooks.launch.serialize.ObjectSerializer;
import org.jboss.tools.smooks.launch.serialize.XPathMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksLaunchConfigurationDelegate
extends JUnitLaunchConfigurationDelegate {
    private static final String PLUGIN_ID = "org.jboss.tools.smooks.ui.smooksLauncher";

    public void launch(ILaunchConfiguration launchConfig, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(launchConfig);
        IProject project = javaProject.getProject();
        String smooksConfigName = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        String[] baseClasspath = this.getClasspath(launchConfig);
        RuntimeMetadata launchMetadata = new RuntimeMetadata();
        launchMetadata.setSmooksConfig(project.findMember(smooksConfigName));
        if (!launchMetadata.isValidSmooksConfig()) {
            this.displayError(smooksConfigName, launchMetadata.getErrorMessage());
            return;
        }
        List<RuntimeDependency> dependencies = launchMetadata.getDependencies();
        URLClassLoader projectClassLoader = this.toURLClassLoader(baseClasspath);
        for (RuntimeDependency dependency : dependencies) {
            if (dependency.isOnProjectClasspath(projectClassLoader)) continue;
            this.displayError(smooksConfigName, String.valueOf(Messages.SmooksLaunchConfigurationDelegate_Error_missing_artifact) + dependency.getGroupId() + ":" + dependency.getArtifactId() + Messages.SmooksLaunchConfigurationDelegate_Error_missing_artifact2);
            return;
        }
        IVMRunner runner = this.getVMRunner(launchConfig, mode);
        VMRunnerConfiguration runConfig = this.buildRunnerConfig(launchConfig, baseClasspath);
        if (monitor.isCanceled()) {
            return;
        }
        String inputType = launchMetadata.getInputType();
        String inputPath = launchMetadata.getInputFile().getAbsolutePath();
        String nodeTypes = launchMetadata.getNodeTypesString();
        runConfig.setProgramArguments(new String[]{launchMetadata.getConfigFile().getAbsolutePath(), inputType, inputPath, nodeTypes});
        runner.run(runConfig, launch, monitor);
    }

    private void displayError(final String smooksConfigName, final String errorMessage) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                Shell shell = display.getActiveShell();
                ErrorDialog.openError((Shell)shell, (String)Messages.SmooksLaunchConfigurationDelegate_Error_Title, (String)(String.valueOf(Messages.SmooksLaunchConfigurationDelegate_Error_launching) + smooksConfigName + "'."), (IStatus)new Status(4, SmooksLaunchConfigurationDelegate.PLUGIN_ID, 4, errorMessage, (Throwable)new Exception()));
            }
        });
    }

    private VMRunnerConfiguration buildRunnerConfig(ILaunchConfiguration launchConfig, String[] baseClasspath) throws CoreException {
        ArrayList<String> classpath = new ArrayList<String>(Arrays.asList(baseClasspath));
        File wsTempClasses = this.copyLauncherResourcesToFilesys();
        classpath.add(wsTempClasses.getAbsolutePath());
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(SmooksLauncher.class.getName(), classpath.toArray(new String[classpath.size()]));
        String[] envp = this.getEnvironment(launchConfig);
        ArrayList<String> vmArguments = new ArrayList<String>();
        String vmArgs = this.getVMArguments(launchConfig);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, "");
        File workingDir = this.verifyWorkingDirectory(launchConfig);
        vmArguments.addAll(Arrays.asList(execArgs.getVMArgumentsArray()));
        runConfig.setVMArguments(vmArguments.toArray(new String[vmArguments.size()]));
        runConfig.setEnvironment(envp);
        if (workingDir != null) {
            runConfig.setWorkingDirectory(workingDir.getAbsolutePath());
        }
        runConfig.setVMSpecificAttributesMap(this.getVMSpecificAttributesMap(launchConfig));
        runConfig.setBootClassPath(this.getBootpath(launchConfig));
        return runConfig;
    }

    private File copyLauncherResourcesToFilesys() throws CoreException {
        File wsRootDir = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toFile();
        File wsTempClasses = new File(wsRootDir, "temp/launcher/classes");
        this.writeClassToFilesys(SmooksLauncher.class, wsTempClasses);
        this.writeClassToFilesys(SmooksInputType.class, wsTempClasses);
        this.writeClassToFilesys(ProcessNodeType.class, wsTempClasses);
        this.writeClassToFilesys(ObjectSerializer.class, wsTempClasses);
        this.writeClassToFilesys(MarshallingStrategy.class, wsTempClasses);
        this.writeClassToFilesys(XPathMarshaller.class, wsTempClasses);
        Properties localizedMessages = new Properties();
        localizedMessages.setProperty("SmooksLauncher_Error_Do_Not_Support_Java_Inputs", Messages.SmooksLauncher_Error_Do_Not_Support_Java_Inputs);
        localizedMessages.setProperty("SmooksLauncher_Error_Expected_Four_Args", Messages.SmooksLauncher_Error_Expected_Four_Args);
        localizedMessages.setProperty("SmooksLauncher_Java_Mapping_Results", Messages.SmooksLauncher_Java_Mapping_Results);
        localizedMessages.setProperty("SmooksLauncher_Templating_To_StreamResult", Messages.SmooksLauncher_Templating_To_StreamResult);
        localizedMessages.setProperty("SmooksLauncher_Nothing_To_Display", Messages.SmooksLauncher_Nothing_To_Display);
        try {
            FileOutputStream messagesOutStream = this.getFilesysOutStream("localizedMessage.properties", SmooksLauncher.class, wsTempClasses);
            try {
                localizedMessages.store(messagesOutStream, "Localized messages...");
            }
            finally {
                messagesOutStream.close();
            }
        }
        catch (IOException e) {
            new CoreException((IStatus)new Status(4, PLUGIN_ID, 4, Messages.SmooksLaunchConfigurationDelegate_Error_Copying_Smooks_Launcher, (Throwable)e));
        }
        return wsTempClasses;
    }

    private void writeClassToFilesys(Class<?> theClass, File toDir) throws CoreException {
        String className = String.valueOf(theClass.getSimpleName()) + ".class";
        this.writeResourceToFilesys(className, theClass, toDir);
    }

    private void writeResourceToFilesys(String resource, Class<?> refClass, File toDir) {
        block15: {
            String packagePath = refClass.getPackage().getName().replace(".", "/");
            String resourcePath = "/" + packagePath + Messages.SmooksLaunchConfigurationDelegate_11 + resource;
            URL resourceURI = refClass.getResource(resourcePath);
            if (resourceURI != null) {
                try {
                    InputStream resourceStream = resourceURI.openStream();
                    if (resourceStream == null) break block15;
                    try {
                        File resourceOutFile = new File(toDir, resourcePath);
                        File resourcePackage = resourceOutFile.getParentFile();
                        resourcePackage.mkdirs();
                        if (!resourcePackage.exists()) break block15;
                        FileOutputStream resourceOutStream = new FileOutputStream(resourceOutFile);
                        try {
                            byte[] readBuf = new byte[100];
                            int readCount = 0;
                            while (readCount != -1) {
                                readCount = resourceStream.read(readBuf);
                                if (readCount == -1) continue;
                                resourceOutStream.write(readBuf, 0, readCount);
                            }
                        }
                        finally {
                            try {
                                resourceOutStream.flush();
                            }
                            finally {
                                resourceOutStream.close();
                            }
                        }
                    }
                    finally {
                        resourceStream.close();
                    }
                }
                catch (IOException e) {
                    new CoreException((IStatus)new Status(4, PLUGIN_ID, 4, Messages.SmooksLaunchConfigurationDelegate_Error_Copying_Smooks_Launcher, (Throwable)e));
                }
            }
        }
    }

    private FileOutputStream getFilesysOutStream(String resource, Class<?> refClass, File toDir) throws FileNotFoundException {
        String packagePath = refClass.getPackage().getName().replace(".", "/");
        String resourcePath = "/" + packagePath + "/" + resource;
        File resourceOutFile = new File(toDir, resourcePath);
        File resourcePackage = resourceOutFile.getParentFile();
        resourcePackage.mkdirs();
        return new FileOutputStream(resourceOutFile);
    }

    private URLClassLoader toURLClassLoader(String[] baseClasspath) {
        URL[] classPathURLs = new URL[baseClasspath.length];
        int i = 0;
        while (i < baseClasspath.length) {
            try {
                File cpEntry = new File(baseClasspath[i]);
                classPathURLs[i] = cpEntry.toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return new URLClassLoader(classPathURLs);
    }
}

