/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.smooks.configuration.RuntimeMetadata;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.editor.AbstractSmooksFormEditor;
import org.jboss.tools.smooks.launch.ExceptionHandler;
import org.jboss.tools.smooks.launch.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksLaunchShortcut
extends JUnitLaunchShortcut {
    private static final String EMPTY_STRING = "";

    private Shell getShell() {
        return SmooksConfigurationActivator.getActiveWorkbenchShell();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private List<ILaunchConfiguration> findExistingLaunchConfigurations(ILaunchConfigurationWorkingCopy temporary) throws CoreException {
        ILaunchConfigurationType configType = temporary.getType();
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        String[] attributeToCompare = this.getAttributeNamesToCompare();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        int i = 0;
        while (i < configs.length) {
            ILaunchConfiguration config = configs[i];
            if (SmooksLaunchShortcut.hasSameAttributes(config, (ILaunchConfiguration)temporary, attributeToCompare)) {
                candidateConfigs.add(config);
            }
            ++i;
        }
        return candidateConfigs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasSameAttributes(ILaunchConfiguration config1, ILaunchConfiguration config2, String[] attributeToCompare) {
        try {
            int i = 0;
            while (true) {
                String val2;
                if (i >= attributeToCompare.length) {
                    return true;
                }
                String val1 = config1.getAttribute(attributeToCompare[i], EMPTY_STRING);
                if (!val1.equals(val2 = config2.getAttribute(attributeToCompare[i], EMPTY_STRING))) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.launch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IFile file;
        if (editor.getEditorInput() != null && editor.getEditorInput() instanceof IFileEditorInput && (file = ((IFileEditorInput)editor.getEditorInput()).getFile()) != null) {
            this.launch(new Object[]{file}, mode);
        }
    }

    private void launch(Object[] elements, String mode) {
        try {
            IFile elementToLaunch = null;
            if (elements.length == 1) {
                Object selected = elements[0];
                if (!(selected instanceof IFile) && selected instanceof IAdaptable) {
                    selected = ((IAdaptable)selected).getAdapter(IFile.class);
                }
                if (selected instanceof IFile) {
                    elementToLaunch = (IFile)selected;
                }
                RuntimeMetadata metadata = new RuntimeMetadata();
                metadata.setSmooksConfig((IResource)elementToLaunch);
                if (!metadata.isValidSmooksConfig()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.SmooksLaunchShortcut_Title_Launch_Failed, (String)metadata.getErrorMessage());
                    return;
                }
            }
            this.performLaunch(elementToLaunch, mode);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), Messages.SmooksLaunchShortcut_Title_Launch_Failed, Messages.SmooksLaunchShortcut_Exception_Occurred);
        }
    }

    private void performLaunch(IFile file, String mode) throws InterruptedException, CoreException {
        ILaunchConfigurationWorkingCopy temparary = this.createLaunchConfiguration(file);
        ILaunchConfiguration config = this.findExistingLaunchConfiguration(temparary, mode);
        if (config == null) {
            config = temparary.doSave();
        }
        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
    }

    private ILaunchConfiguration findExistingLaunchConfiguration(ILaunchConfigurationWorkingCopy temporary, String mode) throws InterruptedException, CoreException {
        List<ILaunchConfiguration> candidateConfigs = this.findExistingLaunchConfigurations(temporary);
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 0) {
            return null;
        }
        if (candidateCount == 1) {
            return candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    private ILaunchConfiguration chooseConfiguration(List<?> configList, String mode) throws InterruptedException {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.SmooksLaunchShortcut_Title_Select_Config);
        if (mode.equals("run")) {
            dialog.setMessage(Messages.SmooksLaunchShortcut_Message_Select_Config);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        throw new InterruptedException();
    }

    protected String getLaunchConfigurationTypeId() {
        return "org.jboss.tools.smooks.ui.smooksLauncher";
    }

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IFile file) throws CoreException {
        if (file != null) {
            ILaunchConfigurationType configType = this.getLaunchManager().getLaunchConfigurationType(this.getLaunchConfigurationTypeId());
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(file.getName()));
            IProject project = file.getProject();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, file.getProjectRelativePath().toPortableString());
            return wc;
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editor) {
        IEditorInput editorInput;
        if (editor instanceof AbstractSmooksFormEditor && (editorInput = editor.getEditorInput()) instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editor) {
        IEditorInput editorInput;
        if (editor instanceof AbstractSmooksFormEditor && (editorInput = editor.getEditorInput()) instanceof FileEditorInput) {
            try {
                ILaunchConfigurationWorkingCopy temparary = this.createLaunchConfiguration(((FileEditorInput)editorInput).getFile());
                ILaunchConfiguration existingConfig = this.findExistingLaunchConfiguration(temparary, "run");
                if (existingConfig == null) {
                    existingConfig = temparary.doSave();
                }
                return new ILaunchConfiguration[]{existingConfig};
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.getShell(), Messages.SmooksLaunchShortcut_Title_Launch_Failed, Messages.SmooksLaunchShortcut_Exception_Occurred);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

