/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.smooks.configuration.RuntimeMetadata;
import org.jboss.tools.smooks.editor.AbstractSmooksFormEditor;
import org.jboss.tools.smooks.launch.Messages;

public class SmooksRunTab
extends AbstractLaunchConfigurationTab {
    private Text fProjText;
    private Button fProjButton;
    private Text fConfigurationText;
    private Button fSearchButton;
    private RuntimeMetadata launchMetaData = new RuntimeMetadata();

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        this.createFormElements(comp);
        Dialog.applyDialogFont((Control)comp);
        this.validatePage();
    }

    private void createFormElements(Composite comp) {
        GridData gd = new GridData();
        Label fProjLabel = new Label(comp, 0);
        gd.horizontalIndent = 10;
        fProjLabel.setText(Messages.SmooksRunTab_Label_Project);
        fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(comp, 2052);
        this.fProjText.setLayoutData((Object)new GridData(768));
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                SmooksRunTab.this.validatePage();
                SmooksRunTab.this.updateLaunchConfigurationDialog();
                SmooksRunTab.this.fSearchButton.setEnabled(SmooksRunTab.this.fProjText.getText().length() > 0);
            }
        });
        this.fProjButton = new Button(comp, 8);
        this.fProjButton.setText(Messages.SmooksRunTab_Button_Browse);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SmooksRunTab.this.handleProjectButtonSelected();
            }
        });
        this.setButtonGridData(this.fProjButton);
        Label fConfigLabel = new Label(comp, 0);
        gd = new GridData();
        gd.horizontalIndent = 10;
        fConfigLabel.setLayoutData((Object)gd);
        fConfigLabel.setText(Messages.SmooksRunTab_Label_Configuration);
        this.fConfigurationText = new Text(comp, 2052);
        this.fConfigurationText.setLayoutData((Object)new GridData(768));
        this.fConfigurationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                SmooksRunTab.this.handleSmooksConfigChange();
                SmooksRunTab.this.validatePage();
                SmooksRunTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = new Button(comp, 8);
        this.fSearchButton.setEnabled(this.fProjText.getText().length() > 0);
        this.fSearchButton.setText(Messages.SmooksRunTab_Button_Search);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SmooksRunTab.this.handleSearchButtonSelected();
            }
        });
        this.setButtonGridData(this.fSearchButton);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy launchConfigWC) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        launchConfigWC.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        launchConfigWC.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        if (activePage != null) {
            IEditorInput editorInput;
            IFile file;
            IStructuredSelection ssel;
            ISelection selection;
            IEditorPart editor = activePage.getActiveEditor();
            boolean foundInNavigator = false;
            if (activePage.getActivePart().getSite().getSelectionProvider() != null && (selection = activePage.getActivePart().getSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty() && ssel.getFirstElement() instanceof IFile) {
                file = (IFile)ssel.getFirstElement();
                RuntimeMetadata metadata = new RuntimeMetadata();
                metadata.setSmooksConfig((IResource)file);
                if (metadata.isValidSmooksConfig()) {
                    String configName = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(file.getName());
                    launchConfigWC.rename(configName);
                    launchConfigWC.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, file.getProject().getName());
                    launchConfigWC.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, file.getProjectRelativePath().toString());
                    foundInNavigator = true;
                }
            }
            if (editor instanceof AbstractSmooksFormEditor && !foundInNavigator && (editorInput = editor.getEditorInput()) instanceof FileEditorInput && !foundInNavigator) {
                FileEditorInput fileEI = (FileEditorInput)editorInput;
                file = fileEI.getFile();
                String configName = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(editor.getTitle());
                launchConfigWC.rename(configName);
                launchConfigWC.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, file.getProject().getName());
                launchConfigWC.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, file.getProjectRelativePath().toString());
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fProjText.setText(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""));
            this.fConfigurationText.setText(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, ""));
        }
        catch (CoreException coreException) {}
        IResource smooksConfig = this.getSmooksConfig();
        if (smooksConfig != null) {
            this.launchMetaData.setSmooksConfig(smooksConfig);
        }
        this.validatePage();
    }

    public void performApply(ILaunchConfigurationWorkingCopy launchConfigWC) {
        launchConfigWC.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        launchConfigWC.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fConfigurationText.getText());
    }

    private void handleSearchButtonSelected() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(this.fProjText.getText());
        if (SmooksRunTab.assertProjectOK(project)) {
            dialog.setInput((Object)project);
        } else {
            dialog.setInput((Object)root);
        }
        dialog.setTitle(Messages.SmooksRunTab_Dialog_Title_Select_Config);
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IResource resource = (IResource)results[0];
        this.fConfigurationText.setText(resource.getProjectRelativePath().toString());
    }

    private void handleSmooksConfigChange() {
        this.launchMetaData.setSmooksConfig(this.getSmooksConfig());
    }

    private void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    private IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)SmooksRunTab.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(Messages.SmooksRunTab_Title_Select_Config);
        dialog.setMessage(Messages.SmooksRunTab_Message_Select_Config);
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)SmooksRunTab.getWorkspaceRoot());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.validatePage();
        return this.getErrorMessage() == null;
    }

    private void validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() == 0) {
            this.setErrorMessage(Messages.SmooksRunTab_Error_Need_Project_Name);
            return;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validatePath(String.valueOf('/') + projectName, 4);
        if (!status.isOK() || !Path.ROOT.isValidSegment(projectName)) {
            this.setErrorMessage(String.valueOf(Messages.SmooksRunTab_Error_Invalid_Project_Name) + projectName + "'.");
            return;
        }
        IProject project = SmooksRunTab.getWorkspaceRoot().getProject(projectName);
        if (!project.exists()) {
            this.setErrorMessage(String.valueOf(Messages.SmooksRunTab_Error_Unknown_Project_Name) + projectName + "'.");
            return;
        }
        String configName = this.fConfigurationText.getText().trim();
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                this.setErrorMessage(String.valueOf(Messages.SmooksRunTab_Error_Not_A_Java_Project) + projectName + Messages.SmooksRunTab_Error_Not_A_Java_Project2);
                return;
            }
            if (configName.length() == 0) {
                this.setErrorMessage(Messages.SmooksRunTab_Error_Smooks_Configuration_Missing);
                return;
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(String.valueOf(Messages.SmooksRunTab_Error_Validation) + e.getMessage());
        }
        if (!this.launchMetaData.isValidSmooksConfig()) {
            this.setErrorMessage(this.launchMetaData.getErrorMessage());
        }
    }

    private IResource getSmooksConfig() {
        String projectName = this.fProjText.getText();
        String configName = this.fConfigurationText.getText();
        return SmooksRunTab.getSmooksConfig(projectName, configName);
    }

    public static IResource getSmooksConfig(ILaunchConfiguration launchConfig) {
        try {
            String projectName = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            String configName = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            return SmooksRunTab.getSmooksConfig(projectName, configName);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static IResource getSmooksConfig(String projectName, String configName) {
        IProject project;
        if (projectName != null && !projectName.trim().equals("") && configName != null && !configName.trim().equals("") && SmooksRunTab.assertProjectOK(project = SmooksRunTab.getWorkspaceRoot().getProject(projectName))) {
            return project.findMember(configName);
        }
        return null;
    }

    public String getName() {
        return Messages.SmooksRunTab_Tab_Name;
    }

    private void setButtonGridData(Button button) {
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
    }

    private static boolean assertProjectOK(IProject project) {
        return project != null && project.exists() && project.isAccessible() && !project.isHidden();
    }
}

