/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class BindingFilesValidationCommand
extends AbstractDataModelOperation {
    private ServiceModel model;

    public BindingFilesValidationCommand(ServiceModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        XMLReader reader = null;
        try {
            SAXParser parser = spf.newSAXParser();
            reader = parser.getXMLReader();
        }
        catch (Exception exception) {
            return Status.OK_STATUS;
        }
        for (String filename : this.model.getBindingFiles()) {
            IStatus bStatus = this.validateXMLFile(reader, filename);
            if (bStatus == Status.OK_STATUS) continue;
            return bStatus;
        }
        return status;
    }

    private IStatus validateXMLFile(XMLReader reader, String filename) {
        try {
            InputSource is = new InputSource(filename);
            reader.parse(is);
        }
        catch (SAXException e) {
            return StatusUtils.errorStatus((String)NLS.bind((String)JBossWSCreationCoreMessages.Error_Message_Invalid_Binding_File, (Object[])new String[]{filename, e.getLocalizedMessage()}), (Throwable)e);
        }
        catch (IOException e) {
            return StatusUtils.errorStatus((String)NLS.bind((String)JBossWSCreationCoreMessages.Error_Message_Invalid_Binding_File, (Object[])new String[]{filename, e.getLocalizedMessage()}), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

