/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.ws.creation.core.commands.AbstractGenerateCodeCommand;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.utils.ClasspathParser;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java2WSCommand
extends AbstractGenerateCodeCommand {
    private static String WSPROVIDER_FILE_NAME_LINUX = "wsprovide.sh";
    private static String WSPROVIDER_FILE_NAME_WIN = "wsprovide.bat";

    public Java2WSCommand(ServiceModel model) {
        super(model);
    }

    @Override
    protected String getCommandLineFileName_linux() {
        return WSPROVIDER_FILE_NAME_LINUX;
    }

    @Override
    protected String getCommandLineFileName_win() {
        return WSPROVIDER_FILE_NAME_WIN;
    }

    @Override
    protected void addCommandlineArgs(List<String> command) throws IOException {
        String projectName = this.model.getWebProjectName();
        String projectRoot = JBossWSCreationUtils.getProjectRoot(projectName).toOSString();
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (this.model.isGenWSDL()) {
            command.add("-w");
        }
        command.add("-r");
        command.add(String.valueOf(projectRoot) + '/' + "wsdl");
        command.add(this.model.getServiceClasses().get(0));
        command.add("-c");
        command.add(this.getClasspath(iProject));
    }

    private String getClasspath(IProject iProject) throws IOException {
        String cpStr = ClasspathParser.getInstance().getClasspathString(iProject);
        if (this.isLongCommandLines(cpStr)) {
            File tempJar = null;
            tempJar = File.createTempFile("temp", ".jar");
            Manifest mf = new Manifest();
            cpStr = cpStr.replace(" ", "%20");
            cpStr = cpStr.replace("\\", "/");
            String[] cpArray = cpStr.split(";");
            StringBuffer cpBF = new StringBuffer();
            int i = 0;
            while (i < cpArray.length) {
                if (!cpArray[i].endsWith(".jar") && !cpArray[i].endsWith("/")) {
                    cpArray[i] = String.valueOf(cpArray[i]) + "/";
                }
                if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                    cpArray[i] = "/" + cpArray[i];
                }
                cpBF.append(cpArray[i]).append(" ");
                ++i;
            }
            cpStr = cpBF.toString();
            cpStr.trim();
            mf.getMainAttributes().put(Attributes.Name.CLASS_PATH, cpStr);
            mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.2");
            try {
                FileUtil.jar((File[])new File[0], (String)tempJar.getAbsolutePath(), (Manifest)mf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            cpStr = tempJar.getAbsolutePath();
        } else if (System.getProperty("os.name").toLowerCase().indexOf("win") < 0) {
            cpStr = cpStr.replace(";", ":");
        }
        return cpStr;
    }

    public boolean isLongCommandLines(String command) {
        if (command == null) {
            return false;
        }
        return command.length() > 1024;
    }
}

