/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.utils;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.ws.core.JBossWSCorePlugin;
import org.jboss.tools.ws.core.classpath.JBossWSRuntime;
import org.jboss.tools.ws.core.classpath.JBossWSRuntimeManager;
import org.jboss.tools.ws.core.facet.delegate.IJBossWSFacetDataModelProperties;
import org.jboss.tools.ws.core.messages.JBossWSCoreMessages;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;

public class JBossWSCreationUtils {
    static final String[] javaKeyWords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final String WEBINF = "WEB-INF";

    public static boolean isJavaKeyword(String keyword) {
        if (JBossWSCreationUtils.hasUpperCase(keyword)) {
            return false;
        }
        return Arrays.binarySearch(javaKeyWords, keyword, Collator.getInstance(Locale.ENGLISH)) >= 0;
    }

    private static boolean hasUpperCase(String nodeName) {
        if (nodeName == null) {
            return false;
        }
        int i = 0;
        while (i < nodeName.length()) {
            if (Character.isUpperCase(nodeName.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IPath getWorkspace() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }

    public static IProject getProjectByName(String project) {
        String projectString = JBossWSCreationUtils.replaceEscapecharactors(project);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(JBossWSCreationUtils.getProjectNameFromFramewokNameString(projectString));
    }

    public static IPath getProjectRoot(String project) {
        String projectString = JBossWSCreationUtils.replaceEscapecharactors(project);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(JBossWSCreationUtils.getProjectNameFromFramewokNameString(projectString)).getLocation();
    }

    public static String pathToWebProjectContainer(String project) {
        IPath projectRoot = JBossWSCreationUtils.getProjectRoot(project);
        IPath currentDynamicWebProjectDir = JBossWSCreationUtils.getWebContentRootPath(JBossWSCreationUtils.getProjectByName(project));
        IPath currentDynamicWebProjectDirWithoutProjectRoot = JBossWSCreationUtils.getWebContentRootPath(JBossWSCreationUtils.getProjectByName(project)).removeFirstSegments(1).makeAbsolute();
        if (projectRoot.toOSString().contains(JBossWSCreationUtils.getWorkspace().toOSString())) {
            return JBossWSCreationUtils.getWorkspace().append(currentDynamicWebProjectDir).toOSString();
        }
        return projectRoot.append(currentDynamicWebProjectDirWithoutProjectRoot).toOSString();
    }

    public static String pathToWebProjectContainerWEBINF(String project) {
        IPath projectRoot = JBossWSCreationUtils.getProjectRoot(project);
        IPath webContainerWEBINFDir = JBossWSCreationUtils.getWebContentRootPath(JBossWSCreationUtils.getProjectByName(project)).append(WEBINF);
        IPath webContainerWEBINFDirWithoutProjectRoot = JBossWSCreationUtils.getWebContentRootPath(JBossWSCreationUtils.getProjectByName(project)).append(WEBINF).removeFirstSegments(1).makeAbsolute();
        if (projectRoot.toOSString().contains(JBossWSCreationUtils.getWorkspace().toOSString())) {
            return JBossWSCreationUtils.getWorkspace().append(webContainerWEBINFDir).toOSString();
        }
        return projectRoot.append(webContainerWEBINFDirWithoutProjectRoot).toOSString();
    }

    private static String replaceEscapecharactors(String vulnarableString) {
        if (vulnarableString.indexOf("/") != -1) {
            vulnarableString = vulnarableString.replace('/', File.separator.charAt(0));
        }
        return vulnarableString;
    }

    private static String getProjectNameFromFramewokNameString(String frameworkProjectString) {
        if (frameworkProjectString.indexOf(JBossWSCreationUtils.getSplitCharactor()) == -1) {
            return frameworkProjectString;
        }
        return frameworkProjectString.split(JBossWSCreationUtils.getSplitCharactors())[1];
    }

    private static String getSplitCharactor() {
        if (File.separatorChar == '\\') {
            return "\\";
        }
        return File.separator;
    }

    private static String getSplitCharactors() {
        if (File.separatorChar == '\\') {
            return "\\" + File.separator;
        }
        return File.separator;
    }

    public static String classNameFromQualifiedName(String qualifiedCalssName) {
        String[] parts = (qualifiedCalssName = qualifiedCalssName.replace('.', ':')).split(":");
        if (parts.length == 0) {
            return "";
        }
        return parts[parts.length - 1];
    }

    public static IJavaProject getJavaProjectByName(String projectName) throws JavaModelException {
        IJavaProject[] projects;
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        model.open(null);
        IJavaProject[] iJavaProjectArray = projects = model.getJavaProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject proj = iJavaProjectArray[n2];
            if (proj.getProject().getName().equals(projectName)) {
                return proj;
            }
            ++n2;
        }
        return null;
    }

    public static ICompilationUnit findUnitByFileName(IJavaElement javaElem, String filePath) throws Exception {
        ICompilationUnit unit = null;
        if (!javaElem.getOpenable().isOpen()) {
            javaElem.getOpenable().open(null);
        }
        IJavaElement[] elems = null;
        if (javaElem instanceof IParent) {
            IParent parent = (IParent)javaElem;
            elems = parent.getChildren();
        }
        if (elems == null) {
            return null;
        }
        IJavaElement[] iJavaElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit compUnit;
            IJavaElement elem = iJavaElementArray[n2];
            if (elem.getElementType() == 3) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)elem;
                if (root.getKind() == 1 && (unit = JBossWSCreationUtils.findUnitByFileName(elem, filePath)) != null) {
                    return unit;
                }
            } else if (elem.getElementType() == 4 || elem.getElementType() == 2) {
                unit = JBossWSCreationUtils.findUnitByFileName(elem, filePath);
                if (unit != null) {
                    return unit;
                }
            } else if (elem.getElementType() == 5 && (compUnit = (ICompilationUnit)elem).getPath().toString().equals(filePath)) {
                compUnit.open(null);
                return compUnit;
            }
            ++n2;
        }
        return null;
    }

    public static ICompilationUnit getJavaUnitFromFile(IFile javaFile) {
        IJavaProject project;
        block3: {
            try {
                project = JBossWSCreationUtils.getJavaProjectByName(javaFile.getProject().getName());
                if (project != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return JBossWSCreationUtils.findUnitByFileName((IJavaElement)project, javaFile.getFullPath().toString());
    }

    public static boolean validateJBossWSLocation() {
        String location = JBossWSCorePlugin.getDefault().getPreferenceStore().getString(JBossWSCoreMessages.WS_Location);
        return location != null && !location.equals("");
    }

    public static String getJBossWSRuntimeLocation(IProject project) throws CoreException {
        IFacetedProject facetedPrj;
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime prjFacetRuntime;
        String isServerSupplied = project.getPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_SERVER_SUPPLIED_RUNTIME);
        String jbwsRuntimeName = project.getPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME);
        if (jbwsRuntimeName != null && !"".equals(jbwsRuntimeName) && !"true".equals(isServerSupplied)) {
            JBossWSRuntime jbws = JBossWSRuntimeManager.getInstance().findRuntimeByName(jbwsRuntimeName);
            if (jbws != null) {
                return jbws.getHomeDir();
            }
            String jbwsHomeDir = project.getPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_RNTIME_LOCATION);
            if (new File(jbwsHomeDir).exists()) {
                return jbwsHomeDir;
            }
        }
        if ((prjFacetRuntime = (facetedPrj = ProjectFacetsManager.create((IProject)project)).getPrimaryRuntime()) != null) {
            IRuntime serverRuntime = JBossWSCreationUtils.getRuntime(prjFacetRuntime);
            String runtimeTypeName = serverRuntime.getRuntimeType().getName();
            if (runtimeTypeName == null) {
                runtimeTypeName = "";
            }
            if (runtimeTypeName.toUpperCase().indexOf("JBOSS") >= 0) {
                String runtimeLocation = serverRuntime.getLocation().toOSString();
                if (runtimeLocation.endsWith("bin")) {
                    return serverRuntime.getLocation().removeLastSegments(1).toOSString();
                }
                return runtimeLocation;
            }
        }
        if (prjFacetRuntime == null) {
            JBossWSRuntime jbws = JBossWSRuntimeManager.getInstance().getDefaultRuntime();
            if (jbws != null) {
                return jbws.getHomeDir();
            }
            throw new CoreException(StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_No_Runtime_Specified));
        }
        return "";
    }

    public static boolean supportSOAP12(String projectName) {
        JBossWSRuntime jbws;
        String runtimeVersion;
        IRuntime runtime;
        IRuntimeType rt;
        IFacetedProject facetedPrj;
        block6: {
            IProject project;
            block5: {
                try {
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    if (project != null) break block5;
                    return false;
                }
                catch (CoreException coreException) {}
            }
            facetedPrj = ProjectFacetsManager.create((IProject)project);
            IProjectFacet jbossWSFacet = ProjectFacetsManager.getProjectFacet((String)"jbossws.core");
            IProjectFacetVersion fpVersion = facetedPrj.getProjectFacetVersion(jbossWSFacet);
            if (fpVersion == null || fpVersion.getVersionString().compareTo("3.0") < 0) break block6;
            return true;
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime targetRuntime = facetedPrj.getPrimaryRuntime();
        if (targetRuntime != null && (rt = (runtime = JBossWSCreationUtils.getRuntime(targetRuntime)).getRuntimeType()).getName().toUpperCase().indexOf("JBOSS") >= 0 && (runtimeVersion = rt.getVersion()) != null && runtimeVersion.compareTo("5.0") >= 0) {
            return true;
        }
        return (jbws = JBossWSRuntimeManager.getInstance().getDefaultRuntime()) != null && "3.0".compareTo(jbws.getVersion()) <= 0;
    }

    public static IRuntime getRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getProperty("id");
        if (id == null) {
            return null;
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (id.equals(runtimes[i].getId())) {
                return runtimes[i];
            }
            ++i;
        }
        return null;
    }

    public static String getJavaProjectSrcLocation(IProject project) throws JavaModelException {
        IResource[] rs = JBossWSCreationUtils.getJavaSourceRoots(project);
        String src = "";
        if (rs == null || rs.length == 0) {
            return src;
        }
        int i = 0;
        while (i < rs.length) {
            IPath p = rs[i].getLocation();
            if (p != null) {
                src = p.toOSString();
            }
            ++i;
        }
        return src;
    }

    public static IResource[] getJavaSourceRoots(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return null;
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (i < es.length) {
            IResource findMember;
            if (es[i].getEntryKind() == 3 && (findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(es[i].getPath())) != null && findMember.exists()) {
                resources.add(findMember);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IPath getWebContentRootPath(IProject project) {
        if (project == null) {
            return null;
        }
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IPath path = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists()) {
            path = component.getRootFolder().getWorkspaceRelativePath();
        }
        return path;
    }

    public static File findFileByPath(String name, String path) {
        File ret = null;
        File folder = new File(path);
        if (folder.isDirectory()) {
            File[] files;
            File[] fileArray = files = folder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ret = JBossWSCreationUtils.findFileByPath(name, file.getAbsolutePath());
                if (ret == null) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else if (name.equals(folder.getName())) {
            ret = folder;
        }
        return ret;
    }
}

