/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.ui.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.jboss.tools.ws.core.command.JBossWSClassPathCommand;
import org.jboss.tools.ws.core.command.UninstallJBossWSClassPathCommand;
import org.jboss.tools.ws.core.facet.delegate.IJBossWSFacetDataModelProperties;
import org.jboss.tools.ws.core.facet.delegate.JBossWSFacetInstallDataModelProvider;
import org.jboss.tools.ws.creation.ui.project.facet.IMessageNotifier;
import org.jboss.tools.ws.creation.ui.project.facet.JBossWSRuntimeConfigBlock;

public class JBossWSPropertyPage
extends PropertyPage
implements IMessageNotifier {
    private IDataModel model;
    private IProject project;

    protected Control createContents(Composite parent) {
        if (this.getElement() instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)this.getElement();
            this.project = javaProject.getProject();
        } else if (this.getElement() instanceof IProject) {
            this.project = (IProject)this.getElement();
        }
        this.model = (IDataModel)new JBossWSFacetInstallDataModelProvider().create();
        try {
            String isDeploy = this.project.getPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_ISDEPLOYED);
            String runtimeid = this.project.getPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME);
            String runtimeLocation = this.project.getPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_RNTIME_LOCATION);
            String serverSupplied = this.project.getPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_SERVER_SUPPLIED_RUNTIME);
            this.model.setProperty("jboss.ws.deploy", (Object)Boolean.valueOf(isDeploy));
            this.model.setProperty("jboss.ws.runtime.home", (Object)runtimeLocation);
            this.model.setProperty("jboss.ws.runtime_id", (Object)runtimeid);
            this.model.setStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", this.project.getName());
            this.model.setBooleanProperty("jboss.ws.is.server.supplied", Boolean.valueOf(serverSupplied).booleanValue());
        }
        catch (CoreException coreException) {}
        JBossWSRuntimeConfigBlock block = new JBossWSRuntimeConfigBlock(this.model);
        block.setMessageNotifier(this);
        return block.createControl(parent);
    }

    public void notify(String msg) {
        this.setErrorMessage(msg);
    }

    protected void performApply() {
        UninstallJBossWSClassPathCommand uninstall = new UninstallJBossWSClassPathCommand(this.project, this.model);
        uninstall.executeOverride(null);
        JBossWSClassPathCommand install = new JBossWSClassPathCommand(this.project, this.model);
        install.executeOverride(null);
        super.performApply();
    }
}

