/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.ui.project.facet;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.ws.core.classpath.JBossWSRuntime;
import org.jboss.tools.ws.core.classpath.JBossWSRuntimeManager;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.ui.CreationUIPlugin;
import org.jboss.tools.ws.creation.ui.project.facet.IMessageNotifier;
import org.jboss.tools.ws.ui.preferences.JBossRuntimeListFieldEditor;

public class JBossWSRuntimeConfigBlock {
    private Button btnServerSupplied;
    private Button btnUserSupplied;
    private Combo cmbRuntimes;
    private Button btnDeploy;
    private Button btnNew;
    private String errMsg;
    private IMessageNotifier notifier;
    private String jbossWSVersion;
    private IDataModel model;
    private static final String JBOSS_IDE_AS_RUNTIME_ID = "org.jboss.ide.eclipse.as.runtime";
    private static final String JBOSS_IDE_EAP_RUNTIME_ID = "org.jboss.ide.eclipse.as.runtime.eap";

    public JBossWSRuntimeConfigBlock(Object config) {
        this.model = (IDataModel)config;
        this.jbossWSVersion = (String)this.model.getProperty("IFacetDataModelProperties.FACET_VERSION_STR");
    }

    public void setMessageNotifier(IMessageNotifier notifier) {
        this.notifier = notifier;
    }

    public Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        composite.setLayout((Layout)gridLayout);
        this.btnServerSupplied = new Button(composite, 16);
        this.btnServerSupplied.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JBossWSRuntimeConfigBlock.this.setServerSuppliedSelection((EventObject)e);
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.btnServerSupplied.setLayoutData((Object)gd);
        Label lblServerSupplied = new Label(composite, 0);
        lblServerSupplied.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JBossWSRuntimeConfigBlock.this.btnServerSupplied.setSelection(true);
                JBossWSRuntimeConfigBlock.this.setServerSuppliedSelection((EventObject)e);
            }
        });
        lblServerSupplied.setText(JBossWSCreationCoreMessages.JBossWSFacetInstallPage_ServerSuppliedJBossWS);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        lblServerSupplied.setLayoutData((Object)gd);
        this.btnUserSupplied = new Button(composite, 16);
        this.btnUserSupplied.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JBossWSRuntimeConfigBlock.this.setUserSuppliedSelection((EventObject)e);
            }
        });
        this.cmbRuntimes = new Combo(composite, 8);
        this.cmbRuntimes.setLayoutData((Object)new GridData(768));
        this.cmbRuntimes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String runtimeName = JBossWSRuntimeConfigBlock.this.cmbRuntimes.getText();
                JBossWSRuntime jr = (JBossWSRuntime)JBossWSRuntimeConfigBlock.this.cmbRuntimes.getData(runtimeName);
                JBossWSRuntimeConfigBlock.this.saveJBosswsRuntimeToModel(jr);
                JBossWSRuntimeConfigBlock.this.changePageStatus();
            }
        });
        this.btnNew = new Button(composite, 0);
        this.btnNew.setText(JBossWSCreationCoreMessages.JBossWSFacetInstallPage_New);
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JBossWSRuntimeConfigBlock.this.newJBossWSRuntime();
                JBossWSRuntimeConfigBlock.this.changePageStatus();
            }
        });
        this.btnDeploy = new Button(composite, 32);
        this.btnDeploy.setText(JBossWSCreationCoreMessages.JBossWSFacetInstallPage_Deploy);
        this.btnDeploy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JBossWSRuntimeConfigBlock.this.model.setBooleanProperty("jboss.ws.deploy", JBossWSRuntimeConfigBlock.this.btnDeploy.getSelection());
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.btnDeploy.setLayoutData((Object)gd);
        this.setInitialValues();
        this.changePageStatus();
        return composite;
    }

    private void validateTargetRuntime() {
        IFacetedProjectWorkingCopy fpWorkingCopy = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = fpWorkingCopy.getPrimaryRuntime();
        if (runtime == null) {
            this.setErrorMessage(JBossWSCreationCoreMessages.JBossWSRuntimeInstallPage_NoTargetRuntime);
            return;
        }
        IRuntime serverRuntime = ServerCore.findRuntime((String)runtime.getProperty("id"));
        IRuntimeType rt = serverRuntime.getRuntimeType();
        String runtimeTypeId = rt.getId();
        String version = rt.getVersion();
        if (runtimeTypeId.indexOf(JBOSS_IDE_AS_RUNTIME_ID) < 0 && runtimeTypeId.indexOf(JBOSS_IDE_EAP_RUNTIME_ID) < 0) {
            this.setErrorMessage(JBossWSCreationCoreMessages.JBossWSRuntimeInstallPage_NoValidJBossWSRuntime);
            return;
        }
        if ("3.0".compareTo(this.jbossWSVersion) <= 0 && "5.0".compareTo(version) > 0) {
            this.setErrorMessage(JBossWSCreationCoreMessages.JBossWSRuntimeInstallPage_NoValidJBossWSRuntime);
            return;
        }
        this.setErrorMessage(null);
    }

    private void setInitialValues() {
        boolean isServerSupplied = this.model.getBooleanProperty("jboss.ws.is.server.supplied");
        String runtimeName = this.model.getStringProperty("jboss.ws.runtime_id");
        boolean isDeploy = this.model.getBooleanProperty("jboss.ws.deploy");
        if (isServerSupplied) {
            this.btnServerSupplied.setSelection(true);
            this.enableUserSupplied(false);
        } else if (runtimeName != null && !runtimeName.equals("")) {
            this.btnUserSupplied.setSelection(true);
            if (isDeploy) {
                this.btnDeploy.setSelection(true);
            }
        }
        this.initializeRuntimesCombo(this.cmbRuntimes, runtimeName);
    }

    protected void saveJBosswsRuntimeToModel(JBossWSRuntime jbws) {
        String duplicateMsg = "";
        try {
            duplicateMsg = this.getDuplicateJars(jbws.getName());
        }
        catch (JavaModelException e1) {
            CreationUIPlugin.getDefault().getLog().log(StatusUtils.errorStatus((Throwable)e1));
        }
        if ("".equals(duplicateMsg)) {
            this.model.setStringProperty("jboss.ws.runtime.home", jbws.getHomeDir());
            this.model.setStringProperty("jboss.ws.runtime_id", jbws.getName());
        } else {
            this.model.setStringProperty("jboss.ws.runtime_id", null);
            this.model.setStringProperty("jboss.ws.runtime.home", null);
        }
    }

    protected void setServerSuppliedSelection(EventObject e) {
        this.btnServerSupplied.setSelection(true);
        this.btnUserSupplied.setSelection(false);
        this.model.setBooleanProperty("jboss.ws.is.server.supplied", true);
        this.model.setStringProperty("jboss.ws.runtime_id", null);
        this.model.setStringProperty("jboss.ws.runtime.home", null);
        this.enableUserSupplied(false);
        this.changePageStatus();
    }

    protected void setUserSuppliedSelection(EventObject e) {
        this.btnServerSupplied.setSelection(false);
        this.btnUserSupplied.setSelection(true);
        this.model.setBooleanProperty("jboss.ws.is.server.supplied", false);
        String runtimeId = this.cmbRuntimes.getText();
        JBossWSRuntime jbws = JBossWSRuntimeManager.getInstance().findRuntimeByName(runtimeId);
        if (jbws != null) {
            this.saveJBosswsRuntimeToModel(jbws);
        }
        this.enableUserSupplied(true);
        this.changePageStatus();
    }

    protected void enableUserSupplied(boolean enabled) {
        this.cmbRuntimes.setEnabled(enabled);
        this.btnDeploy.setEnabled(enabled);
        this.btnNew.setEnabled(enabled);
    }

    protected void initializeRuntimesCombo(Combo cmRuntime, String runtimeName) {
        JBossWSRuntime selectedJbws = null;
        JBossWSRuntime defaultJbws = null;
        int defaultIndex = 0;
        cmRuntime.removeAll();
        JBossWSRuntime[] runtimes = JBossWSRuntimeManager.getInstance().getRuntimes();
        int i = 0;
        while (i < runtimes.length) {
            JBossWSRuntime jr = runtimes[i];
            if (this.jbossWSVersion.compareTo(jr.getVersion()) <= 0) {
                cmRuntime.add(jr.getName());
                cmRuntime.setData(jr.getName(), (Object)jr);
                if (jr.getName().equals(runtimeName)) {
                    selectedJbws = jr;
                }
                if (jr.isDefault()) {
                    defaultJbws = jr;
                    defaultIndex = i;
                }
            }
            ++i;
        }
        if (selectedJbws != null) {
            cmRuntime.setText(runtimeName);
            this.saveJBosswsRuntimeToModel(selectedJbws);
        } else if (defaultJbws != null) {
            cmRuntime.select(defaultIndex);
            this.saveJBosswsRuntimeToModel(defaultJbws);
        }
    }

    protected void newJBossWSRuntime() {
        ArrayList<JBossWSRuntime> exists = new ArrayList<JBossWSRuntime>(Arrays.asList(JBossWSRuntimeManager.getInstance().getRuntimes()));
        ArrayList added = new ArrayList();
        JBossRuntimeListFieldEditor.JBossWSRuntimeNewWizard newRtwizard = new JBossRuntimeListFieldEditor.JBossWSRuntimeNewWizard(exists, added){

            public boolean performFinish() {
                JBossWSRuntime rt = this.getRuntime();
                rt.setDefault(true);
                JBossWSRuntimeManager.getInstance().addRuntime(rt);
                JBossWSRuntimeManager.getInstance().save();
                return true;
            }
        };
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)newRtwizard);
        if (dialog.open() == 0) {
            this.initializeRuntimesCombo(this.cmbRuntimes, null);
        }
    }

    protected void changePageStatus() {
        if (this.btnUserSupplied.getSelection() && this.cmbRuntimes.getSelectionIndex() == -1) {
            this.setErrorMessage(JBossWSCreationCoreMessages.Error_WS_No_Runtime_Specifed);
        } else if (!this.btnUserSupplied.getSelection() && !this.btnServerSupplied.getSelection()) {
            this.setErrorMessage(JBossWSCreationCoreMessages.Error_WS_Chose_runtime);
        } else if (this.btnUserSupplied.getSelection()) {
            String duplicateMsg = "";
            try {
                duplicateMsg = this.getDuplicateJars(this.cmbRuntimes.getText());
            }
            catch (JavaModelException e1) {
                CreationUIPlugin.getDefault().getLog().log(StatusUtils.errorStatus((Throwable)e1));
            }
            if (!duplicateMsg.equals("")) {
                this.setErrorMessage(MessageFormat.format(JBossWSCreationCoreMessages.JBossWSRuntimeConfigBlock_Duplicated_Jar, duplicateMsg));
            } else {
                this.setErrorMessage(null);
            }
        } else if (this.btnServerSupplied.getSelection()) {
            this.validateTargetRuntime();
        } else {
            this.setErrorMessage(null);
        }
        if (this.notifier != null) {
            this.notifier.notify(this.errMsg);
        }
    }

    private void setErrorMessage(String msg) {
        this.errMsg = msg;
    }

    public boolean isPageComplete() {
        if (this.errMsg != null && !"".equals(this.errMsg)) {
            return false;
        }
        return this.btnServerSupplied.getSelection() || this.btnUserSupplied.getSelection() && this.cmbRuntimes.getSelectionIndex() != -1;
    }

    public void propertyChanged(DataModelEvent event) {
    }

    protected String getDuplicateJars(String jbwsName) throws JavaModelException {
        IClasspathEntry[] entries;
        String prjName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        if (prjName == null || "".equals(prjName)) {
            return "";
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(prjName);
        if (!project.exists()) {
            return "";
        }
        ArrayList<String> allExistingJars = new ArrayList<String>();
        ArrayList runtimeJars = new ArrayList();
        JBossWSRuntime jbws = JBossWSRuntimeManager.getInstance().findRuntimeByName(jbwsName);
        if (jbws.isUserConfigClasspath()) {
            runtimeJars.addAll(jbws.getLibraries());
        } else {
            runtimeJars.addAll(JBossWSRuntimeManager.getInstance().getAllRuntimeJars(jbws));
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 5) {
                if (!"JBossWS_Runtime".equals(entry.getPath().segment(0))) {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
                    IClasspathEntry[] iClasspathEntryArray2 = container.getClasspathEntries();
                    int n3 = iClasspathEntryArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry containedEntry = iClasspathEntryArray2[n4];
                        allExistingJars.add(containedEntry.getPath().toOSString());
                        ++n4;
                    }
                }
            } else if (entry.getEntryKind() == 1) {
                allExistingJars.add(entry.getPath().toOSString());
            }
            ++n2;
        }
        for (String jarName : runtimeJars) {
            if (!allExistingJars.contains(jarName)) continue;
            return jarName;
        }
        return "";
    }
}

