/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.preferences;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.ws.ui.preferences.BaseFieldEditor;
import org.jboss.tools.ws.ui.preferences.ComboBoxField;
import org.jboss.tools.ws.ui.preferences.ITaggedFieldEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboFieldEditor
extends BaseFieldEditor
implements ITaggedFieldEditor,
PropertyChangeListener {
    List<String> values = null;
    boolean editable = false;
    private ComboBoxField comboField;

    public ComboFieldEditor(String name, String label, List<String> values, Object defaultValue, boolean editableSelection) {
        super(name, label, defaultValue);
        this.values = Collections.unmodifiableList(values);
        this.editable = editableSelection;
    }

    @Override
    public Object[] getEditorControls(Object composite) {
        return new Control[]{this.getComboControl((Composite)composite)};
    }

    @Override
    public void doFillIntoGrid(Object parent) {
    }

    public Control getComboControl(Composite composite) {
        if (this.comboField == null) {
            this.comboField = new ComboBoxField(composite, this.values, this.getValue(), this.editable);
            this.comboField.addPropertyChangeListener(this);
            final Combo combo = this.comboField.getComboControl();
            combo.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ComboFieldEditor.this.dispose(e);
                    combo.removeDisposeListener((DisposeListener)this);
                }
            });
        } else if (composite != null) {
            Assert.isTrue((this.comboField.getControl().getParent() == composite ? 1 : 0) != 0);
        }
        return this.comboField.getControl();
    }

    @Override
    public Object[] getEditorControls() {
        return new Control[]{this.comboField.getControl()};
    }

    public void save(Object object) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setValue(evt.getNewValue());
    }

    @Override
    public String[] getTags() {
        return this.comboField.getComboControl().getItems();
    }

    @Override
    public void setTags(String[] tags) {
        this.comboField.setTags(tags, this.getValueAsString());
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    @Override
    public void setEditable(boolean ediatble) {
        super.setEditable(ediatble);
        this.comboField.setEditable(ediatble);
    }

    @Override
    public void setValue(Object newValue) {
        if (newValue == null) {
            return;
        }
        super.setValue(newValue);
        if (this.comboField != null) {
            this.comboField.removePropertyChangeListener(this);
            this.comboField.setValue(newValue.toString());
            this.comboField.addPropertyChangeListener(this);
        }
    }
}

