/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.ws.core.classpath.JBossWSRuntime;
import org.jboss.tools.ws.core.classpath.JBossWSRuntimeManager;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.preferences.JBossRuntimeListFieldEditor;

public class JBossWSRuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int COLUMNS = 3;
    JBossRuntimeListFieldEditor jbossWSRuntimes = new JBossRuntimeListFieldEditor("rtlist", JBossWSUIMessages.JBossWS_Preference_Page_Runtimes, new ArrayList<JBossWSRuntime>(Arrays.asList(JBossWSRuntimeManager.getInstance().getRuntimes())));

    public JBossWSRuntimePreferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        root.setLayout((Layout)gl);
        this.jbossWSRuntimes.doFillIntoGrid(root);
        return root;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        for (JBossWSRuntime rt : this.jbossWSRuntimes.getAddedJBossWSRuntimes()) {
            JBossWSRuntimeManager.getInstance().addRuntime(rt);
        }
        this.jbossWSRuntimes.getAddedJBossWSRuntimes().clear();
        for (JBossWSRuntime rt : this.jbossWSRuntimes.getRemoved()) {
            JBossWSRuntimeManager.getInstance().removeRuntime(rt);
        }
        this.jbossWSRuntimes.getRemoved().clear();
        JBossWSRuntime defaultRuntime = this.jbossWSRuntimes.getDefaultJBossWSRuntime();
        JBossWSRuntime[] jBossWSRuntimeArray = JBossWSRuntimeManager.getInstance().getRuntimes();
        int n = jBossWSRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JBossWSRuntime jbossWSRuntime = jBossWSRuntimeArray[n2];
            jbossWSRuntime.setDefault(false);
            ++n2;
        }
        if (defaultRuntime != null) {
            defaultRuntime.setDefault(true);
        }
        this.jbossWSRuntimes.setDefaultJBossWSRuntime(null);
        Map<JBossWSRuntime, JBossWSRuntime> changed = this.jbossWSRuntimes.getChangedJBossWSRuntimes();
        for (JBossWSRuntime c : changed.keySet()) {
            JBossWSRuntime o = changed.get(c);
            o.setHomeDir(c.getHomeDir());
            o.setVersion(c.getVersion());
            String oldName = o.getName();
            String newName = c.getName();
            if (!oldName.equals(newName)) {
                JBossWSRuntimeManager.getInstance().changeRuntimeName(oldName, newName);
            }
            o.setDefault(c.isDefault());
            o.setUserConfigClasspath(c.isUserConfigClasspath());
            o.setLibraries(c.getLibraries());
        }
        this.jbossWSRuntimes.getChangedJBossWSRuntimes().clear();
        JBossWSRuntimeManager.getInstance().save();
    }

    protected void performDefaults() {
        this.setValid(true);
        this.setMessage(null);
        this.performApply();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public JBossRuntimeListFieldEditor getJBossWSRuntimes() {
        return this.jbossWSRuntimes;
    }
}

