/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class UIUtils {
    public static final int DEFAULT_PADDING = 35;
    String infoPopid_;

    public UIUtils(String infoPopid) {
        this.infoPopid_ = infoPopid;
    }

    public Button createRadioButton(Composite parent, String labelName, String tooltip, String infopop) {
        return this.createButton(16, parent, labelName, tooltip, infopop);
    }

    public Button createCheckbox(Composite parent, String labelName, String tooltip, String infopop) {
        return this.createButton(32, parent, labelName, tooltip, infopop);
    }

    public Button createPushButton(Composite parent, String labelName, String tooltip, String infopop) {
        return this.createButton(0, parent, labelName, tooltip, infopop);
    }

    public Button createButton(int kind, Composite parent, String labelName, String tooltip, String infopop) {
        Button button = new Button(parent, kind);
        tooltip = tooltip == null ? labelName : tooltip;
        button.setText(labelName);
        button.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)button, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return button;
    }

    public Combo createCombo(Composite parent, String labelName, String tooltip, String infopop, int style) {
        String string = tooltip = tooltip == null ? labelName : tooltip;
        if (labelName != null) {
            Label label = new Label(parent, 64);
            label.setText(labelName);
            label.setToolTipText(tooltip);
        }
        Combo combo = new Combo(parent, style);
        GridData griddata = new GridData(768);
        combo.setLayoutData((Object)griddata);
        combo.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return combo;
    }

    public Text createText(Composite parent, String labelName, String tooltip, String infopop, int style) {
        String string = tooltip = tooltip == null ? labelName : tooltip;
        if (labelName != null) {
            Label label = new Label(parent, 64);
            label.setText(labelName);
            label.setToolTipText(tooltip);
        }
        Text text = new Text(parent, style);
        GridData griddata = new GridData(768);
        text.setLayoutData((Object)griddata);
        text.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)text, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return text;
    }

    public Composite createComposite(Composite parent, int columns) {
        return this.createComposite(parent, columns, -1, -1);
    }

    public Composite createComposite(Composite parent, int columns, int marginHeight, int marginWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridlayout = new GridLayout();
        gridlayout.numColumns = columns;
        if (marginHeight >= 0) {
            gridlayout.marginHeight = marginHeight;
        }
        if (marginWidth >= 0) {
            gridlayout.marginWidth = marginWidth;
        }
        composite.setLayout((Layout)gridlayout);
        GridData griddata = new GridData(768);
        composite.setLayoutData((Object)griddata);
        return composite;
    }

    public Group createGroup(Composite parent, String groupName, String tooltip, String infopop) {
        return this.createGroup(parent, groupName, tooltip, infopop, 1, -1, -1);
    }

    public Group createGroup(Composite parent, String groupName, String tooltip, String infopop, int columns, int marginHeight, int marginWidth) {
        Group newGroup = new Group(parent, 0);
        GridData griddata = new GridData(768);
        GridLayout gridlayout = new GridLayout();
        gridlayout.numColumns = columns;
        if (marginHeight >= 0) {
            gridlayout.marginHeight = marginHeight;
        }
        if (marginWidth >= 0) {
            gridlayout.marginWidth = marginWidth;
        }
        tooltip = tooltip == null ? groupName : tooltip;
        newGroup.setLayout((Layout)gridlayout);
        newGroup.setText(groupName);
        newGroup.setLayoutData((Object)griddata);
        newGroup.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newGroup, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return newGroup;
    }

    public Tree createTree(Composite parent, String tooltip, String infopop, int style) {
        tooltip = tooltip == null ? "" : tooltip;
        Tree tree = new Tree(parent, style);
        tree.setLayoutData((Object)this.createFillAll());
        tree.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)tree, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return tree;
    }

    public Table createTable(Composite parent, String tooltip, String infopop, int style) {
        tooltip = tooltip == null ? "" : tooltip;
        Table table = new Table(parent, style);
        table.setToolTipText(tooltip);
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)table, String.valueOf(this.infoPopid_) + "." + infopop);
        }
        return table;
    }

    public Label createHorizontalSeparator(Composite parent, int spacing) {
        Composite composite = this.createComposite(parent, 1, spacing, -1);
        Label separator = new Label(composite, 258);
        GridData griddata = new GridData(768);
        separator.setLayoutData((Object)griddata);
        return separator;
    }

    public GridData createFillAll() {
        GridData data = new GridData(1808);
        return data;
    }

    public void createInfoPop(Control ctrl, String infopop) {
        if (infopop != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(ctrl, String.valueOf(this.infoPopid_) + "." + infopop);
        }
    }

    public void horizontalResize(Composite target, Composite reference, int padding) {
        Point originalSize = target.getSize();
        Point referenceSize = reference.getSize();
        int n = padding = padding >= 0 ? padding : 35;
        if (referenceSize.x + padding > originalSize.x) {
            target.setSize(referenceSize.x + padding, originalSize.y);
        }
    }

    public static void writePropertyToFile(File file, String key, String value) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "8859_1"));
        out.write(String.valueOf(key) + "=" + value + "\n");
        ((Writer)out).close();
    }

    public static void copyFile(String src, String dest) {
        FileInputStream is = null;
        FileOutputStream fos = null;
        try {
            try {
                is = new FileInputStream(src);
                fos = new FileOutputStream(dest);
                int c = 0;
                byte[] array = new byte[1024];
                while ((c = ((InputStream)is).read(array)) >= 0) {
                    fos.write(array, 0, c);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fos.close();
                    ((InputStream)is).close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                fos.close();
                ((InputStream)is).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static File createFileAndParentDirectories(String fileName) throws Exception {
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
        return file;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = UIUtils.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static void deleteDirectories(File dir) {
        File[] children = dir.listFiles();
        int i = 0;
        while (i < children.length) {
            if (children[i].list() != null && children[i].list().length > 0) {
                UIUtils.deleteDirectories(children[i]);
            } else {
                children[i].delete();
            }
            ++i;
        }
        dir.delete();
    }

    public static void deleteDirectories(String dir) {
        File directory = new File(dir);
        UIUtils.deleteDirectories(directory);
    }

    public static void createTargetFile(String sourceFileName, String targetFileName) throws Exception {
        UIUtils.createTargetFile(sourceFileName, targetFileName, false);
    }

    public static void createTargetFile(String sourceFileName, String targetFileName, boolean overwrite) throws Exception {
        File idealResultFile = new File(targetFileName);
        if (overwrite || !idealResultFile.exists()) {
            UIUtils.createFileAndParentDirectories(targetFileName);
            UIUtils.copyFile(sourceFileName, targetFileName);
        }
    }

    public static boolean createDirectory(String directory) {
        boolean success = new File(directory).mkdir();
        return success;
    }

    public static boolean createDirectorys(String directory) {
        boolean success = new File(directory).mkdirs();
        return success;
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            int i = 0;
            while (i < children.length) {
                UIUtils.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
                ++i;
            }
        } else {
            UIUtils.copy(srcDir, dstDir);
        }
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static String addAnotherNodeToPath(String currentPath, String newNode) {
        return String.valueOf(currentPath) + File.separator + newNode;
    }

    public static String addNodesToPath(String currentPath, String[] newNode) {
        String returnPath = currentPath;
        int i = 0;
        while (i < newNode.length) {
            returnPath = String.valueOf(returnPath) + File.separator + newNode[i];
            ++i;
        }
        return returnPath;
    }

    public static String addNodesToPath(StringBuffer currentPath, String[] pathNodes) {
        int i = 0;
        while (i < pathNodes.length) {
            currentPath.append(File.separator);
            currentPath.append(pathNodes[i]);
            ++i;
        }
        return currentPath.toString();
    }

    public static String addNodesToURL(String currentPath, String[] newNode) {
        String returnPath = currentPath;
        int i = 0;
        while (i < newNode.length) {
            returnPath = String.valueOf(returnPath) + "/" + newNode[i];
            ++i;
        }
        return returnPath;
    }

    public static File[] getMatchingFiles(String sourceDir, String fileNamePrefix, String extension) {
        ArrayList<File> fileList = new ArrayList<File>();
        File libDir = new File(sourceDir);
        String libDirPath = libDir.getAbsolutePath();
        String[] items = libDir.list();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                String item = items[i];
                if (fileNamePrefix != null && extension != null) {
                    if (item.startsWith(fileNamePrefix) && item.endsWith(extension)) {
                        fileList.add(new File(String.valueOf(libDirPath) + File.separator + item));
                    }
                } else if (fileNamePrefix == null && extension != null) {
                    if (item.endsWith(extension)) {
                        fileList.add(new File(String.valueOf(libDirPath) + File.separator + item));
                    }
                } else if (fileNamePrefix != null && extension == null) {
                    if (item.startsWith(fileNamePrefix)) {
                        fileList.add(new File(String.valueOf(libDirPath) + File.separator + item));
                    }
                } else {
                    fileList.add(new File(String.valueOf(libDirPath) + File.separator + item));
                }
                ++i;
            }
            return fileList.toArray(new File[fileList.size()]);
        }
        return new File[0];
    }

    public static void filterOutRestrictedFiles(String sourceDir, String fileNamePrefix, String extension) {
        File[] resultedMatchingFiles = UIUtils.getMatchingFiles(sourceDir, fileNamePrefix, extension);
        int i = 0;
        while (i < resultedMatchingFiles.length) {
            File matchingFilePath = new File(resultedMatchingFiles[i].getAbsolutePath());
            matchingFilePath.delete();
            ++i;
        }
    }

    public static IPath getWebContentRootPath(IProject project) {
        if (project == null) {
            return null;
        }
        if (!ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return null;
        }
        IPath path = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists()) {
            path = component.getRootFolder().getWorkspaceRelativePath();
        }
        return path;
    }
}

