/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.wizards.JBossWSGenerateWizard;
import org.jboss.tools.ws.ui.wizards.JBossWSGenerateWizardValidator;

public class JBossWSGenerateWebXmlWizardPage
extends WizardPage {
    private JBossWSGenerateWizard wizard;
    private Text name;
    private Combo projects;
    private Button checkDefault;
    private boolean bHasChanged = false;

    protected JBossWSGenerateWebXmlWizardPage(String pageName) {
        super(pageName);
        this.setTitle(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWebXmlPage_Title);
        this.setDescription(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWebXmlPage_Description);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createDialogArea(parent);
        this.wizard = (JBossWSGenerateWizard)this.getWizard();
        Group group = new Group(composite, 0);
        group.setText(JBossWSUIMessages.JBossWSGenerateWebXmlWizardPage_Project_Group);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)gd);
        this.projects = new Combo((Composite)group, 2052);
        this.projects.setToolTipText(JBossWSUIMessages.JBossWSGenerateWebXmlWizardPage_Project_Group_Tooltip);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.projects.setLayoutData((Object)gd);
        this.refreshProjectList(this.wizard.getServiceModel().getWebProjectName());
        this.projects.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossWSGenerateWebXmlWizardPage.this.wizard.setProject(JBossWSGenerateWebXmlWizardPage.this.projects.getText());
                JBossWSGenerateWebXmlWizardPage.this.name.setText(JBossWSGenerateWebXmlWizardPage.this.updateDefaultName());
                JBossWSGenerateWebXmlWizardPage.this.wizard.getSecondPage().refresh();
                JBossWSGenerateWebXmlWizardPage.this.bHasChanged = true;
                JBossWSGenerateWebXmlWizardPage.this.setPageComplete(JBossWSGenerateWebXmlWizardPage.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group group2 = new Group(composite, 0);
        group2.setText(JBossWSUIMessages.JBossWSGenerateWebXmlWizardPage_Web_Service_Group);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setLayoutData((Object)gd);
        new Label((Composite)group2, 0).setText(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWebXmlPage_ServiceName_Label);
        this.name = new Text((Composite)group2, 2048);
        gd = new GridData(768);
        this.name.setLayoutData((Object)gd);
        this.name.setText(this.updateDefaultName());
        this.name.setEnabled(!this.wizard.isUseDefaultServiceName());
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossWSGenerateWebXmlWizardPage.this.wizard.setServiceName(JBossWSGenerateWebXmlWizardPage.this.name.getText());
                JBossWSGenerateWebXmlWizardPage.this.bHasChanged = true;
                JBossWSGenerateWebXmlWizardPage.this.setPageComplete(JBossWSGenerateWebXmlWizardPage.this.isPageComplete());
            }
        });
        this.checkDefault = new Button((Composite)group2, 32);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.checkDefault.setLayoutData((Object)gd);
        this.checkDefault.setSelection(this.wizard.isUseDefaultServiceName());
        this.checkDefault.setText(JBossWSUIMessages.JBossWS_GenerateWizard_WizardPage_CheckButton_Label);
        this.checkDefault.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (JBossWSGenerateWebXmlWizardPage.this.checkDefault.getSelection()) {
                    JBossWSGenerateWebXmlWizardPage.this.checkDefault.setSelection(true);
                    JBossWSGenerateWebXmlWizardPage.this.name.setText(((JBossWSGenerateWebXmlWizardPage)JBossWSGenerateWebXmlWizardPage.this).wizard.NAMEDEFAULT);
                } else {
                    JBossWSGenerateWebXmlWizardPage.this.checkDefault.setSelection(false);
                }
                JBossWSGenerateWebXmlWizardPage.this.name.setEnabled(!JBossWSGenerateWebXmlWizardPage.this.checkDefault.getSelection());
                JBossWSGenerateWebXmlWizardPage.this.wizard.setUseDefaultServiceName(!JBossWSGenerateWebXmlWizardPage.this.checkDefault.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    private void refreshProjectList(String projectName) {
        String[] projectNames = this.getProjects();
        boolean foundInitialProject = false;
        this.projects.removeAll();
        int i = 0;
        while (i < projectNames.length) {
            this.projects.add(projectNames[i]);
            if (projectNames[i].equals(projectName)) {
                foundInitialProject = true;
            }
            ++i;
        }
        if (foundInitialProject) {
            this.projects.setText(projectName);
        }
    }

    public IWizardPage getNextPage() {
        this.wizard.setServiceName(this.name.getText());
        return super.getNextPage();
    }

    private Composite createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    public boolean isPageComplete() {
        return this.validate();
    }

    private String updateDefaultName() {
        ServiceModel model = this.wizard.getServiceModel();
        JBossWSGenerateWizardValidator.setServiceModel(model);
        String currentName = this.wizard.getServiceName();
        IStatus status = JBossWSGenerateWizardValidator.isWSNameValid();
        try {
            if (status.getSeverity() == 4 && !JavaEEProjectUtilities.isDynamicWebProject((IProject)this.wizard.getProject())) {
                return currentName;
            }
        }
        catch (NullPointerException nullPointerException) {
            return currentName;
        }
        String testName = currentName;
        int i = 1;
        while (status != null) {
            testName = String.valueOf(currentName) + i;
            this.wizard.setServiceName(testName);
            model = this.wizard.getServiceModel();
            JBossWSGenerateWizardValidator.setServiceModel(model);
            status = JBossWSGenerateWizardValidator.isWSNameValid();
            ++i;
        }
        return testName;
    }

    private boolean validate() {
        IStatus status;
        ServiceModel model = this.wizard.getServiceModel();
        JBossWSGenerateWizardValidator.setServiceModel(model);
        if (!this.projects.isDisposed() && this.projects.getText().length() > 0) {
            model.setWebProjectName(this.projects.getText());
        }
        if ((status = JBossWSGenerateWizardValidator.isWSNameValid()) != null) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private String[] getProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> dynamicProjects = new ArrayList<String>();
        int i = 0;
        while (i < projects.length) {
            boolean isDynamicWebProject = JavaEEProjectUtilities.isDynamicWebProject((IProject)projects[i]);
            if (isDynamicWebProject) {
                dynamicProjects.add(projects[i].getName());
            }
            ++i;
        }
        return dynamicProjects.toArray(new String[dynamicProjects.size()]);
    }

    protected boolean hasChanged() {
        return this.bHasChanged;
    }
}

