/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.wizards;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.wizards.ServletDescriptor;

public class JBossWSGenerateWizardValidator {
    private static ServiceModel model;
    private static ServletDescriptor[] descriptors;
    private static String JAVA;

    static {
        JAVA = ".java";
    }

    public static void setServiceModel(ServiceModel inModel) {
        model = inModel;
        descriptors = new ServletDescriptor[model.getServiceClasses().size()];
        List serviceClasses = model.getServiceClasses();
        int i = 0;
        while (i < serviceClasses.size()) {
            JBossWSGenerateWizardValidator.descriptors[i] = JBossWSGenerateWizardValidator.getServletDescriptor((String)serviceClasses.get(i));
            ++i;
        }
    }

    public static IStatus isWSNameValid() {
        IModelProvider provider = null;
        if (model.getWebProjectName() == null) {
            return StatusUtils.errorStatus((String)JBossWSUIMessages.Error_JBossWSGenerateWizard_NoProjectSelected);
        }
        try {
            IProject project = JBossWSCreationUtils.getProjectByName((String)model.getWebProjectName());
            if (!JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
                throw new Exception();
            }
            provider = ModelProviderManager.getModelProvider((IProject)project);
        }
        catch (Exception exception) {
            model.setWebProjectName(null);
            return StatusUtils.errorStatus((String)JBossWSUIMessages.Error_JBossWSGenerateWizard_NoProjectSelected);
        }
        Object object = provider.getModelObject();
        if (object instanceof WebApp) {
            WebApp webApp = (WebApp)object;
            if (model != null) {
                int i = 0;
                while (i < descriptors.length) {
                    if (descriptors[i].getName().trim().length() == 0) {
                        return StatusUtils.errorStatus((String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_ServiceName_Empty);
                    }
                    List theServlets = webApp.getServlets();
                    int j = 0;
                    while (j < theServlets.size()) {
                        Servlet aServlet = (Servlet)theServlets.get(j);
                        if (aServlet.getServletName().equals(descriptors[i].getName())) {
                            return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_JBossWS_GenerateWizard_WSName_Same);
                        }
                        ++j;
                    }
                    List theServletMappings = webApp.getServletMappings();
                    int j2 = 0;
                    while (j2 < theServletMappings.size()) {
                        ServletMapping aServletMapping = (ServletMapping)theServletMappings.get(j2);
                        List urlPatterns = aServletMapping.getUrlPatterns();
                        int k = 0;
                        while (k < urlPatterns.size()) {
                            UrlPatternType upt = (UrlPatternType)urlPatterns.get(k);
                            if (aServletMapping.getServletName().equals(descriptors[i].getName()) || upt.getValue().equals(descriptors[i].getMappings())) {
                                return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_JBossWS_GenerateWizard_WSName_Same);
                            }
                            ++k;
                        }
                        ++j2;
                    }
                    ++i;
                }
            }
            return null;
        }
        return null;
    }

    public static IStatus isWSClassValid(String className, IProject project) {
        if (model.getCustomPackage().trim().length() == 0) {
            return StatusUtils.errorStatus((String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_ClassName_Same);
        }
        if (model.getCustomClassName().trim().length() == 0) {
            return StatusUtils.errorStatus((String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_ClassName_Same);
        }
        if (project == null) {
            return StatusUtils.errorStatus((String)JBossWSUIMessages.Error_JBossWSGenerateWizard_NoProjectSelected);
        }
        File file = JBossWSGenerateWizardValidator.findFileByPath(String.valueOf(className) + JAVA, project.getLocation().toOSString());
        if (file != null) {
            return StatusUtils.errorStatus((String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_ClassName_Same);
        }
        return null;
    }

    private static ServletDescriptor getServletDescriptor(String clsName) {
        String servletName = model.getServiceName();
        if (servletName == null) {
            servletName = JBossWSCreationUtils.classNameFromQualifiedName((String)clsName);
        }
        if (servletName.endsWith("Impl") && servletName.length() > 4) {
            servletName = servletName.substring(0, servletName.length() - 4);
        }
        ServletDescriptor sd = new ServletDescriptor();
        sd.setName(servletName);
        sd.setDisplayName(sd.getName());
        sd.setClassName(clsName);
        sd.setMappings(String.valueOf(JBossWSCreationCoreMessages.Separator_Java) + sd.getDisplayName());
        return sd;
    }

    private static File findFileByPath(String name, String path) {
        File ret = null;
        File folder = new File(path);
        if (folder.isDirectory()) {
            File[] files;
            File[] fileArray = files = folder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ret = JBossWSGenerateWizardValidator.findFileByPath(name, file.getAbsolutePath());
                if (ret == null) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else if (name.equals(folder.getName())) {
            ret = folder;
        }
        return ret;
    }
}

