/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.ws.core.messages.JBossWSCoreMessages;
import org.jboss.tools.ws.core.utils.StatusUtils;

public class JBossWSCoreUtils {
    public static IPath pathToWebProjectContainer(String project) {
        IPath projectRoot = JBossWSCoreUtils.getProjectRoot(project);
        IPath currentDynamicWebProjectDir = J2EEUtils.getWebContentPath((IProject)JBossWSCoreUtils.getProjectName(project));
        IPath currentDynamicWebProjectDirWithoutProjectRoot = J2EEUtils.getWebContentPath((IProject)JBossWSCoreUtils.getProjectName(project)).removeFirstSegments(1).makeAbsolute();
        if (projectRoot.toOSString().contains(JBossWSCoreUtils.getWorkspace().toOSString())) {
            return JBossWSCoreUtils.getWorkspace().append(currentDynamicWebProjectDir);
        }
        return projectRoot.append(currentDynamicWebProjectDirWithoutProjectRoot);
    }

    public static IPath getProjectRoot(String project) {
        String projectString = JBossWSCoreUtils.replaceEscapecharactors(project.toString());
        return ResourcesPlugin.getWorkspace().getRoot().getProject(JBossWSCoreUtils.getProjectNameFromFramewokNameString(projectString)).getLocation();
    }

    private static String replaceEscapecharactors(String vulnarableString) {
        if (vulnarableString.indexOf("/") != -1) {
            vulnarableString = vulnarableString.replace('/', File.separator.charAt(0));
        }
        return vulnarableString;
    }

    private static String getProjectNameFromFramewokNameString(String frameworkProjectString) {
        if (frameworkProjectString.indexOf(JBossWSCoreUtils.getSplitCharactor()) == -1) {
            return frameworkProjectString;
        }
        return frameworkProjectString.split(JBossWSCoreUtils.getSplitCharactors())[1];
    }

    private static String getSplitCharactor() {
        if (File.separatorChar == '\\') {
            return "\\";
        }
        return File.separator;
    }

    private static String getSplitCharactors() {
        if (File.separatorChar == '\\') {
            return "\\" + File.separator;
        }
        return File.separator;
    }

    public static IPath getWorkspace() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IProject getProjectName(String project) {
        String projectString = JBossWSCoreUtils.replaceEscapecharactors(project.toString());
        return ResourcesPlugin.getWorkspace().getRoot().getProject(JBossWSCoreUtils.getProjectNameFromFramewokNameString(projectString));
    }

    public static IStatus copy(IPath sourcePath, IPath targetPath) {
        IStatus status = Status.OK_STATUS;
        File sourceDir = sourcePath.toFile();
        File[] children = sourceDir.listFiles();
        FileInputStream finStream = null;
        int i = 0;
        while (i < children.length) {
            if (children[i].isFile()) {
                try {
                    finStream = new FileInputStream(children[i]);
                }
                catch (FileNotFoundException e) {
                    status = StatusUtils.errorStatus(NLS.bind((String)JBossWSCoreMessages.Error_Copy, (Object[])new String[]{e.getLocalizedMessage()}), e);
                }
                try {
                    JBossWSCoreUtils.makeFile(JBossWSCoreUtils.getWorkspaceRoot().getContainerForLocation(targetPath), children[i].getName(), finStream);
                }
                catch (CoreException e) {
                    status = StatusUtils.errorStatus(NLS.bind((String)JBossWSCoreMessages.Error_Copy, (Object[])new String[]{e.getLocalizedMessage()}), e);
                }
            } else {
                try {
                    IFolder temp = JBossWSCoreUtils.makeFolder(JBossWSCoreUtils.getWorkspaceRoot().getContainerForLocation(targetPath), children[i].getName());
                    JBossWSCoreUtils.copy(sourcePath.append(children[i].getName()), temp.getLocation());
                }
                catch (CoreException e) {
                    status = StatusUtils.errorStatus(NLS.bind((String)JBossWSCoreMessages.Error_Copy, (Object[])new String[]{e.getLocalizedMessage()}), e);
                }
            }
            ++i;
        }
        return status;
    }

    private static IFolder makeFolder(IContainer parent, String folderName) throws CoreException {
        IResource child = parent.findMember(folderName);
        if (child == null) {
            IFolder folder = parent.getFolder((IPath)new Path(folderName));
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return folder;
        }
        if (child.getType() == 2) {
            return (IFolder)child;
        }
        throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)JBossWSCoreMessages.JBossWSCoreUtils_ErrorResourceNotFolder, (Object[])new Object[]{parent.getFullPath().append(folderName).toString()}), null));
    }

    private static IFile makeFile(IContainer parent, String fileName, InputStream inputStream) throws CoreException {
        IResource child = parent.findMember(fileName);
        if (child != null) {
            if (child.getType() == 1) {
                if (child.getResourceAttributes() != null && child.getResourceAttributes().isReadOnly()) {
                    IFile[] files = new IFile[]{(IFile)child};
                }
                IFile file = parent.getFile((IPath)new Path(fileName));
                file.setContents(inputStream, true, true, null);
                return file;
            }
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, NLS.bind((String)JBossWSCoreMessages.JBossWSCoreUtils_ErrorResourceNotFile, (Object[])new Object[]{parent.getFullPath().append(fileName)}), null));
        }
        IFile file = parent.getFile((IPath)new Path(fileName));
        file.create(inputStream, true, null);
        return file;
    }
}

