/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui;

import javax.management.MBeanServerConnection;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.jmx.core.MBeanAttributeInfoWrapper;
import org.jboss.tools.jmx.core.MBeanInfoWrapper;
import org.jboss.tools.jmx.core.MBeanOperationInfoWrapper;
import org.jboss.tools.jmx.ui.internal.adapters.JMXAdapterFactory;
import org.osgi.framework.BundleContext;

public class JMXUIActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.jmx.ui";
    private static JMXUIActivator plugin;
    private JMXAdapterFactory adapterFactory;
    private MBeanServerConnection connection;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerAdapters();
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.unregisterAdapters();
        super.stop(context);
    }

    public static JMXUIActivator getDefault() {
        return plugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = JMXUIActivator.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JMXUIActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        return JMXUIActivator.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public void setCurrentConnection(MBeanServerConnection connection) {
        this.connection = connection;
    }

    public MBeanServerConnection getCurrentConnection() {
        return this.connection;
    }

    public static void log(IStatus status) {
        JMXUIActivator.getDefault().getLog().log(status);
    }

    public static void log(int severity, String message, Throwable e) {
        JMXUIActivator.log((IStatus)new Status(severity, PLUGIN_ID, 0, message, e));
    }

    private void registerAdapters() {
        this.adapterFactory = new JMXAdapterFactory();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)this.adapterFactory, MBeanInfoWrapper.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)this.adapterFactory, MBeanAttributeInfoWrapper.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)this.adapterFactory, MBeanOperationInfoWrapper.class);
    }

    private void unregisterAdapters() {
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this.adapterFactory, MBeanInfoWrapper.class);
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this.adapterFactory, MBeanAttributeInfoWrapper.class);
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this.adapterFactory, MBeanOperationInfoWrapper.class);
    }
}

