/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.jboss.tools.jmx.ui.internal.StringUtils;

public class MBeanUtils {
    public static Object[] getParameters(String[] textParams, MBeanParameterInfo[] params) throws ClassNotFoundException {
        if (textParams == null || params == null) {
            return null;
        }
        Object[] ret = new Object[textParams.length];
        int i = 0;
        while (i < ret.length && i < params.length) {
            MBeanParameterInfo param = params[i];
            String texti = textParams[i];
            ret[i] = texti.length() == 0 ? null : (param.getType().equals("byte") ? new Byte(texti) : (param.getType().equals("short") ? new Short(texti) : (param.getType().equals("java.lang.Short") ? new Short(texti) : (param.getType().equals("int") ? new Integer(texti) : (param.getType().equals("java.lang.Integer") ? new Integer(texti) : (param.getType().equals("long") ? new Long(texti) : (param.getType().equals("java.lang.Long") ? new Long(texti) : (param.getType().equals("float") ? new Float(texti) : (param.getType().equals("java.lang.Float") ? new Float(texti) : (param.getType().equals("double") ? new Double(texti) : (param.getType().equals("java.lang.Double") ? new Double(texti) : (param.getType().equals("char") ? new Character(texti.charAt(0)) : (param.getType().equals("boolean") ? new Boolean(texti) : (MBeanUtils.class.getClassLoader().loadClass("java.lang.Number").isAssignableFrom(MBeanUtils.class.getClassLoader().loadClass(param.getType())) ? MBeanUtils.createNumber(texti) : texti))))))))))))));
            ++i;
        }
        return ret;
    }

    public static Object getValue(String valueStr, String type) throws ClassNotFoundException {
        if (valueStr == null || type == null) {
            return null;
        }
        if (type.equals("byte")) {
            return new Byte(valueStr);
        }
        if (type.equals("short")) {
            return new Short(valueStr);
        }
        if (type.equals("java.lang.Short")) {
            return new Short(valueStr);
        }
        if (type.equals("int")) {
            return new Integer(valueStr);
        }
        if (type.equals("java.lang.Integer")) {
            return new Integer(valueStr);
        }
        if (type.equals("long")) {
            return new Long(valueStr);
        }
        if (type.equals("java.lang.Long")) {
            return new Long(valueStr);
        }
        if (type.equals("float")) {
            return new Float(valueStr);
        }
        if (type.equals("java.lang.Float")) {
            return new Float(valueStr);
        }
        if (type.equals("double")) {
            return new Double(valueStr);
        }
        if (type.equals("java.lang.Double")) {
            return new Double(valueStr);
        }
        if (type.equals("char")) {
            return new Character(valueStr.charAt(0));
        }
        if (type.equals("boolean")) {
            return new Boolean(valueStr);
        }
        if (MBeanUtils.class.getClassLoader().loadClass("java.lang.Number").isAssignableFrom(MBeanUtils.class.getClassLoader().loadClass(type))) {
            return MBeanUtils.createNumber(valueStr);
        }
        return valueStr;
    }

    public static Number createNumber(String val) {
        try {
            return new Byte(val);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new BigDecimal(val);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return new BigInteger(val);
                }
                catch (NumberFormatException numberFormatException3) {
                    return null;
                }
            }
        }
    }

    public static String prettySignature(MBeanOperationInfo opInfo) {
        StringBuffer sig = new StringBuffer(opInfo.getName());
        MBeanParameterInfo[] params = opInfo.getSignature();
        sig.append('(');
        int i = 0;
        while (i < params.length) {
            if (i > 0) {
                sig.append(", ");
            }
            MBeanParameterInfo param = params[i];
            sig.append(StringUtils.toString(param.getType(), false));
            ++i;
        }
        sig.append(')');
        return sig.toString();
    }
}

