/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal;

import java.lang.reflect.Array;
import org.eclipse.core.runtime.Assert;

public class StringUtils {
    public static final String NULL = "null";

    public static String toString(Object obj, boolean detailed) {
        if (obj == null) {
            return NULL;
        }
        if (!obj.getClass().isArray()) {
            return obj.toString();
        }
        if (detailed) {
            return StringUtils.toDetailedString(obj);
        }
        return StringUtils.toSimpleString(obj);
    }

    private static final String toSimpleString(Object arrayObj) {
        Assert.isNotNull((Object)arrayObj);
        Assert.isLegal((boolean)arrayObj.getClass().isArray());
        String type = arrayObj.getClass().getComponentType().getName();
        int length = Array.getLength(arrayObj);
        return String.valueOf(type) + '[' + length + ']';
    }

    private static final String toDetailedString(Object arrayObj) {
        Assert.isNotNull((Object)arrayObj);
        Assert.isLegal((boolean)arrayObj.getClass().isArray());
        StringBuffer buff = new StringBuffer();
        int length = Array.getLength(arrayObj);
        int i = 0;
        while (i < length) {
            Object element;
            if (i > 0) {
                buff.append(", ");
            }
            if ((element = Array.get(arrayObj, i)) == null) {
                buff.append(NULL);
            } else {
                buff.append(element.toString());
            }
            ++i;
        }
        return buff.toString();
    }

    public static String toString(String type) {
        return StringUtils.toString(type, true);
    }

    public static String toString(String type, boolean detailed) {
        block5: {
            Assert.isNotNull((Object)type);
            Assert.isLegal((type.length() > 0 ? 1 : 0) != 0);
            if (!StringUtils.isArray(type)) {
                return type;
            }
            try {
                Class<?> clazz = StringUtils.class.getClassLoader().loadClass(type);
                if (clazz.isArray()) {
                    if (detailed) {
                        return String.valueOf(StringUtils.toString(clazz.getComponentType().getName(), detailed)) + "[]";
                    }
                    return String.valueOf(StringUtils.toString(clazz.getComponentType().getSimpleName(), detailed)) + "[]";
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!type.startsWith("[L") || !type.endsWith(";")) break block5;
                return String.valueOf(StringUtils.toString(type.substring(2, type.length() - 1), detailed)) + "[]";
            }
        }
        return type;
    }

    private static boolean isArray(String type) {
        return type.startsWith("[");
    }
}

