/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.navigator.CommonViewer;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.ui.internal.EditorUtils;
import org.jboss.tools.jmx.ui.internal.editors.EditorConnectionMapping;

public class DoubleClickAction
extends Action
implements ISelectionChangedListener {
    private ISelection selection;
    private CommonViewer viewer;
    protected EditorConnectionMapping mapping = new EditorConnectionMapping();

    public EditorConnectionMapping getMapping() {
        return this.mapping;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selection = event.getSelection();
        this.viewer = (CommonViewer)event.getSource();
    }

    public void run() {
        IEditorPart editor;
        if (this.selection == null) {
            return;
        }
        StructuredSelection structured = (StructuredSelection)this.selection;
        Object element = structured.getFirstElement();
        this.viewer.expandToLevel(element, 1);
        IEditorInput editorInput = EditorUtils.getEditorInput(element);
        if (editorInput != null && (editor = EditorUtils.openMBeanEditor(editorInput)) != null) {
            EditorUtils.revealInEditor(editor, element);
            editor.setFocus();
            this.mapping.open(this.findParent((IStructuredSelection)structured), editor);
        }
    }

    protected IConnectionWrapper findParent(IStructuredSelection sel) {
        TreeSelection sel2;
        TreePath[] paths;
        if (sel instanceof TreeSelection && (paths = (sel2 = (TreeSelection)sel).getPathsFor(sel.getFirstElement())) != null && paths.length == 1 && paths[0].getFirstSegment() instanceof IConnectionWrapper) {
            return (IConnectionWrapper)paths[0].getFirstSegment();
        }
        return null;
    }
}

