/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.controls;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.jmx.ui.extensions.IAttributeControlFactory;
import org.jboss.tools.jmx.ui.extensions.IWritableAttributeHandler;

public class BooleanControlFactory
implements IAttributeControlFactory {
    public Control createControl(Composite parent, FormToolkit toolkit, boolean writable, String type, Object value, final IWritableAttributeHandler handler) {
        boolean booleanValue = (Boolean)value;
        if (!writable) {
            if (toolkit != null) {
                return toolkit.createText(parent, Boolean.toString(booleanValue), 4);
            }
            Text text = new Text(parent, 4);
            text.setText(Boolean.toString(booleanValue));
            return text;
        }
        final Combo combo = new Combo(parent, 12);
        if (toolkit != null) {
            combo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            toolkit.paintBordersFor((Composite)combo);
        }
        combo.setForeground(parent.getDisplay().getSystemColor(9));
        combo.setItems(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()});
        if (booleanValue) {
            combo.select(0);
        } else {
            combo.select(1);
        }
        if (handler != null) {
            combo.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Boolean newValue = Boolean.valueOf(combo.getText());
                    handler.write(newValue);
                }
            });
        }
        return combo;
    }
}

