/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.editors;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.MBeanAttributeInfoWrapper;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.extensions.IWritableAttributeHandler;
import org.jboss.tools.jmx.ui.internal.JMXImages;
import org.jboss.tools.jmx.ui.internal.StringUtils;
import org.jboss.tools.jmx.ui.internal.controls.AttributeControlFactory;

public class AttributeDetails
extends AbstractFormPart
implements IDetailsPage {
    private IFormPart masterSection;
    private FormToolkit toolkit;
    private Label nameLabel;
    private Label typeLabel;
    private Text descriptionText;
    private Label permissionLabel;
    private Composite valueComposite;
    private MBeanAttributeInfoWrapper wrapper;
    private final IWritableAttributeHandler updateAttributeHandler = new IWritableAttributeHandler(){

        public void write(final Object newValue) {
            new Thread(){

                public void run() {
                    IConnectionWrapper connection = AttributeDetails.this.wrapper.getMBeanInfoWrapper().getParent().getConnection();
                    try {
                        connection.run(new IJMXRunnable(){

                            public void run(MBeanServerConnection connection) throws Exception {
                                AttributeDetails.this.execAttributeUpdate(connection, newValue);
                            }
                        });
                    }
                    catch (JMXException jMXException) {}
                }
            }.start();
        }
    };

    protected void execAttributeUpdate(MBeanServerConnection connection, Object newValue) {
        try {
            String attrName = this.wrapper.getMBeanAttributeInfo().getName();
            Attribute attr = new Attribute(attrName, newValue);
            connection.setAttribute(this.wrapper.getObjectName(), attr);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AttributeDetails.this.masterSection.refresh();
                }
            });
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)AttributeDetails.this.getManagedForm().getForm().getDisplay().getActiveShell(), (String)Messages.AttributeDetailsSection_errorTitle, (String)e.getLocalizedMessage());
                }
            });
        }
    }

    public AttributeDetails(IFormPart masterSection) {
        this.masterSection = masterSection;
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        this.toolkit = this.getManagedForm().getToolkit();
        FontData[] fd = parent.getFont().getFontData();
        Font bold = new Font((Device)parent.getDisplay(), fd[0].getName(), fd[0].getHeight(), 1);
        Section section = this.toolkit.createSection(parent, 256);
        section.marginWidth = 10;
        section.setText(Messages.AttributeDetails_title);
        section.setLayoutData((Object)new TableWrapData(256));
        Composite container = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 2;
        glayout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)glayout);
        this.toolkit.createLabel(container, Messages.name);
        this.nameLabel = this.toolkit.createLabel(container, "");
        this.nameLabel.setFont(bold);
        this.nameLabel.setLayoutData((Object)this.newLayoutData());
        this.toolkit.createLabel(container, Messages.type);
        this.typeLabel = this.toolkit.createLabel(container, "");
        this.typeLabel.setFont(bold);
        this.typeLabel.setLayoutData((Object)this.newLayoutData());
        this.toolkit.createLabel(container, Messages.description);
        this.descriptionText = this.toolkit.createText(container, "", 74);
        this.descriptionText.setFont(bold);
        this.descriptionText.setLayoutData((Object)this.newLayoutData());
        this.toolkit.createLabel(container, Messages.permission);
        this.permissionLabel = this.toolkit.createLabel(container, "");
        this.permissionLabel.setLayoutData((Object)this.newLayoutData());
        this.permissionLabel.setFont(bold);
        this.valueComposite = this.toolkit.createComposite(container);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        this.valueComposite.setLayoutData((Object)layoutData);
        GridLayout valueLayout = new GridLayout();
        valueLayout.marginWidth = 0;
        valueLayout.marginHeight = 0;
        this.valueComposite.setLayout((Layout)valueLayout);
    }

    private GridData newLayoutData() {
        return new GridData(4, 4, false, false);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        StructuredSelection structured = (StructuredSelection)selection;
        this.wrapper = (MBeanAttributeInfoWrapper)structured.getFirstElement();
        this.update(this.wrapper);
    }

    public void update(MBeanAttributeInfoWrapper wrapper) {
        MBeanAttributeInfo attrInfo = wrapper.getMBeanAttributeInfo();
        String type = attrInfo.getType();
        this.nameLabel.setText(attrInfo.getName());
        this.typeLabel.setText(StringUtils.toString(type));
        if (attrInfo.getDescription() != null) {
            this.descriptionText.setText(attrInfo.getDescription());
        }
        boolean writable = attrInfo.isWritable();
        boolean readable = attrInfo.isReadable();
        if (readable && writable) {
            this.permissionLabel.setImage(JMXImages.get("org.jboss.tools.jmx.ui.readwrite_obj.gif"));
            this.permissionLabel.setToolTipText(Messages.readWrite);
        } else if (readable && !writable) {
            this.permissionLabel.setImage(JMXImages.get("org.jboss.tools.jmx.ui.read_obj.gif"));
            this.permissionLabel.setToolTipText(Messages.readOnly);
        } else if (writable && !readable) {
            this.permissionLabel.setImage(JMXImages.get("org.jboss.tools.jmx.ui.write_obj.gif"));
            this.permissionLabel.setToolTipText(Messages.writeOnly);
        } else {
            this.permissionLabel.setImage(null);
        }
        this.disposeChildren(this.valueComposite);
        try {
            try {
                Control attrControl = AttributeControlFactory.createControl(this.valueComposite, wrapper.getValue(), type, wrapper.getObjectName().getCanonicalName(), attrInfo.getName(), writable, this.updateAttributeHandler, this.toolkit);
                GridData gd = new GridData(4, 4, true, true);
                attrControl.setLayoutData((Object)gd);
                attrControl.pack(true);
            }
            catch (Throwable t) {
                Label errorLabel = this.toolkit.createLabel(this.valueComposite, Messages.unavailable);
                errorLabel.setForeground(this.valueComposite.getDisplay().getSystemColor(3));
                GridData gd = new GridData(4, 4, true, true);
                errorLabel.setLayoutData((Object)gd);
                Text errorText = this.toolkit.createText(this.valueComposite, "", 778);
                gd = new GridData(4, 4, true, true);
                errorText.setLayoutData((Object)gd);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                errorText.setText(sw.toString());
                this.valueComposite.layout(true, true);
            }
        }
        finally {
            this.valueComposite.layout(true, true);
        }
    }

    private void disposeChildren(Composite composite) {
        Control[] childs;
        if (composite != null && !composite.isDisposed() && (childs = composite.getChildren()).length > 0) {
            int i = 0;
            while (i < childs.length) {
                childs[i].dispose();
                ++i;
            }
        }
    }
}

