/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.editors;

import java.util.ArrayList;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.jboss.tools.jmx.core.MBeanInfoWrapper;
import org.jboss.tools.jmx.ui.JMXUIActivator;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.internal.JMXImages;
import org.jboss.tools.jmx.ui.internal.editors.MBeanEditorInput;

public class NotificationsPage
extends FormPage {
    static final String ID = "notifications";
    private MBeanInfoWrapper wrapper;
    private Action subscribeAction;
    private NotificationListener listener;
    private List notifications = new ArrayList();
    private TableViewer viewer;

    public NotificationsPage(FormEditor editor) {
        super(editor, ID, Messages.NotificationsPage_title);
        MBeanEditorInput input = (MBeanEditorInput)editor.getEditorInput();
        this.wrapper = input.getWrapper();
    }

    private void createToolBarActions(ScrolledForm form) {
        Action clearAction = new Action("Clear", 1){

            public void run() {
                NotificationsPage.this.notifications.clear();
                NotificationsPage.this.viewer.refresh();
            }
        };
        clearAction.setToolTipText(Messages.NotificationsPage_clearActionToolTip);
        JMXImages.setLocalImageDescriptors((IAction)clearAction, "clear_co.gif");
        this.subscribeAction = new Action("Subscribe", 2){

            public void run() {
                NotificationsPage.this.toogleSubcription();
            }
        };
        this.subscribeAction.setToolTipText(Messages.NotificationsPage_subscribeActionToolTip);
        this.subscribeAction.setEnabled(this.wrapper.isNotificationBroadcaster());
        form.getToolBarManager().add((IAction)clearAction);
        form.getToolBarManager().add((IAction)this.subscribeAction);
        form.updateToolBar();
    }

    private void toogleSubcription() {
        if (this.subscribeAction.isChecked()) {
            try {
                this.wrapper.getMBeanServerConnection().addNotificationListener(this.wrapper.getObjectName(), this.listener, null, null);
            }
            catch (Exception e) {
                JMXUIActivator.log(4, e.getMessage(), e);
            }
        } else {
            try {
                this.wrapper.getMBeanServerConnection().removeNotificationListener(this.wrapper.getObjectName(), this.listener);
            }
            catch (Exception e) {
                JMXUIActivator.log(4, e.getMessage(), e);
            }
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText(this.wrapper.getObjectName().getCanonicalName());
        this.createToolBarActions(form);
        form.getForm().setSeparatorVisible(true);
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        Table table = toolkit.createTable(body, 65536);
        toolkit.paintBordersFor(body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        this.createColumns(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new NotificationLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return NotificationsPage.this.notifications.toArray(new Notification[NotificationsPage.this.notifications.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setInput((Object)this.notifications);
        this.listener = new NotificationListener(){

            public void handleNotification(Notification notification, Object handback) {
                NotificationsPage.this.notifications.add(0, notification);
                NotificationsPage.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        NotificationsPage.this.viewer.refresh();
                    }
                });
            }
        };
    }

    private void createColumns(Table table) {
        TableColumn timestampColumn = new TableColumn(table, 0);
        timestampColumn.setText(Messages.NotificationsPage_timestamp);
        timestampColumn.setWidth(100);
        TableColumn typeColumn = new TableColumn(table, 0);
        typeColumn.setText(Messages.NotificationsPage_type);
        typeColumn.setWidth(200);
        TableColumn messageColumn = new TableColumn(table, 0);
        messageColumn.setText(Messages.NotificationsPage_message);
        messageColumn.setWidth(300);
        TableColumn userDataColumn = new TableColumn(table, 0);
        userDataColumn.setText(Messages.NotificationsPage_userData);
        userDataColumn.setWidth(100);
        TableColumn sequenceNumberColumn = new TableColumn(table, 0);
        sequenceNumberColumn.setText(Messages.NotificationsPage_sequenceNumber);
        sequenceNumberColumn.setWidth(100);
        TableColumn sourceColumn = new TableColumn(table, 0);
        sourceColumn.setText(Messages.NotificationsPage_source);
        sourceColumn.setWidth(100);
    }

    private final class NotificationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private NotificationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Notification notification = (Notification)element;
            if (columnIndex == 0) {
                return Long.toString(notification.getTimeStamp());
            }
            if (columnIndex == 1) {
                return notification.getType();
            }
            if (columnIndex == 2) {
                return notification.getMessage();
            }
            if (columnIndex == 3) {
                if (notification.getUserData() != null) {
                    return notification.getUserData().toString();
                }
                return "";
            }
            if (columnIndex == 4) {
                return Long.toString(notification.getSequenceNumber());
            }
            if (columnIndex == 5) {
                return notification.getSource().toString();
            }
            return super.getText(element);
        }
    }
}

