/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.views.navigator;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.ui.UIExtensionManager;
import org.jboss.tools.jmx.ui.internal.actions.DeleteConnectionAction;
import org.jboss.tools.jmx.ui.internal.actions.DoubleClickAction;
import org.jboss.tools.jmx.ui.internal.actions.EditConnectionAction;
import org.jboss.tools.jmx.ui.internal.actions.MBeanServerConnectAction;
import org.jboss.tools.jmx.ui.internal.actions.MBeanServerDisconnectAction;
import org.jboss.tools.jmx.ui.internal.actions.NewConnectionAction;
import org.jboss.tools.jmx.ui.internal.views.navigator.JMXNavigator;

public class ActionProvider
extends CommonActionProvider {
    private DoubleClickAction doubleClickAction;
    private NewConnectionAction newConnectionAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.doubleClickAction = new DoubleClickAction();
        this.newConnectionAction = new NewConnectionAction();
        aSite.getStructuredViewer().addSelectionChangedListener((ISelectionChangedListener)this.doubleClickAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.doubleClickAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        IConnectionWrapper[] connections = this.getWrappersFromSelection();
        if (connections != null && connections.length > 0) {
            String id;
            UIExtensionManager.ConnectionProviderUI ui;
            if (!this.anyConnected(connections) && this.allControlable(connections)) {
                menu.add((IAction)new MBeanServerConnectAction(connections));
            } else if (this.allControlable(connections)) {
                menu.add((IAction)new MBeanServerDisconnectAction(connections));
            }
            if (connections.length == 1 && (ui = UIExtensionManager.getConnectionProviderUI(id = connections[0].getProvider().getId())) != null && ui.isEditable() && !connections[0].isConnected()) {
                menu.add((IAction)new EditConnectionAction(connections[0]));
            }
            menu.add((IAction)new DeleteConnectionAction(connections));
        }
        int size = this.getSelectionSize();
        Object input = this.getActionSite().getStructuredViewer().getInput();
        if (input instanceof JMXNavigator && (size == 0 || size == 1 && this.getWrappersFromSelection().length == 1)) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.newConnectionAction);
        }
    }

    protected boolean anyConnected(IConnectionWrapper[] connections) {
        int i = 0;
        while (i < connections.length) {
            if (connections[i].isConnected()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean allControlable(IConnectionWrapper[] connections) {
        int i = 0;
        while (i < connections.length) {
            if (!connections[i].canControl()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected int getSelectionSize() {
        ISelection sel;
        if (this.getContext() != null && this.getContext().getSelection() != null && (sel = this.getContext().getSelection()) instanceof IStructuredSelection) {
            return ((IStructuredSelection)sel).size();
        }
        return -1;
    }

    protected IConnectionWrapper[] getWrappersFromSelection() {
        ISelection sel;
        ArrayList<IConnectionWrapper> list = new ArrayList<IConnectionWrapper>();
        if (this.getContext() != null && this.getContext().getSelection() != null && (sel = this.getContext().getSelection()) instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)sel) {
                if (!(o instanceof IConnectionWrapper)) continue;
                list.add((IConnectionWrapper)o);
            }
        }
        return list.toArray(new IConnectionWrapper[list.size()]);
    }
}

