/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.views.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.MBeanAttributeInfoWrapper;
import org.jboss.tools.jmx.core.MBeanInfoWrapper;
import org.jboss.tools.jmx.core.MBeanOperationInfoWrapper;
import org.jboss.tools.jmx.core.tree.DomainNode;
import org.jboss.tools.jmx.core.tree.ObjectNameNode;
import org.jboss.tools.jmx.core.tree.PropertyNode;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.UIExtensionManager;
import org.jboss.tools.jmx.ui.internal.JMXImages;
import org.jboss.tools.jmx.ui.internal.MBeanUtils;
import org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorerContentProvider;

public class MBeanExplorerLabelProvider
extends LabelProvider {
    private static ArrayList<MBeanExplorerLabelProvider> instances = new ArrayList();
    private static HashMap<String, Image> images = new HashMap();

    public MBeanExplorerLabelProvider() {
        instances.add(this);
    }

    public void dispose() {
        instances.remove((Object)this);
        if (instances.isEmpty()) {
            Iterator<Image> i = images.values().iterator();
            while (i.hasNext()) {
                i.next().dispose();
            }
        }
        super.dispose();
    }

    public String getText(Object obj) {
        return MBeanExplorerLabelProvider.getText2(obj);
    }

    public static String getText2(Object obj) {
        if (obj instanceof IConnectionWrapper) {
            IConnectionProvider provider = ((IConnectionWrapper)obj).getProvider();
            return provider.getName((IConnectionWrapper)obj);
        }
        if (obj instanceof MBeanExplorerContentProvider.DelayProxy) {
            return Messages.Loading;
        }
        if (obj instanceof DomainNode) {
            DomainNode node = (DomainNode)obj;
            return node.getDomain();
        }
        if (obj instanceof ObjectNameNode) {
            ObjectNameNode node = (ObjectNameNode)obj;
            return node.getValue();
        }
        if (obj instanceof PropertyNode) {
            PropertyNode node = (PropertyNode)obj;
            return node.getValue();
        }
        if (obj instanceof MBeanInfoWrapper) {
            MBeanInfoWrapper wrapper = (MBeanInfoWrapper)obj;
            return wrapper.getObjectName().toString();
        }
        if (obj instanceof MBeanOperationInfoWrapper) {
            MBeanOperationInfoWrapper wrapper = (MBeanOperationInfoWrapper)obj;
            return MBeanUtils.prettySignature(wrapper.getMBeanOperationInfo());
        }
        if (obj instanceof MBeanAttributeInfoWrapper) {
            MBeanAttributeInfoWrapper wrapper = (MBeanAttributeInfoWrapper)obj;
            return wrapper.getMBeanAttributeInfo().getName();
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        IConnectionProvider provider;
        UIExtensionManager.ConnectionProviderUI ui;
        if (obj instanceof IConnectionWrapper && (ui = UIExtensionManager.getConnectionProviderUI((provider = ((IConnectionWrapper)obj).getProvider()).getId())) != null) {
            if (!images.containsKey(ui.getId()) || images.get(ui.getId()).isDisposed()) {
                images.put(ui.getId(), ui.getImageDescriptor().createImage());
            }
            return images.get(ui.getId());
        }
        if (obj instanceof MBeanExplorerContentProvider.DelayProxy) {
            return null;
        }
        if (obj instanceof DomainNode) {
            return JMXImages.get("org.jboss.tools.jmx.ui.library_obj.gif");
        }
        if (obj instanceof ObjectNameNode) {
            return JMXImages.get("org.jboss.tools.jmx.ui.jmeth_obj.gif");
        }
        if (obj instanceof PropertyNode) {
            return JMXImages.get("org.jboss.tools.jmx.ui.package_obj.gif");
        }
        if (obj instanceof MBeanInfoWrapper) {
            return JMXImages.get("org.jboss.tools.jmx.ui.jmeth_obj.gif");
        }
        if (obj instanceof MBeanAttributeInfoWrapper) {
            return JMXImages.get("org.jboss.tools.jmx.ui.field_public_obj.gif");
        }
        if (obj instanceof MBeanOperationInfoWrapper) {
            return JMXImages.get("org.jboss.tools.jmx.ui.methpub_obj.gif");
        }
        String imageKey = "IMG_OBJ_ELEMENTS";
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
    }
}

