/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.views.navigator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.jmx.ui.internal.views.navigator.JMXNavigator;
import org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorerLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryContribution {
    private static Boolean TRUE_BOOL = new Boolean(true);
    private static HashMap<Viewer, QueryContribution> map = new HashMap();
    private String filterText;
    private JMXNavigator navigator;
    private HashMap<Object, Boolean> matches = null;
    private HashMap<Object, Boolean> shouldShow = null;
    private RefineThread refineThread;

    public static QueryContribution getContributionFor(Viewer v) {
        return map.get(v);
    }

    public static String getFilterText(Viewer viewer) {
        QueryContribution qc = map.get(viewer);
        if (qc != null) {
            return qc.filterText;
        }
        return null;
    }

    public QueryContribution(JMXNavigator navigator) {
        this.navigator = navigator;
        map.put((Viewer)navigator.getCommonViewer(), this);
        this.addListener();
    }

    protected void addListener() {
        this.navigator.getFilterText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean searchNew = QueryContribution.this.matches == null || QueryContribution.this.filterText == null || QueryContribution.this.filterText.equals("") || !QueryContribution.this.navigator.getFilterText().getText().startsWith(QueryContribution.this.filterText);
                RefineThread thread = new RefineThread(searchNew, QueryContribution.this.navigator.getFilterText().getText(), QueryContribution.this.matches, QueryContribution.this.shouldShow);
                if (!QueryContribution.this.navigator.getFilterText().getText().equals("")) {
                    if (QueryContribution.this.refineThread != null) {
                        QueryContribution.this.refineThread.cancel();
                    }
                    QueryContribution.this.refineThread = thread;
                    QueryContribution.this.refineThread.start();
                } else {
                    QueryContribution.this.matches = null;
                    QueryContribution.this.shouldShow = null;
                    QueryContribution.this.refreshView();
                }
            }
        });
    }

    protected void refreshView() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                QueryContribution.this.navigator.getCommonViewer().refresh();
            }
        });
    }

    protected synchronized void threadFinished(HashMap<Object, Boolean> newMatches, HashMap<Object, Boolean> newShow, String filter) {
        this.matches = newMatches;
        this.shouldShow = newShow;
        this.filterText = filter;
        this.refineThread = null;
        this.refreshView();
    }

    public boolean shouldShow(Object element, Object parentElement) {
        return this.matches == null || this.matches.containsKey(element) || this.shouldShow.containsKey(element);
    }

    public void dispose() {
    }

    public static class QueryFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            QueryContribution contrib = QueryContribution.getContributionFor(viewer);
            if (contrib != null) {
                return contrib.shouldShow(element, parentElement);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RefineThread
    extends Thread {
        private boolean canceled = false;
        private boolean searchNew;
        private String newFilter;
        private HashMap<Object, Boolean> matchClone;
        private HashMap<Object, Boolean> showClone;

        public RefineThread(boolean searchNew, String newFilter, HashMap<Object, Boolean> matches, HashMap<Object, Boolean> shouldShow) {
            this.searchNew = searchNew;
            this.newFilter = newFilter;
            this.matchClone = matches == null ? new HashMap() : (HashMap)matches.clone();
            this.showClone = shouldShow == null ? new HashMap() : (HashMap)shouldShow.clone();
        }

        @Override
        public void run() {
            if (this.searchNew) {
                this.searchNew();
            } else {
                this.refine();
            }
            if (!this.canceled) {
                QueryContribution.this.threadFinished(this.matchClone, this.showClone, this.newFilter);
            }
        }

        protected void searchNew() {
            ITreeContentProvider provider = (ITreeContentProvider)QueryContribution.this.navigator.getCommonViewer().getContentProvider();
            Object[] elements = provider.getElements(QueryContribution.this.navigator.getCommonViewer().getInput());
            int i = 0;
            while (i < elements.length) {
                if (!this.canceled) {
                    this.fullCache(elements[i], provider);
                }
                ++i;
            }
        }

        protected void fullCache(Object o, ITreeContentProvider provider) {
            boolean found = false;
            String elementAsString = MBeanExplorerLabelProvider.getText2(o);
            if (elementAsString.contains(this.newFilter)) {
                this.matchClone.put(o, TRUE_BOOL);
                this.recurse(o, provider, true);
            } else {
                Object[] children = provider.getChildren(o);
                int i = 0;
                while (i < children.length) {
                    if (!this.canceled) {
                        this.fullCache(children[i], provider);
                    }
                    ++i;
                }
                if (found) {
                    this.showClone.put(o, TRUE_BOOL);
                    found = true;
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        protected void recurse(Object o, ITreeContentProvider provider, boolean match) {
            block5: {
                children = provider.getChildren(o);
                i = 0;
                while (i < children.length) {
                    if (match) {
                        this.showClone.put(children[i], QueryContribution.access$1());
                    } else {
                        this.showClone.remove(children[i]);
                    }
                    this.recurse(children[i], provider, match);
                    ++i;
                }
                parent = provider.getParent(o);
                if (!match) ** GOTO lbl24
                while (parent != null) {
                    this.showClone.put(parent, QueryContribution.access$1());
                    parent = provider.getParent(parent);
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    this.showClone.remove(parent);
                    parent = provider.getParent(parent);
lbl24:
                    // 2 sources

                    ** while (parent != null)
                }
            }
        }

        protected void refine() {
            ITreeContentProvider provider = (ITreeContentProvider)QueryContribution.this.navigator.getCommonViewer().getContentProvider();
            Iterator<Object> i = this.matchClone.keySet().iterator();
            HashSet<Object> toRemove = new HashSet<Object>();
            HashSet<Object> mustRemain = new HashSet<Object>();
            while (i.hasNext() && !this.canceled) {
                Object o = i.next();
                String elementAsString = MBeanExplorerLabelProvider.getText2(o);
                if (!elementAsString.contains(this.newFilter)) {
                    toRemove.add(o);
                    continue;
                }
                mustRemain.add(o);
            }
            for (Object e : toRemove) {
                this.matchClone.remove(e);
            }
            this.showClone = new HashMap();
            for (Object e : mustRemain) {
                this.recurse(e, provider, true);
            }
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

