/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.ui.ConnectionWizardPage;
import org.jboss.tools.jmx.ui.JMXUIActivator;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.UIExtensionManager;

public class NewConnectionWizard
extends Wizard {
    private IConnectionProvider selected;
    private HashMap<String, UIExtensionManager.ConnectionProviderUI> providerMap;
    private HashMap<String, ConnectionWizardPage[]> pageMap;
    private IWizardPage firstPage;

    public String getWindowTitle() {
        return Messages.DefaultConnectionWizardPage_Title;
    }

    public void addPages() {
        this.firstPage = this.createFirstPage();
        this.addPage(this.firstPage);
        this.providerMap = UIExtensionManager.getConnectionUIElements();
        this.pageMap = new HashMap();
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.providerMap.keySet());
        Collections.sort(l);
        for (UIExtensionManager.ConnectionProviderUI ui : this.providerMap.values()) {
            ConnectionWizardPage[] pages = ui.createPages();
            this.pageMap.put(ui.getId(), pages);
            int j = 0;
            while (j < pages.length) {
                this.addPage(pages[j]);
                ++j;
            }
        }
    }

    public boolean canFinish() {
        if (this.selected == null) {
            return false;
        }
        ConnectionWizardPage[] active = this.getActivePages();
        if (active != null && active.length > 0) {
            if (active[active.length - 1] == this.getContainer().getCurrentPage()) {
                return super.canFinish();
            }
            return false;
        }
        return true;
    }

    private IWizardPage createFirstPage() {
        return new FirstPage();
    }

    public boolean performFinish() {
        ConnectionWizardPage[] active = this.getActivePages();
        if (active != null) {
            IConnectionWrapper wrap = null;
            int i = active.length - 1;
            while (i >= 0 && wrap == null) {
                try {
                    wrap = active[i].getConnection();
                }
                catch (CoreException ce) {
                    JMXUIActivator.getDefault().getLog().log(ce.getStatus());
                }
                --i;
            }
            if (wrap != null) {
                wrap.getProvider().addConnection(wrap);
                return true;
            }
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        ConnectionWizardPage[] active = this.getActivePages();
        if (active != null && active.length > 0 && page == this.firstPage) {
            return active[0];
        }
        if (active != null) {
            int i = 0;
            while (i < active.length) {
                if (active[i] == page && i + 1 < active.length) {
                    return active[i + 1];
                }
                ++i;
            }
        }
        return null;
    }

    public ConnectionWizardPage[] getActivePages() {
        if (this.selected != null) {
            return this.pageMap.get(this.selected.getId());
        }
        return null;
    }

    private class FirstPage
    extends WizardPage {
        TreeViewer viewer;

        public FirstPage() {
            super(Messages.NewConnectionWizard);
            this.setTitle(Messages.NewConnectionWizard_CreateNewConnection);
        }

        public void createControl(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)new FillLayout());
            this.viewer = new TreeViewer(main);
            this.viewer.setContentProvider((IContentProvider)new FirstPageContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new FirstPageLabelProvider());
            this.viewer.setInput((Object)this);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    FirstPage.this.viewerSelectionChanged();
                }
            });
            this.setControl((Control)main);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TreeItem item = FirstPage.this.viewer.getTree().getItems()[0];
                    FirstPage.this.viewer.setSelection((ISelection)new StructuredSelection(item.getData()));
                }
            });
        }

        private void viewerSelectionChanged() {
            IStructuredSelection ssel = (IStructuredSelection)this.viewer.getSelection();
            IConnectionProvider cp = (IConnectionProvider)ssel.getFirstElement();
            NewConnectionWizard.this.selected = cp;
            this.getContainer().updateButtons();
        }
    }

    private class FirstPageContentProvider
    implements ITreeContentProvider {
        private FirstPageContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IConnectionProvider> providers = new ArrayList<IConnectionProvider>();
            HashMap<String, UIExtensionManager.ConnectionProviderUI> map = UIExtensionManager.getConnectionUIElements();
            Set<String> keys = map.keySet();
            for (String id : keys) {
                if (ExtensionManager.getProvider((String)id) == null || !ExtensionManager.getProvider((String)id).canCreate()) continue;
                providers.add(ExtensionManager.getProvider((String)id));
            }
            return providers.toArray(new IConnectionProvider[providers.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class FirstPageLabelProvider
    extends LabelProvider {
        private HashMap<String, Image> images = new HashMap();

        private FirstPageLabelProvider() {
        }

        public void dispose() {
            Iterator<Image> i = this.images.values().iterator();
            while (i.hasNext()) {
                i.next().dispose();
            }
            super.dispose();
        }

        public Image getImage(Object element) {
            UIExtensionManager.ConnectionProviderUI ui;
            if (element instanceof IConnectionProvider && (ui = UIExtensionManager.getConnectionProviderUI(((IConnectionProvider)element).getId())) != null) {
                if (this.images.containsKey(ui.getId())) {
                    return this.images.get(ui.getId());
                }
                this.images.put(ui.getId(), ui.getImageDescriptor().createImage());
                return this.images.get(ui.getId());
            }
            return null;
        }

        public String getText(Object element) {
            UIExtensionManager.ConnectionProviderUI ui;
            if (element instanceof IConnectionProvider && (ui = UIExtensionManager.getConnectionProviderUI(((IConnectionProvider)element).getId())) != null) {
                return ui.getName();
            }
            return element == null ? "" : element.toString();
        }
    }
}

