/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core.tree;

import javax.management.ObjectName;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.tree.DomainNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.core.tree.ObjectNameNode;
import org.jboss.tools.jmx.core.tree.PropertyNode;
import org.jboss.tools.jmx.core.tree.Root;

public class NodeBuilder {
    public static void addToList(Node root, ObjectName on) {
        Node node = NodeBuilder.buildDomainNode(root, on.getDomain());
        node = NodeBuilder.buildObjectNameNode(node, "on", on.getKeyPropertyListString(), on);
    }

    public static void addToTree(Node root, ObjectName on) {
        Node node = NodeBuilder.buildDomainNode(root, on.getDomain());
        String keyPropertyListString = on.getKeyPropertyListString();
        String[] properties = keyPropertyListString.split(",");
        int i = 0;
        while (i < properties.length) {
            String property = properties[i];
            String key = property.substring(0, property.indexOf(61));
            String value = property.substring(property.indexOf(61) + 1, property.length());
            node = i == properties.length - 1 ? NodeBuilder.buildObjectNameNode(node, key, value, on) : NodeBuilder.buildPropertyNode(node, key, value);
            ++i;
        }
    }

    public static Root createRoot(IConnectionWrapper connection) {
        return new Root(connection);
    }

    static Node buildDomainNode(Node parent, String domain) {
        DomainNode n = new DomainNode(parent, domain);
        if (parent != null) {
            return parent.addChildren(n);
        }
        return n;
    }

    static Node buildPropertyNode(Node parent, String key, String value) {
        PropertyNode n = new PropertyNode(parent, key, value);
        if (parent != null) {
            return parent.addChildren(n);
        }
        return n;
    }

    static Node buildObjectNameNode(Node parent, String key, String value, ObjectName on) {
        ObjectNameNode n = new ObjectNameNode(parent, key, value, on);
        if (parent != null) {
            return parent.addChildren(n);
        }
        return n;
    }
}

