/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core.tree;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXCoreMessages;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.core.tree.NodeBuilder;
import org.jboss.tools.jmx.core.tree.ObjectNameNode;
import org.jboss.tools.jmx.core.tree.Root;

public class NodeUtils {
    public static ObjectNameNode findObjectNameNode(Node node, ObjectName objectName) {
        ObjectNameNode onNode;
        Assert.isNotNull((Object)node);
        if (node instanceof ObjectNameNode && (onNode = (ObjectNameNode)node).getObjectName().equals(objectName)) {
            return onNode;
        }
        Node[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            Node child = children[i];
            ObjectNameNode found = NodeUtils.findObjectNameNode(child, objectName);
            if (found != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    public static Root createObjectNameTree(final IConnectionWrapper connectionWrapper, final IProgressMonitor monitor) throws JMXException {
        final Root[] _root = new Root[1];
        connectionWrapper.run(new IJMXRunnable(){

            public void run(MBeanServerConnection connection) throws Exception {
                monitor.beginTask(JMXCoreMessages.LoadMBeans, 1000);
                Set<ObjectName> beanInfo = connection.queryNames(new ObjectName("*:*"), null);
                monitor.worked(100);
                SubProgressMonitor subMon = new SubProgressMonitor(monitor, 900);
                subMon.beginTask(JMXCoreMessages.InspectMBeans, beanInfo.size() * 100);
                _root[0] = NodeBuilder.createRoot(connectionWrapper);
                for (ObjectName on : beanInfo) {
                    NodeBuilder.addToTree(_root[0], on);
                    subMon.worked(100);
                }
                subMon.done();
                monitor.done();
            }
        });
        return _root[0];
    }
}

