/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.common.editor.XMLEditorLauncher;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.struts.model.StrutsConfigLoader;
import org.jboss.tools.struts.ui.StrutsUIPlugin;
import org.jboss.tools.struts.ui.editor.ExternalFileEditorInput;

public class AuxiliaryFileLauncher
implements IEditorLauncher {
    static String LAYOUT_FILE_EXTENSION = StrutsConfigLoader.LAYOUT_FILE_EXTENSION;

    public void open(IFile file) {
        String s = file.getLocation().lastSegment();
        if (!s.endsWith("." + LAYOUT_FILE_EXTENSION)) {
            return;
        }
        s = s.substring(1, s.length() - LAYOUT_FILE_EXTENSION.length() - 1);
        IResource r = file.getParent().findMember(s);
        if (!(r instanceof IFile) || !r.exists()) {
            return;
        }
        this.open((IEditorInput)new FileEditorInput((IFile)r));
    }

    public void open(File file) {
        String s = file.getAbsolutePath();
        if (s.endsWith("." + LAYOUT_FILE_EXTENSION)) {
            File f = new File(s = s.substring(1, s.length() - LAYOUT_FILE_EXTENSION.length() - 1));
            if (!f.isFile()) {
                return;
            }
            this.open(new ExternalFileEditorInput(f));
        }
    }

    private void open(IEditorInput input) {
        IWorkbenchPage workbenchPage = ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            workbenchPage.openEditor(input, "org.jboss.tools.common.model.ui.editor.EditorPartWrapper");
        }
        catch (Exception e) {
            StrutsUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void open(IPath path) {
        if (path == null) {
            return;
        }
        IFile f = XMLEditorLauncher.convert((IPath)path);
        if (f != null && f.exists()) {
            this.open(f);
        } else if (path.toFile().isFile()) {
            this.open(path.toFile());
        }
    }
}

