/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor;

import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.editor.ObjectTextEditor;
import org.jboss.tools.common.gef.outline.xpl.DiagramContentOutlinePage;
import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.editor.EditorDescriptor;
import org.jboss.tools.common.model.ui.texteditors.XMLTextEditorComponent;
import org.jboss.tools.struts.StrutsPreference;
import org.jboss.tools.struts.model.FileSystemsTreeConstraint;
import org.jboss.tools.struts.ui.StrutsUIPlugin;
import org.jboss.tools.struts.ui.editor.StrutsConfigGuiEditor;

public class StrutsConfigEditor
extends ObjectMultiPageEditor {
    protected StrutsConfigGuiEditor guiEditor;
    protected XFilteredTreeConstraint constraint = new FileSystemsTreeConstraint();
    OptionListener optionListener = null;

    protected Composite createPageContainer(Composite parent) {
        Composite composite = super.createPageContainer(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.jboss.tools.struts.ui.struts_config_editor");
        return composite;
    }

    public StrutsConfigEditor() {
        FileSystemsTreeConstraint constraint2 = new FileSystemsTreeConstraint();
        this.outline.addFilter((XFilteredTreeConstraint)constraint2);
    }

    protected boolean isWrongEntity(String entity) {
        return !entity.startsWith("StrutsConfig");
    }

    protected String[] getSupportedNatures() {
        return new String[]{"org.jboss.tools.struts.strutsnature"};
    }

    protected String getNatureWarningMessageKey() {
        return "SharableEditors.natureWarning.struts.message";
    }

    protected void doCreatePages() {
        if (this.isAppropriateNature()) {
            if (!"yes".equals(StrutsPreference.DO_NOT_SHOW_DIAGRAM.getValue())) {
                this.createGuiPage();
            }
            this.treeFormPage = this.createTreeFormPage();
            this.treeFormPage.setTitle("Struts Config Editor");
            this.treeFormPage.addFilter(this.constraint);
            this.treeFormPage.initialize((Object)this.getModelObject());
            this.addFormPage(this.treeFormPage);
        }
        this.createTextPage();
        this.initEditors();
        this.initPreferenceListener();
        if (this.treeFormPage != null) {
            this.selectionProvider.addHost("treeEditor", this.treeFormPage.getSelectionProvider());
        }
    }

    protected void createGuiPage() {
        try {
            this.guiEditor = new StrutsConfigGuiEditor();
            this.guiEditor.init(this.getEditorSite(), this.getEditorInput());
            int index = this.addPage((IEditorPart)this.guiEditor, (IEditorInput)this.input);
            this.setPageText(index, "Diagram");
            this.guiEditor.setInput((IEditorInput)this.input);
            this.selectionProvider.setHost(this.guiEditor.getSelectionProvider());
            this.guiEditor.addErrorSelectionListener(this.createErrorSelectionListener());
            this.selectionProvider.addHost("guiEditor", this.guiEditor.getSelectionProvider());
        }
        catch (Exception ex) {
            StrutsUIPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    protected ObjectTextEditor createTextEditor() {
        return new XMLTextEditorComponent();
    }

    public void dispose() {
        if (this.input != null) {
            this.selectionProvider.setHost(null);
            try {
                this.getSite().setSelectionProvider(null);
            }
            catch (Exception e) {
                StrutsUIPlugin.getPluginLog().logError((Throwable)e);
            }
            if (this.guiEditor != null) {
                this.guiEditor.dispose();
                this.guiEditor = null;
            }
        }
        if (this.optionListener != null) {
            PreferenceModelUtilities.getPreferenceModel().removeModelTreeListener((XModelTreeListener)this.optionListener);
            this.optionListener = null;
        }
        super.dispose();
    }

    protected void setErrorMode() {
        this.setNormalMode();
    }

    protected void setNormalMode() {
        if (this.guiEditor != null) {
            this.guiEditor.setObject(this.getModelObject(), this.isErrorMode());
            this.updateSelectionProvider();
        }
        if (this.treeEditor != null) {
            this.treeEditor.setObject(this.object, this.isErrorMode());
        }
        if (this.treeFormPage != null) {
            this.treeFormPage.initialize((Object)this.getModelObject());
            this.treeFormPage.setErrorMode(this.isErrorMode());
        }
    }

    protected int getGuiPageIndex() {
        return 0;
    }

    public boolean isGuiEditorActive() {
        return this.getActivePage() == this.getGuiPageIndex();
    }

    private void initPreferenceListener() {
        if (this.optionListener == null) {
            this.optionListener = new OptionListener();
            PreferenceModelUtilities.getPreferenceModel().addModelTreeListener((XModelTreeListener)this.optionListener);
        }
    }

    protected void revalidateGuiPage() {
        boolean doNotShowDiagram = "yes".equals(StrutsPreference.DO_NOT_SHOW_DIAGRAM.getValue());
        if (doNotShowDiagram == (this.guiEditor == null)) {
            return;
        }
        if (doNotShowDiagram) {
            this.setActivePage(1);
            this.removePage(0);
            this.guiEditor.dispose();
            this.guiEditor = null;
        } else if (this.getPageCount() > 0) {
            while (this.getPageCount() > 0) {
                this.removePage(0);
            }
            this.doCreatePages();
        } else {
            this.createGuiPage();
        }
    }

    protected void updateSelectionProvider() {
        int index;
        if (this.guiEditor != null) {
            this.selectionProvider.addHost("guiEditor", this.guiEditor.getSelectionProvider());
        }
        if (this.textEditor != null) {
            this.selectionProvider.addHost("textEditor", (ISelectionProvider)this.getTextSelectionProvider());
        }
        if ((index = this.getActivePage()) == this.getSourcePageIndex()) {
            if (this.textEditor != null) {
                this.selectionProvider.setHost((ISelectionProvider)this.getTextSelectionProvider());
            }
            return;
        }
        if (index == 1 || this.guiEditor == null || this.guiEditor.getSelectionProvider() == null) {
            if (this.treeEditor != null) {
                this.selectionProvider.setHost(this.treeEditor.getSelectionProvider());
                this.treeEditor.fireEditorSelected();
            }
            if (this.treeFormPage != null) {
                this.selectionProvider.addHost("treeEditor", this.treeFormPage.getSelectionProvider(), true);
            }
        } else {
            ISelectionProvider p = this.guiEditor.getSelectionProvider();
            this.selectionProvider.setHost(p);
            if (p instanceof AbstractSelectionProvider) {
                ((AbstractSelectionProvider)p).fireSelectionChanged();
            }
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.getGuiPageIndex();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            if (this.guiEditor == null || this.guiEditor.getGUI() == null) {
                return super.getAdapter(adapter);
            }
            Object o = this.guiEditor.getGUI().getAdapter(adapter);
            if (o instanceof DiagramContentOutlinePage) {
                DiagramContentOutlinePage g = (DiagramContentOutlinePage)o;
                g.setTreeOutline((ContentOutlinePage)this.outline);
            }
            return o;
        }
        if ((adapter == ActionRegistry.class || adapter == ZoomManager.class) && this.guiEditor != null && this.guiEditor.getGUI() != null) {
            return this.guiEditor.getGUI().getAdapter(adapter);
        }
        if (adapter == EditorDescriptor.class) {
            return new EditorDescriptor("faces-config");
        }
        if (adapter == StrutsConfigEditor.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    class OptionListener
    implements XModelTreeListener {
        OptionListener() {
        }

        public void nodeChanged(XModelTreeEvent event) {
            if (StrutsPreference.WEB_FLOW_DIAGRAM_PATH.equals(event.getModelObject().getPath())) {
                StrutsConfigEditor.this.revalidateGuiPage();
                StrutsConfigEditor.this.setActivePage(0);
                StrutsConfigEditor.this.pageChange(0);
            }
        }

        public void structureChanged(XModelTreeEvent event) {
        }
    }
}

