/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor;

import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.jboss.tools.common.editor.AbstractSectionEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.jst.web.model.WebProcess;
import org.jboss.tools.struts.ui.StrutsUIPlugin;
import org.jboss.tools.struts.ui.editor.StrutsEditor;
import org.jboss.tools.struts.ui.editor.model.impl.StrutsModel;

public class StrutsConfigGuiEditor
extends AbstractSectionEditor {
    private StrutsEditor gui = null;
    private IModelObjectEditorInput input;
    private boolean isInitialized = false;
    private XModelObject installedProcess = null;
    private StrutsModel model;

    public StrutsEditor getGUI() {
        return this.gui;
    }

    protected boolean isWrongEntity(String entity) {
        return !entity.startsWith("StrutsConfig");
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.input = (IModelObjectEditorInput)input;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.gui == null ? null : this.gui.getModelSelectionProvider();
    }

    protected XModelObject getInstalledObject() {
        return this.installedProcess;
    }

    private WebProcess findInstalledObject() {
        XModelObject o1 = this.input.getXModelObject();
        if (o1 == null) {
            return null;
        }
        XModelObject c = o1.getChildByPath("process");
        if (!(c instanceof WebProcess)) {
            return null;
        }
        WebProcess f = (WebProcess)c;
        return !f.isPrepared() ? null : f;
    }

    protected void updateGui() {
        WebProcess f = this.findInstalledObject();
        if (f != this.installedProcess) {
            this.disposeGui();
        } else if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.installedProcess = f;
        this.guiControl.setVisible(f != null);
        if (f == null) {
            return;
        }
        try {
            f.autolayout();
            this.gui = new StrutsEditor((IEditorInput)this.input);
            this.model = new StrutsModel(f.getParent());
            this.model.updateLinks();
            this.gui.setStrutsModel(this.model);
            this.gui.init((IEditorSite)this.getSite(), (IEditorInput)this.input);
            this.gui.createPartControl(this.guiControl);
            this.control = this.guiControl.getChildren()[0];
            this.control.setLayoutData((Object)new GridData(1808));
            this.guiControl.layout();
            this.wrapper.update();
            this.wrapper.layout();
        }
        catch (Exception ex) {
            StrutsUIPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    public void dispose() {
        if (this.model == null) {
            return;
        }
        this.model.disconnectFromModel();
        this.model = null;
        this.disposeGui();
        this.gui = null;
        this.input = null;
        this.installedProcess = null;
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if ((adapter == ActionRegistry.class || adapter == ZoomManager.class) && this.getGUI() != null) {
            return this.getGUI().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }
}

