/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.struts.ui.editor.edit.LinkEditPart;
import org.jboss.tools.struts.ui.editor.edit.ProcessItemEditPart;
import org.jboss.tools.struts.ui.editor.edit.StrutsDiagramEditPart;
import org.jboss.tools.struts.ui.editor.edit.StrutsEditPart;
import org.jboss.tools.struts.ui.editor.figures.BreakPointFigure;
import org.jboss.tools.struts.ui.editor.model.IStrutsElement;
import org.jboss.tools.struts.ui.editor.model.IStrutsModel;

public class StrutsContextMenuProvider
extends ContextMenuProvider {
    private MouseEvent lastDownEvent = null;
    private IStrutsModel model;

    public StrutsContextMenuProvider(IStrutsModel model, EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        this.model = model;
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StrutsContextMenuProvider.this.lastDownEvent = e;
            }
        });
        this.setActionRegistry(registry);
    }

    public void buildContextMenu(IMenuManager manager) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)manager);
    }

    private void setActionRegistry(ActionRegistry registry) {
    }

    protected void update(boolean force, boolean recursive) {
        if (!this.isDirty() && !force) {
            return;
        }
        if (!this.menuExist()) {
            return;
        }
        MenuItem[] is = this.getMenu().getItems();
        int i = 0;
        while (i < is.length) {
            if (!is[i].isDisposed()) {
                is[i].dispose();
            }
            ++i;
        }
        ISelection s = this.getViewer().getSelection();
        if (s.isEmpty() || !(s instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection ss = (StructuredSelection)s;
        XModelObject object = this.getTarget(ss.getFirstElement());
        if (object != null) {
            XModelObjectActionList list;
            Properties p = new Properties();
            if (this.lastDownEvent != null) {
                Point point = new Point(this.lastDownEvent.x, this.lastDownEvent.y);
                ((StrutsDiagramEditPart)this.getViewer().getRootEditPart().getChildren().get(0)).getFigure().translateToRelative((Translatable)point);
                p.setProperty("process.mouse.x", "" + point.x);
                p.setProperty("process.mouse.y", "" + point.y);
                this.lastDownEvent = null;
            }
            if (ss.getFirstElement() instanceof LinkEditPart) {
                LinkEditPart lep = (LinkEditPart)ss.getFirstElement();
                if (BreakPointFigure.itemFlag) {
                    BreakPointFigure.itemFlag = false;
                    XModelObject xmo = (XModelObject)lep.getLinkModel().getToProcessItem().getSource();
                    list = new XModelObjectActionList(xmo.getModel().getMetaData().getEntity(String.valueOf(xmo.getModelEntity().getName()) + "_BreakpointActions").getActionList(), xmo, null, (Object)new Object[]{xmo, p});
                } else if (BreakPointFigure.outputFlag) {
                    BreakPointFigure.outputFlag = false;
                    list = new XModelObjectActionList(object.getModel().getMetaData().getEntity("StrutsProcessItemOutput_BreakpointActions").getActionList(), object, null, (Object)new Object[]{object, p});
                } else {
                    list = new XModelObjectActionList(this.model.getHelper().getLinkActionList(object), object, null, (Object)new Object[]{object, p});
                }
            } else if (ss.getFirstElement() instanceof ProcessItemEditPart) {
                ProcessItemEditPart pep = (ProcessItemEditPart)ss.getFirstElement();
                if (BreakPointFigure.itemFlag) {
                    BreakPointFigure.itemFlag = false;
                    XModelObject xmo = (XModelObject)pep.getProcessItemModel().getSource();
                    list = new XModelObjectActionList(xmo.getModel().getMetaData().getEntity(String.valueOf(xmo.getModelEntity().getName()) + "_BreakpointActions").getActionList(), xmo, null, (Object)new Object[]{xmo, p});
                } else {
                    list = new XModelObjectActionList(object.getModelEntity().getActionList(), object, this.getTargets(ss), (Object)new Object[]{object, p});
                }
            } else {
                list = new XModelObjectActionList(object.getModelEntity().getActionList(), object, this.getTargets(ss), (Object)new Object[]{object, p});
            }
            Menu menu = this.getMenu();
            list.createMenu(menu);
            list.removeLastSeparator(menu);
        }
    }

    private XModelObject[] getTargets(StructuredSelection ss) {
        if (ss.size() < 2) {
            return null;
        }
        Iterator it = ss.iterator();
        ArrayList<XModelObject> l = new ArrayList<XModelObject>();
        while (it.hasNext()) {
            XModelObject o = this.getTarget(it.next());
            if (o == null) continue;
            l.add(o);
        }
        return l.toArray(new XModelObject[0]);
    }

    private XModelObject getTarget(Object selected) {
        PropertyChangeListener part;
        Object partModel;
        if (selected instanceof StrutsEditPart && (partModel = (part = (StrutsEditPart)selected).getModel()) instanceof IStrutsElement) {
            return (XModelObject)((IStrutsElement)partModel).getSource();
        }
        if (selected instanceof LinkEditPart && (partModel = (part = (LinkEditPart)selected).getModel()) instanceof IStrutsElement) {
            return (XModelObject)((IStrutsElement)partModel).getSource();
        }
        return null;
    }
}

