/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.stackview.CommandStackInspectorPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.gef.GEFConnectionCreationToolEntry;
import org.jboss.tools.common.gef.GEFEditor;
import org.jboss.tools.common.gef.action.DiagramAlignmentAction;
import org.jboss.tools.common.gef.action.DiagramMatchWidthAction;
import org.jboss.tools.common.gef.action.IDiagramSelectionProvider;
import org.jboss.tools.common.gef.edit.GEFRootEditPart;
import org.jboss.tools.common.gef.editor.xpl.DefaultPaletteCustomizer;
import org.jboss.tools.common.gef.outline.xpl.DiagramContentOutlinePage;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.outline.XModelObjectContentOutlineProvider;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.ui.StrutsUIPlugin;
import org.jboss.tools.struts.ui.editor.ActionTemplate;
import org.jboss.tools.struts.ui.editor.GlobalExceptionTemplate;
import org.jboss.tools.struts.ui.editor.GlobalForwardTemplate;
import org.jboss.tools.struts.ui.editor.PageTemplate;
import org.jboss.tools.struts.ui.editor.StrutsContextMenuProvider;
import org.jboss.tools.struts.ui.editor.actions.StrutsCopyAction;
import org.jboss.tools.struts.ui.editor.actions.StrutsCutAction;
import org.jboss.tools.struts.ui.editor.actions.StrutsDeleteAction;
import org.jboss.tools.struts.ui.editor.actions.StrutsPasteAction;
import org.jboss.tools.struts.ui.editor.dnd.DndHelper;
import org.jboss.tools.struts.ui.editor.dnd.FileTransferDropTargetListener;
import org.jboss.tools.struts.ui.editor.dnd.StrutsTemplateTransferDropTargetListener;
import org.jboss.tools.struts.ui.editor.dnd.XModelTransferDropTargetListener;
import org.jboss.tools.struts.ui.editor.edit.CommentEditPart;
import org.jboss.tools.struts.ui.editor.edit.ForwardEditPart;
import org.jboss.tools.struts.ui.editor.edit.GraphicalPartFactory;
import org.jboss.tools.struts.ui.editor.edit.LinkEditPart;
import org.jboss.tools.struts.ui.editor.edit.ProcessItemEditPart;
import org.jboss.tools.struts.ui.editor.edit.StrutsConnectionRouter;
import org.jboss.tools.struts.ui.editor.edit.StrutsDiagramEditPart;
import org.jboss.tools.struts.ui.editor.edit.StrutsEditPart;
import org.jboss.tools.struts.ui.editor.figures.ProcessItemFigure;
import org.jboss.tools.struts.ui.editor.model.IForward;
import org.jboss.tools.struts.ui.editor.model.ILink;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;
import org.jboss.tools.struts.ui.editor.model.IStrutsElement;
import org.jboss.tools.struts.ui.editor.model.IStrutsModel;
import org.jboss.tools.struts.ui.editor.model.IStrutsModelListener;
import org.jboss.tools.struts.ui.editor.palette.StrutsPaletteViewerPreferences;
import org.jboss.tools.struts.ui.editor.print.Page;
import org.jboss.tools.struts.ui.editor.print.PageFormat;
import org.jboss.tools.struts.ui.editor.print.Pages;
import org.jboss.tools.struts.ui.editor.print.PrintPreviewDialog;

public class StrutsEditor
extends GEFEditor
implements IStrutsModelListener {
    public static byte JSF_DIAGRAM_RENAME;
    private boolean isCommentsVisible = false;
    public XModelObjectContentOutlineProvider poutline;
    private IStrutsModel model;
    ScrollingGraphicalViewer viewer;
    private static GEFConnectionCreationToolEntry connectionCreationTool;
    private static boolean switchToSelectionTool;
    private ModelSelectionProvider modelSelectionProvider = new ModelSelectionProvider();
    public static Blinker blinker;

    static {
        connectionCreationTool = null;
        switchToSelectionTool = false;
        blinker = new Blinker();
    }

    public boolean isBordersPaint() {
        return this.getStrutsModel().isBorderPaint();
    }

    protected void createPaletteViewer(Composite parent) {
        PaletteViewer viewer = new PaletteViewer();
        viewer.createControl(parent);
        StrutsPaletteViewerPreferences prefs = new StrutsPaletteViewerPreferences(this);
        prefs.setUseLargeIcons(1, false);
        prefs.setUseLargeIcons(0, false);
        prefs.setUseLargeIcons(2, false);
        prefs.setUseLargeIcons(3, false);
        prefs.setLayoutSetting(0);
        this.setPaletteViewer(viewer);
        this.setPaletteLayout((PaletteViewerPreferences)prefs, this.loadPaletteSize());
        this.paletteViewer.setPaletteViewerPreferences((PaletteViewerPreferences)prefs);
        this.configurePaletteViewer();
        this.hookPaletteViewer();
        this.initializePaletteViewer();
    }

    public StrutsEditor(IEditorInput input) {
        super(input);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    protected void configurePaletteViewer() {
        PaletteViewer viewer = this.getPaletteViewer();
        PaletteContextMenuProvider provider = new PaletteContextMenuProvider(viewer);
        this.getPaletteViewer().setContextMenu((MenuManager)provider);
        viewer.setCustomizer((PaletteCustomizer)new DefaultPaletteCustomizer());
    }

    public ScrollingGraphicalViewer getScrollingGraphicalViewer() {
        return this.viewer;
    }

    protected void configureGraphicalViewer() {
        this.viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.modelSelectionProvider);
        GEFRootEditPart root = new GEFRootEditPart();
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        root.getZoomManager().setZoomLevels(new double[]{0.25, 0.5, 0.75, 1.0});
        root.getZoomManager().setZoom(this.loadZoomSize());
        root.getZoomManager().addZoomListener(new ZoomListener(){

            public void zoomChanged(double zoom) {
                StrutsEditor.this.saveZoomSize(zoom);
            }
        });
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.viewer.setRootEditPart((RootEditPart)root);
        this.viewer.setEditPartFactory((EditPartFactory)new GraphicalPartFactory());
        StrutsContextMenuProvider provider = new StrutsContextMenuProvider(this.model, (EditPartViewer)this.viewer, this.getActionRegistry());
        this.viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("StrutsContextmenu", (MenuManager)provider, (ISelectionProvider)this.viewer);
        this.viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)this.viewer).setParent(this.getCommonKeyHandler()));
    }

    public void mouseDoubleClick(MouseEvent e) {
        boolean controlFlag = (e.stateMask & 0x40000) > 0;
        EditPart part = this.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        if (part instanceof StrutsEditPart) {
            ((StrutsEditPart)part).doDoubleClick(controlFlag);
        } else if (part instanceof LinkEditPart) {
            ((LinkEditPart)part).doDoubleClick(controlFlag);
        }
    }

    public void mouseDown(MouseEvent e) {
        boolean controlFlag = (e.stateMask & 0x40000) > 0;
        EditPart part = this.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        if (part instanceof StrutsEditPart) {
            ((StrutsEditPart)part).doMouseDown(controlFlag);
        } else if (part instanceof LinkEditPart) {
            ((LinkEditPart)part).doMouseDown(controlFlag);
        }
    }

    public void mouseUp(MouseEvent e) {
        boolean controlFlag = (e.stateMask & 0x40000) > 0;
        EditPart part = this.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        if (part instanceof StrutsEditPart) {
            ((StrutsEditPart)part).doMouseUp(controlFlag);
        } else if (part instanceof LinkEditPart) {
            ((LinkEditPart)part).doMouseUp(controlFlag);
        }
    }

    public Control getControl() {
        return this.getPaletteViewer().getControl();
    }

    protected void createOutputStream(OutputStream os) throws IOException {
    }

    public void dispose() {
        this.model.removeStrutsModelListener(this);
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
    }

    public void doSaveAs() {
        this.performSaveAs();
    }

    public void setParentOutline(XModelObjectContentOutlineProvider poutline) {
        this.poutline = poutline;
    }

    public Object getAdapter(Class type) {
        if (type == IDiagramSelectionProvider.class) {
            if (this.getScrollingGraphicalViewer() == null) {
                return null;
            }
            return new IDiagramSelectionProvider(){

                public ISelection getSelection() {
                    if (StrutsEditor.this.getScrollingGraphicalViewer() == null) {
                        return null;
                    }
                    return StrutsEditor.this.getScrollingGraphicalViewer().getSelection();
                }
            };
        }
        if (type == CommandStackInspectorPage.class) {
            return new CommandStackInspectorPage(this.getCommandStack());
        }
        if (type == IContentOutlinePage.class) {
            DiagramContentOutlinePage outline = new DiagramContentOutlinePage((EditPartViewer)new TreeViewer());
            outline.setGraphicalViewer(this.getGraphicalViewer());
            outline.setSelectionSynchronizer(this.getSelectionSynchronizer());
            return outline;
        }
        if (type == ZoomManager.class && this.getGraphicalViewer() != null) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    protected int getInitialPaletteSize() {
        return 23;
    }

    protected void handlePaletteResized(int newSize) {
    }

    public IStrutsModel getStrutsModel() {
        return this.model;
    }

    protected List createCategories(PaletteRoot root) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(this.createControlGroup(root));
        return categories;
    }

    protected PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup("control");
        ArrayList<Object> entries = new ArrayList<Object>();
        SelectionToolEntry tool = new SelectionToolEntry();
        tool.setDescription(StrutsUIMessages.DIAGRAM_TOOLBAR_SELECTION);
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        tool.setDescription(StrutsUIMessages.DIAGRAM_TOOLBAR_MARQUEE);
        entries.add(tool);
        PaletteSeparator sep = new PaletteSeparator("separator");
        sep.setUserModificationPermission(1);
        entries.add(sep);
        connectionCreationTool = new GEFConnectionCreationToolEntry(StrutsUIMessages.DIAGRAM_TOOLBAR_CREATE_CONNECTION, StrutsUIMessages.DIAGRAM_TOOLBAR_CREATE_CONNECTION, null, ImageDescriptor.createFromFile(StrutsEditor.class, (String)"icons/transition.gif"), null){

            protected void dragFinished() {
                DndHelper.dragEnd();
            }
        };
        connectionCreationTool.setUnloadWhenFinished(switchToSelectionTool);
        entries.add(connectionCreationTool);
        entries.add(sep);
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(StrutsUIMessages.DIAGRAM_TOOLBAR_ADD_ACTION, StrutsUIMessages.DIAGRAM_TOOLBAR_ADD_ACTION, (Object)"action template", (CreationFactory)new SimpleFactory(ActionTemplate.class), ImageDescriptor.createFromFile(StrutsEditor.class, (String)"icons/new_action.gif"), null);
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry(StrutsUIMessages.DIAGRAM_TOOLBAR_ADD_GLOBAL_FORWARD, StrutsUIMessages.DIAGRAM_TOOLBAR_ADD_GLOBAL_FORWARD, (Object)"global forward template", (CreationFactory)new SimpleFactory(GlobalForwardTemplate.class), ImageDescriptor.createFromFile(StrutsEditor.class, (String)"icons/new_global_forward.gif"), null);
        entries.add(combined);
        if (!this.model.getHelper().isStruts10((XModelObject)this.model.getSource())) {
            combined = new CombinedTemplateCreationEntry(StrutsUIMessages.DIAGRAM_TOOLBAR_ADD_GLOBAL_EXCEPTION, StrutsUIMessages.DIAGRAM_TOOLBAR_ADD_GLOBAL_EXCEPTION, (Object)"global exception template", (CreationFactory)new SimpleFactory(GlobalExceptionTemplate.class), ImageDescriptor.createFromFile(StrutsEditor.class, (String)"icons/new_exception.gif"), null);
            entries.add(combined);
        }
        combined = new CombinedTemplateCreationEntry(StrutsUIMessages.DIAGRAM_TOOLBAR_ADD_PAGE, StrutsUIMessages.DIAGRAM_TOOLBAR_ADD_PAGE, (Object)"page template", (CreationFactory)new SimpleFactory(PageTemplate.class), ImageDescriptor.createFromFile(StrutsEditor.class, (String)"icons/new_jsp_file.gif"), null);
        entries.add(combined);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    protected PaletteRoot createPalette() {
        PaletteRoot JSFPalette = new PaletteRoot();
        JSFPalette.addAll(this.createCategories(JSFPalette));
        return JSFPalette;
    }

    public void gotoMarker(IMarker marker) {
    }

    protected void hookPaletteViewer() {
        this.getEditDomain().setPaletteViewer(this.paletteViewer);
        this.getPaletteViewer().getContextMenu().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
            }
        });
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.getStrutsModel());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new XModelTransferDropTargetListener(this));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new FileTransferDropTargetListener(this));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new StrutsTemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        ((ConnectionLayer)((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getLayer((Object)"Connection Layer")).setConnectionRouter((ConnectionRouter)new StrutsConnectionRouter());
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)new Boolean(true));
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)new Boolean(true));
        this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(8, 8));
    }

    protected void initializePaletteViewer() {
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
        FigureCanvas canvas = (FigureCanvas)this.paletteViewer.getControl();
        this.makeUnwrapPaletteItems(canvas.getContents());
        canvas.getContents().revalidate();
        canvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        canvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        this.getPaletteViewer().addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)this.getPaletteViewer()));
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        this.addAction(registry, (IAction)new StrutsDeleteAction((IWorkbenchPart)this), true);
        this.addAction(registry, (IAction)new StrutsCopyAction((IWorkbenchPart)this), true);
        this.getSite().getKeyBindingService();
        this.addAction(registry, (IAction)new StrutsPasteAction((IWorkbenchPart)this), true);
        this.addAction(registry, (IAction)new StrutsCutAction((IWorkbenchPart)this), true);
        this.addAction(registry, (IAction)new MyPrintAction((IEditorPart)this), false);
        this.addAction(registry, (IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 1), true);
        this.addAction(registry, (IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 4), true);
        this.addAction(registry, (IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 8), true);
        this.addAction(registry, (IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 32), true);
        this.addAction(registry, (IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 2), true);
        this.addAction(registry, (IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 16), true);
        this.addAction(registry, (IAction)new DiagramMatchWidthAction((IWorkbenchPart)this), true);
    }

    void addAction(ActionRegistry registry, IAction action, boolean isSelectionAction) {
        registry.registerAction(action);
        if (isSelectionAction) {
            this.getSelectionActions().add(action.getId());
        }
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    protected boolean performSaveAs() {
        return false;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    public void setInput(XModelObject input) {
    }

    public void setStrutsModel(IStrutsModel diagram) {
        this.model = diagram;
        this.model.addStrutsModelListener(this);
        switchToSelectionTool = this.model.getOptions().switchToSelectionTool();
        this.isCommentsVisible = this.model.areCommentsVisible();
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    protected void superSetInput(IEditorInput input) {
        super.setInput(input);
    }

    public ISelectionProvider getModelSelectionProvider() {
        return this.modelSelectionProvider;
    }

    private XModelObject getTarget(ISelection ss) {
        if (ss.isEmpty() || !(ss instanceof StructuredSelection)) {
            return null;
        }
        return this.getTarget(((StructuredSelection)ss).getFirstElement());
    }

    private XModelObject getTarget(Object selected) {
        PropertyChangeListener part;
        Object partModel;
        if (selected instanceof StrutsEditPart && (partModel = (part = (StrutsEditPart)selected).getModel()) instanceof IStrutsElement) {
            return (XModelObject)((IStrutsElement)partModel).getSource();
        }
        if (selected instanceof LinkEditPart && (partModel = (part = (LinkEditPart)selected).getModel()) instanceof IStrutsElement) {
            return (XModelObject)((IStrutsElement)partModel).getSource();
        }
        return null;
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
    }

    public void processItemAdd(IProcessItem processItem) {
    }

    public void processItemRemove(IProcessItem processItem) {
    }

    public boolean isStrutsModelListenerEnabled() {
        return true;
    }

    public void linkAdd(ILink link) {
    }

    public void linkRemove(ILink link) {
    }

    public void processChanged(boolean flag) {
        if (switchToSelectionTool != this.model.getOptions().switchToSelectionTool()) {
            switchToSelectionTool = this.model.getOptions().switchToSelectionTool();
            connectionCreationTool.setUnloadWhenFinished(switchToSelectionTool);
        }
        if (this.isCommentsVisible != this.model.areCommentsVisible()) {
            this.isCommentsVisible = this.model.areCommentsVisible();
            int i = 0;
            while (i < this.model.getProcessItemList().size()) {
                IProcessItem processItem = (IProcessItem)this.model.getProcessItemList().get(i);
                if (processItem.isComment()) {
                    ((CommentEditPart)this.getGraphicalViewer().getEditPartRegistry().get(processItem)).getFigure().setVisible(this.isCommentsVisible);
                }
                ++i;
            }
        }
    }

    public static class Blinker
    extends Thread {
        private static Vector<Figure> listeners = new Vector();
        private static boolean blink = false;

        public Blinker() {
            super("");
            this.start();
        }

        public void run() {
            try {
                while (true) {
                    Blinker.sleep(750L);
                    blink = true;
                    this.fireRedraw();
                    Blinker.sleep(450L);
                    blink = false;
                    this.fireRedraw();
                }
            }
            catch (Exception ex) {
                StrutsUIPlugin.getPluginLog().logError((Throwable)ex);
                return;
            }
        }

        public boolean isBlink() {
            return blink;
        }

        public void addRedrawListener(Figure figure) {
            listeners.add(figure);
        }

        public void removeRedrawListener(Figure figure) {
            listeners.remove(figure);
        }

        public void fireRedraw() {
            if (listeners.size() == 0 || Display.getDefault() == null) {
                return;
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < listeners.size()) {
                        ((Figure)listeners.get(i)).repaint();
                        ++i;
                    }
                }
            });
        }
    }

    class ModelSelectionProvider
    extends AbstractSelectionProvider
    implements ISelectionChangedListener {
        ModelSelectionProvider() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.fireSelectionChanged();
            StrutsEditor.this.updateActions(StrutsEditor.this.getSelectionActions());
        }

        protected XModelObject getSelectedModelObject() {
            if (StrutsEditor.this.viewer == null) {
                return null;
            }
            XModelObject o = StrutsEditor.this.getTarget(StrutsEditor.this.viewer.getSelection());
            XModelObject ref = StrutsProcessStructureHelper.instance.getReferencedObject(o);
            return ref;
        }

        public void scroll(FreeformViewport vp, ProcessItemFigure figure) {
            int delta;
            int SCROLL_MARGIN = 20;
            Point origin = vp.getViewLocation();
            if (figure.getLocation().x - SCROLL_MARGIN < origin.x) {
                delta = origin.x - (figure.getLocation().x - SCROLL_MARGIN);
                origin.x -= delta;
            } else if (figure.getLocation().x + figure.getSize().width + SCROLL_MARGIN > origin.x + vp.getSize().width) {
                delta = figure.getLocation().x + figure.getSize().width + SCROLL_MARGIN - (origin.x + vp.getSize().width);
                origin.x += delta;
            }
            if (figure.getLocation().y - SCROLL_MARGIN < origin.y) {
                delta = origin.y - (figure.getLocation().y - SCROLL_MARGIN);
                origin.y -= delta;
            } else if (figure.getLocation().y + figure.getSize().height + SCROLL_MARGIN > origin.y + vp.getSize().height) {
                delta = figure.getLocation().y + figure.getSize().height + SCROLL_MARGIN - (origin.y + vp.getSize().height);
                origin.y += delta;
            }
            if (origin.x != vp.getViewLocation().x || origin.y != vp.getViewLocation().y) {
                vp.setViewLocation(origin);
            }
        }

        protected void setSelectedModelObject(XModelObject object) {
            IStrutsElement element = StrutsEditor.this.getStrutsModel().findElement(object.getPath());
            if (element == null) {
                return;
            }
            Object part = (EditPart)StrutsEditor.this.viewer.getEditPartRegistry().get(element);
            if (part == null && element instanceof IForward && ((IForward)element).getLink() != null) {
                part = (EditPart)StrutsEditor.this.viewer.getEditPartRegistry().get(((IForward)element).getLink());
            }
            if (part != null) {
                if (part instanceof ForwardEditPart) {
                    part = (LinkEditPart)((ForwardEditPart)part).getSourceConnections().get(0);
                }
                StrutsEditor.this.viewer.setSelection((ISelection)new StructuredSelection(part));
                StrutsDiagramEditPart diagram = (StrutsDiagramEditPart)StrutsEditor.this.getScrollingGraphicalViewer().getRootEditPart().getChildren().get(0);
                FreeformViewport vp = diagram.getFreeformViewport();
                if (vp != null && part instanceof ProcessItemEditPart) {
                    ProcessItemFigure fig = (ProcessItemFigure)((ProcessItemEditPart)part).getFigure();
                    if (fig.getLocation().x == 0 && fig.getLocation().y == 0) {
                        fig.setLocation(((ProcessItemEditPart)part).getProcessItemModel().getPosition());
                    }
                    this.scroll(vp, fig);
                }
            }
        }
    }

    public class MyPrintAction
    extends WorkbenchPartAction {
        private Insets margin;

        public MyPrintAction(IEditorPart editor) {
            super((IWorkbenchPart)editor);
            this.margin = new Insets(1, 1, 1, 1);
        }

        protected boolean calculateEnabled() {
            return true;
        }

        protected void init() {
            super.init();
            this.setText(StrutsUIMessages.PRINT_DIAGRAMM);
            this.setToolTipText(StrutsUIMessages.PRINT_DIAGRAMM);
            this.setId("Print_Diagram");
        }

        public Rectangle getPrintRegion(Printer printer) {
            printer.computeTrim(0, 0, 0, 0);
            org.eclipse.swt.graphics.Rectangle client = printer.getClientArea();
            printer.getDPI();
            Rectangle r = new Rectangle(client.x, client.y, client.width, client.height);
            return r;
        }

        public void run() {
            GraphicalViewer viewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
            PrintPreviewDialog d = new PrintPreviewDialog(this.getWorkbenchPart().getSite().getShell(), 67680);
            d.setPrintViewer(viewer);
            d.setEditor(StrutsEditor.this);
            Printer printer = new Printer();
            Exception ex = null;
            try {
                printer.getDPI();
                printer.getClientArea();
            }
            catch (Exception ee) {
                ex = ee;
                printer.dispose();
                d = null;
                ModelUIPlugin.getPluginLog().logError((Throwable)ee);
            }
            if (ex == null) {
                d.setPages(new Pages(viewer, new PageFormat(printer, this.getWorkbenchPart().getSite().getShell().getDisplay())));
                String result = d.open();
                if (result != null && result.equals("ok")) {
                    LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
                    IFigure figure = lm.getLayer((Object)"Printable Layers");
                    PrintDialog dialog = new PrintDialog(viewer.getControl().getShell(), 0);
                    PrinterData data = dialog.open();
                    if (data != null) {
                        printer = new Printer(data);
                        d.getPages().getPageFormat();
                        double scale = d.getPages().getScale();
                        double dpiScale = printer.getDPI().x / Display.getCurrent().getDPI().x;
                        this.getPrintRegion(printer);
                        GC printerGC = new GC((Drawable)printer);
                        SWTGraphics g = new SWTGraphics(printerGC);
                        PrinterGraphics graphics = new PrinterGraphics((Graphics)g, printer);
                        if (printer.startJob(this.getWorkbenchPart().getTitle())) {
                            Pages p = d.getPages();
                            int i = 0;
                            while (i < p.getNumberOfPages()) {
                                if (printer.startPage()) {
                                    graphics.pushState();
                                    Page pg = p.getPrintable(i);
                                    org.eclipse.swt.graphics.Rectangle r1 = pg.getRectangle();
                                    org.eclipse.swt.graphics.Rectangle r = new org.eclipse.swt.graphics.Rectangle(r1.x + p.ix, r1.y + p.iy, r1.width, r1.height);
                                    Rectangle clipRect = new Rectangle();
                                    graphics.translate(-((int)((double)r.x * dpiScale * scale)), -((int)((double)r.y * dpiScale * scale)));
                                    graphics.getClip(clipRect);
                                    clipRect.setLocation((int)((double)r.x * dpiScale * scale), (int)((double)r.y * dpiScale * scale));
                                    graphics.clipRect(clipRect);
                                    graphics.scale(dpiScale * scale);
                                    figure.paint((Graphics)graphics);
                                    graphics.popState();
                                    printer.endPage();
                                }
                                ++i;
                            }
                            graphics.dispose();
                            printer.endJob();
                        }
                    }
                }
            }
        }
    }
}

