/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.dnd;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.struts.ui.editor.StrutsEditor;
import org.jboss.tools.struts.ui.editor.dnd.DndHelper;
import org.jboss.tools.struts.ui.editor.edit.StrutsDiagramEditPart;

public class FileTransferDropTargetListener
implements TransferDropTargetListener {
    StrutsEditor editor;
    boolean baseDropAccept = false;

    public FileTransferDropTargetListener(StrutsEditor editor) {
        this.editor = editor;
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragEnter(DropTargetEvent event) {
        String[] os = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType);
        if (os == null || os.length != 1 || !new File(os[0]).isFile()) {
            return;
        }
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(os[0]));
        if (f == null || !f.exists()) {
            return;
        }
        if (!DndHelper.drag(EclipseResourceUtil.getObjectByResource((IResource)f))) {
            return;
        }
        this.baseDropAccept = DndHelper.isDropEnabled(this.editor.getStrutsModel().getSource());
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = !this.baseDropAccept ? 0 : 1;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        org.eclipse.swt.graphics.Point parentPoint = this.editor.getScrollingGraphicalViewer().getControl().toControl(event.x, event.y);
        Point point = new Point(parentPoint.x, parentPoint.y);
        ((StrutsDiagramEditPart)this.editor.getScrollingGraphicalViewer().getRootEditPart().getChildren().get(0)).getFigure().translateToRelative((Translatable)point);
        DndHelper.drop(this.editor.getStrutsModel().getSource(), point);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        return true;
    }
}

