/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.jboss.tools.common.gef.GEFGraphicalViewer;
import org.jboss.tools.common.gef.edit.GEFRootEditPart;
import org.jboss.tools.common.gef.figures.GEFLabel;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.struts.ui.StrutsUIPlugin;
import org.jboss.tools.struts.ui.editor.edit.LinkEditPolicy;
import org.jboss.tools.struts.ui.editor.edit.LinkEndpointEditPolicy;
import org.jboss.tools.struts.ui.editor.edit.ProcessItemEditPart;
import org.jboss.tools.struts.ui.editor.figures.ConnectionFigure;
import org.jboss.tools.struts.ui.editor.figures.FigureFactory;
import org.jboss.tools.struts.ui.editor.figures.xpl.CustomLocator;
import org.jboss.tools.struts.ui.editor.model.ILink;
import org.jboss.tools.struts.ui.editor.model.ILinkListener;

public class LinkEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener,
ILinkListener,
EditPartListener {
    public static final int ARROW_DECOR_INDEX = 0;
    public static final int HEAD_BREAKPOINT_INDEX = 1;
    public static final int TAIL_BREAKPOINT_INDEX = 2;
    public static final int SHORTCUT_INDEX = 3;
    AccessibleEditPart acc;
    private boolean shortcut;
    private CustomLocator shortcutLocator;
    private GEFLabel shortcutLabel;

    public void activate() {
        super.activate();
        this.getLink().addPropertyChangeListener(this);
        this.addEditPartListener(this);
    }

    public void linkRelink(ILink source) {
    }

    public void activateFigure() {
        super.activateFigure();
        this.getFigure().addPropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
    }

    public void doMouseDown(boolean cf) {
    }

    public void doMouseUp(boolean cf) {
        if (cf && this.getLink().isShortcut()) {
            try {
                ((GEFGraphicalViewer)this.getViewer()).getGEFEditor().getModelSelectionProvider().setSelection((ISelection)new StructuredSelection(((ProcessItemEditPart)this.getTarget()).getProcessItemModel().getSource()));
            }
            catch (Exception ex) {
                StrutsUIPlugin.getPluginLog().logError((Throwable)ex);
            }
            return;
        }
    }

    public void doDoubleClick(boolean cf) {
        try {
            XAction action = DnDUtil.getEnabledAction((XModelObject)((XModelObject)this.getLinkModel().getSource()), null, (String)"Properties.Properties");
            if (action != null) {
                action.executeHandler((XModelObject)this.getLinkModel().getSource(), null);
            }
        }
        catch (Exception e) {
            StrutsUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new LinkEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new LinkEditPolicy());
    }

    protected IFigure createFigure() {
        if (this.getLink() == null) {
            return null;
        }
        ConnectionFigure conn = FigureFactory.createNewBendableWire(this, this.getLink());
        PointList list = this.getLink().getPointList();
        if (list.size() > 0) {
            conn.setManual(true);
            conn.setOldPoints(list.getFirstPoint(), list.getLastPoint());
            conn.setPoints(list);
        }
        String text = "";
        if (this.getLinkModel().getStrutsModel().getOptions().showShortcutPath()) {
            text = this.getLinkModel().getToProcessItem().isAction() ? this.getLinkModel().getToProcessItem().getVisiblePath() : this.getLinkModel().getToProcessItem().getName();
        }
        this.shortcutLabel = new GEFLabel(text, FigureFactory.normalColor);
        if (this.getLinkModel().getStrutsModel().getOptions().showShortcutIcon()) {
            this.shortcutLabel.setIcon(this.getLink().getToProcessItem().getImage());
        } else {
            this.shortcutLabel.setIcon(null);
        }
        this.shortcutLabel.setFont(this.getLinkModel().getStrutsModel().getOptions().getPathFont());
        this.shortcutLabel.setTextAlignment(1);
        this.shortcutLabel.setLabelAlignment(1);
        this.shortcutLabel.setIconAlignment(1);
        this.shortcutLocator = new CustomLocator(conn, false);
        this.shortcutLocator.setUDistance(18);
        this.shortcutLocator.setVDistance(-6);
        if (this.getLink().isShortcut()) {
            conn.add((IFigure)this.shortcutLabel, this.shortcutLocator);
        }
        return conn;
    }

    public ILink getLinkModel() {
        return (ILink)this.getModel();
    }

    public void save() {
        PointList list = ((ConnectionFigure)this.getFigure()).getPoints();
        this.getLink().savePointList(list);
    }

    public void clear() {
        this.getLink().clearPointList();
    }

    public void deactivate() {
        this.removeEditPartListener(this);
        this.getLink().removePropertyChangeListener(this);
        super.deactivate();
    }

    public void deactivateFigure() {
        this.getFigure().removePropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
        super.deactivateFigure();
    }

    public AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = "Link";
                }
            };
        }
        return this.acc;
    }

    protected ILink getLink() {
        return (ILink)this.getModel();
    }

    protected ConnectionFigure getLinkFigure() {
        return (ConnectionFigure)this.getFigure();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("value".equals(property)) {
            this.refreshVisuals();
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        ((ILink)model).addLinkListener(this);
        this.shortcut = this.getLink().isShortcut();
    }

    public boolean isLinkListenerEnable() {
        return true;
    }

    public void linkChange(ILink source) {
        if (this.getLinkModel().getStrutsModel().getOptions().showShortcutPath()) {
            if (this.getLinkModel().getToProcessItem().isAction()) {
                this.shortcutLabel.setText(this.getLinkModel().getToProcessItem().getVisiblePath());
            } else {
                this.shortcutLabel.setText(this.getLinkModel().getToProcessItem().getName());
            }
        } else {
            this.shortcutLabel.setText("");
        }
        this.shortcutLabel.setFont(this.getLinkModel().getStrutsModel().getOptions().getPathFont());
        this.shortcutLabel.setSize(this.shortcutLabel.getPreferredSize());
        if (this.shortcut != this.getLink().isShortcut()) {
            this.shortcut = this.getLink().isShortcut();
            if (this.shortcut) {
                this.getLinkFigure().add((IFigure)this.shortcutLabel, this.shortcutLocator);
            } else {
                this.getLinkFigure().remove((IFigure)this.shortcutLabel);
            }
        }
        if (this.getLinkModel().getStrutsModel().getOptions().showShortcutIcon()) {
            this.shortcutLabel.setIcon(this.getLink().getToProcessItem().getImage());
        } else {
            this.shortcutLabel.setIcon(null);
        }
        if (this.getLinkFigure().isManual() && this.getLink().getPathFromModel().equals("")) {
            this.getLinkFigure().setManual(false);
        } else if (!this.getLinkFigure().isManual() && !this.getLink().getPathFromModel().equals("")) {
            this.getLinkFigure().setManual(true);
        }
        this.refresh();
    }

    public void linkRemove(ILink source) {
        this.getLink().removeLinkListener(this);
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        if (this.getSelected() == 2) {
            ((GEFRootEditPart)this.getParent()).setToFront((AbstractConnectionEditPart)this);
        }
    }
}

