/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.jboss.tools.struts.ui.editor.edit.ForwardEditPart;
import org.jboss.tools.struts.ui.editor.edit.ProcessItemEditPolicy;
import org.jboss.tools.struts.ui.editor.edit.StrutsDiagramEditPart;
import org.jboss.tools.struts.ui.editor.edit.StrutsEditPart;
import org.jboss.tools.struts.ui.editor.edit.StrutsFlowEditPolicy;
import org.jboss.tools.struts.ui.editor.figures.ProcessItemFigure;
import org.jboss.tools.struts.ui.editor.model.IForward;
import org.jboss.tools.struts.ui.editor.model.ILink;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;
import org.jboss.tools.struts.ui.editor.model.IProcessItemListener;
import org.jboss.tools.struts.ui.editor.model.IStrutsElement;
import org.jboss.tools.struts.ui.editor.model.IStrutsElementList;
import org.jboss.tools.struts.ui.editor.model.IStrutsElementListListener;

public abstract class ProcessItemEditPart
extends StrutsEditPart
implements PropertyChangeListener,
IProcessItemListener,
IStrutsElementListListener,
EditPartListener {
    protected ProcessItemFigure fig = null;
    protected Dimension prefferedSize = new Dimension(150, 21);

    public boolean isElementListListenerEnable() {
        return true;
    }

    public void listElementAdd(IStrutsElementList list, IStrutsElement element, int index) {
        this.layoutForwards();
        this.refresh();
        List editParts = this.getSourceConnections();
        int i = 0;
        while (i < editParts.size()) {
            ((ConnectionEditPart)editParts.get(i)).refresh();
            ++i;
        }
        if (this.fig != null) {
            this.fig.refreshFont();
            this.fig.repaint();
        }
    }

    public void listElementChange(IStrutsElementList list, IStrutsElement element, int index, PropertyChangeEvent event) {
        this.layoutForwards();
        this.refresh();
        List editParts = this.getSourceConnections();
        int i = 0;
        while (i < editParts.size()) {
            ((ConnectionEditPart)editParts.get(i)).refresh();
            ++i;
        }
        if (this.fig != null) {
            this.fig.refreshFont();
            this.fig.repaint();
        }
    }

    public void listElementMove(IStrutsElementList list, IStrutsElement element, int newIndex, int oldIndex) {
        this.layoutForwards();
        this.refresh();
        List editParts = this.getSourceConnections();
        int i = 0;
        while (i < editParts.size()) {
            ((ConnectionEditPart)editParts.get(i)).refresh();
            ++i;
        }
    }

    public void linkAdd(ILink link) {
        this.layoutForwards();
        this.refreshTargetLink(link);
        this.refresh();
        List editParts = this.getSourceConnections();
        int i = 0;
        while (i < editParts.size()) {
            ((ConnectionEditPart)editParts.get(i)).refresh();
            ++i;
        }
        if (this.fig != null) {
            this.fig.refreshFont();
            this.fig.repaint();
        }
    }

    public void linkRemove(ILink link) {
        this.layoutForwards();
        this.refresh();
        List editParts = this.getSourceConnections();
        int i = 0;
        while (i < editParts.size()) {
            ((ConnectionEditPart)editParts.get(i)).refresh();
            ++i;
        }
        if (this.fig != null) {
            this.fig.refreshFont();
            this.fig.repaint();
        }
    }

    public void listElementRemove(IStrutsElementList list, IStrutsElement element, int index) {
        this.layoutForwards();
        this.refresh();
        List editParts = this.getSourceConnections();
        int i = 0;
        while (i < editParts.size()) {
            ((ConnectionEditPart)editParts.get(i)).refresh();
            ++i;
        }
    }

    public void setElementListListenerEnable(boolean set) {
    }

    protected Dimension calculatePreffSize() {
        return this.prefferedSize;
    }

    public void doDoubleClick(boolean cf) {
    }

    public void doMouseDown(boolean cf) {
    }

    public void doMouseUp(boolean cf) {
    }

    public void setModel(Object model) {
        super.setModel(model);
        ((IProcessItem)model).addPropertyChangeListener(this);
        ((IProcessItem)model).addProcessItemListener(this);
        this.addEditPartListener(this);
        if (this.getProcessItemModel().getForwardList() != null) {
            this.getProcessItemModel().getForwardList().addStrutsElementListListener(this);
        }
        this.layoutForwards();
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        if (this.getSelected() == 2) {
            ((StrutsDiagramEditPart)this.getParent()).setToFront((EditPart)this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name")) {
            this.fig.setPath(this.getProcessItemModel().getVisiblePath());
        } else if (evt.getPropertyName().equals("path")) {
            this.fig.setPath(this.getProcessItemModel().getVisiblePath());
        } else if (!evt.getPropertyName().equals("selected") && evt.getPropertyName().equals("shape")) {
            this.refreshVisuals();
        }
    }

    public boolean isProcessItemListenerEnable() {
        return true;
    }

    public void processItemChange() {
        this.layoutForwards();
        this.refresh();
        if (this.fig != null) {
            this.fig.refreshFont();
            this.fig.repaint();
        }
    }

    public void processItemForwardAdd(IProcessItem processItem, IForward forward) {
        if (this.fig != null) {
            this.fig.addConnectionAnchor(this.getProcessItemModel().getListOutputLinks().size());
        }
        this.layoutForwards();
        this.refreshTargetLink(forward.getLink());
        this.refresh();
    }

    public void processItemForwardChange(IProcessItem processItem, IForward forward, PropertyChangeEvent evt) {
        this.layoutForwards();
        this.refresh();
    }

    public void processItemForwardRemove(IProcessItem processItem, IForward forward) {
        this.layoutForwards();
        this.refreshTargetLink(forward.getLink());
        this.refresh();
        if (this.fig != null) {
            this.fig.removeConnectionAnchor();
        }
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = "EditPart";
            }

            public void getValue(AccessibleControlEvent e) {
            }
        };
    }

    protected List getModelTargetConnections() {
        return this.getProcessItemModel().getListInputLinks();
    }

    protected List getModelSourceConnections() {
        if (this.getProcessItemModel().isGlobal() || this.getProcessItemModel().isPage()) {
            return this.getProcessItemModel().getListOutputLinks();
        }
        return Collections.EMPTY_LIST;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ProcessItemEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new StrutsFlowEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ProcessItemEditPolicy());
    }

    protected abstract IFigure createFigure();

    public ProcessItemFigure getProcessItemFigure() {
        return (ProcessItemFigure)this.getFigure();
    }

    public IProcessItem getProcessItemModel() {
        return (IProcessItem)this.getModel();
    }

    protected void layoutForwards() {
    }

    protected void refreshVisuals() {
        if (this.getParent() == null) {
            return;
        }
        Point loc = this.getProcessItemModel().getPosition();
        loc.x -= loc.x % 8;
        loc.y -= loc.y % 8;
        Dimension size = this.getProcessItemModel().getSize();
        if (size.width == 0) {
            size = this.calculatePreffSize();
        } else {
            size.height = this.calculatePreffSize().height;
        }
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        ConnectionAnchor anc = this.getNodeFigure().getConnectionAnchor("1_IN");
        return anc;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getNodeFigure().getTargetConnectionAnchorAt(pt);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        if (this.getProcessItemModel().isGlobal() || this.getProcessItemModel().isPage()) {
            ILink link = (ILink)connEditPart.getModel();
            int index = this.getProcessItemModel().getListOutputLinks().indexOf(link);
            return this.getNodeFigure().getConnectionAnchor(String.valueOf(index + 1) + "_OUT");
        }
        return super.getSourceConnectionAnchor(connEditPart);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (this.getProcessItemModel().isGlobal() || this.getProcessItemModel().isPage() || this.getProcessItemModel().isAction()) {
            Point pt = new Point(((DropRequest)request).getLocation());
            return this.getNodeFigure().getSourceConnectionAnchorAt(pt);
        }
        return super.getSourceConnectionAnchor(request);
    }

    protected List getModelChildren() {
        if (this.getProcessItemModel().isGlobal() || this.getProcessItemModel().isPage()) {
            return Collections.EMPTY_LIST;
        }
        return this.getProcessItemModel().getForwardList().getElements();
    }

    protected void refreshChildren() {
        super.refreshChildren();
        int i = 0;
        while (i < this.getChildren().size()) {
            ((ForwardEditPart)this.getChildren().get(i)).refresh();
            ++i;
        }
    }
}

