/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.edit;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.jboss.tools.struts.ui.editor.edit.LinkEditPart;
import org.jboss.tools.struts.ui.editor.figures.ConnectionFigure;

public class StrutsConnectionDragTracker
extends ConnectionEndpointTracker {
    private boolean vertical;
    private PointList list;
    private int index1;
    private int index2;
    private Point point1;
    private Point point2;
    private boolean first = true;

    public StrutsConnectionDragTracker(ConnectionEditPart cep, boolean vertical, int id) {
        super(cep);
        this.vertical = vertical;
        this.list = this.getConnection().getPoints();
        this.index1 = id;
        this.index2 = id + 1;
        this.point1 = this.list.getPoint(this.index1);
        this.point2 = this.list.getPoint(this.index2);
    }

    public void commitDrag() {
    }

    protected boolean handleDragInProgress() {
        Point p2;
        Point p1;
        if (this.first) {
            this.list = this.getConnection().getPoints();
            this.point1 = this.list.getPoint(this.index1);
            this.point2 = this.list.getPoint(this.index2);
            this.first = false;
        }
        Dimension delta = this.getDragMoveDelta();
        if (this.vertical) {
            p1 = new Point(this.point1.x, this.point1.y + delta.height);
            p1.y -= p1.y % 8;
            p2 = new Point(this.point2.x, this.point2.y + delta.height);
            p2.y -= p2.y % 8;
        } else {
            p1 = new Point(this.point1.x + delta.width, this.point1.y);
            p1.x -= p1.x % 8;
            p2 = new Point(this.point2.x + delta.width, this.point2.y);
            p2.x -= p2.x % 8;
            if (this.index1 == 1 && p1.x < this.list.getPoint((int)0).x) {
                p1.x = this.list.getPoint((int)0).x;
                p2.x = this.list.getPoint((int)0).x;
            }
            if (this.index2 == this.list.size() - 2 && p1.x > this.list.getPoint((int)(this.list.size() - 1)).x) {
                p1.x = this.list.getPoint((int)(this.list.size() - 1)).x;
                p2.x = this.list.getPoint((int)(this.list.size() - 1)).x;
            }
        }
        this.list.removePoint(this.index1);
        this.list.removePoint(this.index1);
        this.list.insertPoint(p1, this.index1);
        this.list.insertPoint(p2, this.index2);
        this.getConnection().setPoints(this.list);
        ((ConnectionFigure)this.getConnection()).setManual(true);
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.first = true;
            ((LinkEditPart)this.getConnectionEditPart()).save();
        }
        return true;
    }

    protected Point getLocation() {
        Point p = new Point(this.getCurrentInput().getMouseLocation());
        if (this.getFlag(1)) {
            p.x -= p.x % 8;
            p.y -= p.y % 8;
        }
        return p;
    }

    protected Point getStartLocation() {
        Point p = super.getStartLocation().getCopy();
        if (this.getFlag(1)) {
            p.x -= p.x % 8;
            p.y -= p.y % 8;
        }
        return p;
    }
}

