/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.edit;

import java.util.Vector;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Translatable;
import org.jboss.tools.struts.ui.editor.edit.xpl.DefaultRouter;
import org.jboss.tools.struts.ui.editor.figures.ConnectionFigure;
import org.jboss.tools.struts.ui.editor.figures.ForwardFigure;
import org.jboss.tools.struts.ui.editor.figures.ProcessItemFigure;
import org.jboss.tools.struts.ui.editor.model.ILink;

public final class StrutsConnectionRouter
extends DefaultRouter {
    protected Object getNearLink(Connection conn, int index, int size) {
        IFigure fig = conn.getSourceAnchor().getOwner();
        ProcessItemFigure processItem = null;
        if (fig instanceof ProcessItemFigure) {
            processItem = (ProcessItemFigure)fig;
        } else if (fig instanceof ForwardFigure) {
            processItem = (ProcessItemFigure)fig.getParent();
        }
        ILink link = ((ConnectionFigure)conn).getLinkModel();
        if (processItem != null) {
            index = processItem.processItem.getListOutputLinks().indexOf(link);
            size = processItem.processItem.getListOutputLinks().size();
            return link;
        }
        return null;
    }

    protected boolean preRoute(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return true;
        }
        if (((ConnectionFigure)conn).getLinkModel() != null && ((ConnectionFigure)conn).getLinkModel().isShortcut()) {
            Point startPoint = this.getStartPoint(conn);
            conn.translateToRelative((Translatable)startPoint);
            Vector<Integer> positions = new Vector<Integer>(5);
            Ray start = new Ray(startPoint);
            positions.add(start.y);
            Point endPoint = new Point(startPoint.x + 18, startPoint.y);
            Ray end = new Ray(endPoint);
            this.processPositions(start, end, positions, true, conn);
            return true;
        }
        if (((ConnectionFigure)conn).isManual()) {
            if (conn.getPoints().size() < 4) {
                PointList list = ((ConnectionFigure)conn).getLinkModel().getPointList();
                ((ConnectionFigure)conn).setOldPoints(list.getFirstPoint(), list.getLastPoint());
                conn.setPoints(list);
            }
            if (this.hold((ConnectionFigure)conn)) {
                return true;
            }
            ((ConnectionFigure)conn).setManual(false);
            ((ConnectionFigure)conn).clear();
        }
        return false;
    }

    protected void postRoute(Connection conn, Ray start, Ray end, Point startPoint, Point endPoint, Vector positions) {
        this.processPositions(start, end, positions, true, conn);
        ((ConnectionFigure)conn).setOldPoints(startPoint, endPoint);
    }

    protected int check(ConnectionFigure conn) {
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPoint);
        Point oldStartPoint = conn.getOldStartPoint();
        Point oldEndPoint = conn.getOldEndPoint();
        if (startPoint.x == oldStartPoint.x && startPoint.y == oldStartPoint.y && endPoint.x == oldEndPoint.x && endPoint.y == oldEndPoint.y) {
            return 0;
        }
        if (startPoint.x - oldStartPoint.x == endPoint.x - oldEndPoint.x && startPoint.y - oldStartPoint.y == endPoint.y - oldEndPoint.y) {
            return 3;
        }
        return 2;
    }

    protected boolean hold(ConnectionFigure conn) {
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPoint);
        int status = this.check(conn);
        if (status == 0) {
            return true;
        }
        if (status == 3) {
            this.shift(conn);
            conn.setOldPoints(startPoint, endPoint);
            conn.save();
            return true;
        }
        PointList list = conn.getPoints();
        list.removePoint(0);
        list.insertPoint(startPoint, 0);
        list.removePoint(list.size() - 1);
        list.addPoint(endPoint);
        if (list.size() > 2) {
            Point p1 = list.getPoint(1);
            p1.y = startPoint.y;
            if (p1.x <= startPoint.x) {
                return false;
            }
            Point p2 = list.getPoint(list.size() - 2);
            p2.y = endPoint.y;
            if (p2.x >= endPoint.x) {
                return false;
            }
            list.removePoint(1);
            list.insertPoint(p1, 1);
            int index = list.size() - 2;
            list.removePoint(index);
            list.insertPoint(p2, index);
        }
        conn.setPoints(list);
        conn.setOldPoints(startPoint, endPoint);
        conn.save();
        return true;
    }

    private void shift(ConnectionFigure conn) {
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point oldStartPoint = conn.getOldStartPoint();
        Point shiftPoint = new Point(startPoint.x - oldStartPoint.x, startPoint.y - oldStartPoint.y);
        PointList list = conn.getPoints();
        if (list.getPoint((int)0).x == startPoint.x && list.getPoint((int)0).y == startPoint.y) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            Point point = list.getPoint(i);
            point.x += shiftPoint.x;
            point.y += shiftPoint.y;
            list.removePoint(i);
            list.insertPoint(point, i);
            ++i;
        }
        conn.setPoints(list);
    }
}

