/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.edit;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gef.tools.MarqueeDragTracker;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.jboss.tools.struts.ui.editor.edit.StrutsContainerEditPart;
import org.jboss.tools.struts.ui.editor.edit.StrutsDiagramEditPolicy;
import org.jboss.tools.struts.ui.editor.figures.DiagramFigure;
import org.jboss.tools.struts.ui.editor.model.ILink;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;
import org.jboss.tools.struts.ui.editor.model.IStrutsModel;
import org.jboss.tools.struts.ui.editor.model.IStrutsModelListener;

public class StrutsDiagramEditPart
extends StrutsContainerEditPart
implements LayerConstants,
IStrutsModelListener {
    private boolean gridVisual = false;
    private int gridVisualStep = 8;
    private DiagramFigure fig;

    public boolean isGridVisible() {
        return this.gridVisual;
    }

    public int getVisualGridStep() {
        return this.gridVisualStep;
    }

    public void doDoubleClick(boolean cf) {
    }

    public void doMouseDown(boolean cf) {
    }

    public void doMouseUp(boolean cf) {
    }

    public void setModel(Object model) {
        super.setModel(model);
        ((IStrutsModel)model).addStrutsModelListener(this);
        this.gridVisual = this.getStrutsModel().getOptions().isGridVisible();
        this.gridVisualStep = this.getStrutsModel().getOptions().getGridStep();
    }

    public IStrutsModel getStrutsModel() {
        return (IStrutsModel)this.getModel();
    }

    public boolean isStrutsModelListenerEnabled() {
        return true;
    }

    public void processChanged(boolean flag) {
        if (this.gridVisual != this.getStrutsModel().getOptions().isGridVisible() || this.gridVisualStep != this.getStrutsModel().getOptions().getGridStep()) {
            this.gridVisual = this.getStrutsModel().getOptions().isGridVisible();
            this.gridVisualStep = this.getStrutsModel().getOptions().getGridStep();
            this.fig.repaint();
        }
    }

    public void setToFront(EditPart ep) {
        int index = this.getChildren().indexOf(ep);
        if (index == -1) {
            return;
        }
        if (index != this.getChildren().size() - 1) {
            this.reorderChild(ep, this.getChildren().size() - 1);
        }
    }

    public void processItemAdd(IProcessItem processItem) {
        this.refresh();
    }

    public void processItemRemove(IProcessItem group) {
        this.refresh();
    }

    public void linkAdd(ILink link) {
    }

    public void linkRemove(ILink link) {
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = "JSF Diagram";
            }
        };
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("GraphicalNodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new StrutsDiagramEditPolicy());
    }

    protected IFigure createFigure() {
        this.fig = new DiagramFigure(this);
        return this.fig;
    }

    public FreeformViewport getFreeformViewport() {
        return (FreeformViewport)this.getAncestor(this.fig, FreeformViewport.class);
    }

    public IFigure getAncestor(IFigure figure, Class cls) {
        DiagramFigure parent = this.fig;
        while (parent != null) {
            if (((Object)((Object)parent)).getClass().equals(cls)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public DragTracker getDragTracker(Request req) {
        if (req instanceof SelectionRequest && ((SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this);
        }
        return new MarqueeDragTracker();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart editPart) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(int x, int y) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart editPart) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(int x, int y) {
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected List getModelChildren() {
        return this.getStrutsModel().getProcessItemList().getElements();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return (SnapToHelper)snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }
}

