/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.jboss.tools.struts.ui.editor.edit.ProcessItemEditPart;
import org.jboss.tools.struts.ui.editor.edit.StrutsElementEditPolicy;
import org.jboss.tools.struts.ui.editor.edit.StrutsNodeEditPolicy;
import org.jboss.tools.struts.ui.editor.figures.NodeFigure;
import org.jboss.tools.struts.ui.editor.model.ILink;

public abstract class StrutsEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
PropertyChangeListener {
    private AccessibleEditPart acc;

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
    }

    public abstract void doDoubleClick(boolean var1);

    public abstract void doMouseDown(boolean var1);

    public abstract void doMouseUp(boolean var1);

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new StrutsElementEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new StrutsNodeEditPolicy());
    }

    protected abstract AccessibleEditPart createAccessible();

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = this.createAccessible();
        }
        return this.acc;
    }

    protected NodeFigure getNodeFigure() {
        return (NodeFigure)this.getFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    protected final String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return this.getNodeFigure().getConnectionAnchorName(c);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void refreshVisuals() {
        Point loc = new Point(100, 100);
        Dimension size = new Dimension(56, 100);
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }

    protected void refreshSourceConnections() {
        ConnectionEditPart part;
        HashMap<Object, ConnectionEditPart> fromModelToPart = new HashMap<Object, ConnectionEditPart>();
        List parts = this.getSourceConnections();
        int i = 0;
        while (i < parts.size()) {
            part = (ConnectionEditPart)parts.get(i);
            fromModelToPart.put(part.getModel(), part);
            ++i;
        }
        ArrayList modelEnties = this.getModelSourceConnections();
        if (modelEnties == null) {
            modelEnties = new ArrayList();
        }
        i = 0;
        while (i < modelEnties.size()) {
            Object model = modelEnties.get(i);
            if (i < parts.size() && (part = (ConnectionEditPart)parts.get(i)).getModel() == model) {
                if (part.getSource() != this) {
                    part.setSource((EditPart)this);
                }
            } else {
                part = (ConnectionEditPart)fromModelToPart.get(model);
                if (part != null) {
                    this.reorderSourceConnection(part, i);
                } else {
                    part = this.createOrFindConnection(model);
                    if (part != null) {
                        this.addSourceConnection(part, i);
                    }
                }
            }
            ++i;
        }
        ArrayList removed = new ArrayList();
        while (i < parts.size()) {
            removed.add(parts.get(i));
            ++i;
        }
        i = 0;
        while (i < removed.size()) {
            this.removeSourceConnection((ConnectionEditPart)removed.get(i));
            ++i;
        }
    }

    protected void refreshTargetConnections() {
        ConnectionEditPart conn;
        HashMap<Object, ConnectionEditPart> fromModelToPart = new HashMap<Object, ConnectionEditPart>();
        List connList = this.getTargetConnections();
        int i = 0;
        while (i < connList.size()) {
            conn = (ConnectionEditPart)connList.get(i);
            fromModelToPart.put(conn.getModel(), conn);
            ++i;
        }
        ArrayList modelEntries = this.getModelTargetConnections();
        if (modelEntries == null) {
            modelEntries = new ArrayList();
        }
        i = 0;
        while (i < modelEntries.size()) {
            Object model = modelEntries.get(i);
            if (i < connList.size() && (conn = (ConnectionEditPart)connList.get(i)).getModel() == model) {
                if (conn.getTarget() != this) {
                    conn.setTarget((EditPart)this);
                }
            } else {
                conn = (ConnectionEditPart)fromModelToPart.get(model);
                if (conn != null) {
                    this.reorderTargetConnection(conn, i);
                } else {
                    conn = this.createOrFindConnection(model);
                    this.addTargetConnection(conn, i);
                }
            }
            ++i;
        }
        ArrayList removed = new ArrayList();
        while (i < connList.size()) {
            removed.add(connList.get(i));
            ++i;
        }
        i = 0;
        while (i < removed.size()) {
            this.removeTargetConnection((ConnectionEditPart)removed.get(i));
            ++i;
        }
    }

    protected void removeSourceConnection(ConnectionEditPart connection) {
        if (connection.getSource() != this) {
            return;
        }
        this.fireRemovingSourceConnection(connection, this.getSourceConnections().indexOf(connection));
        connection.deactivate();
        connection.setSource(null);
        this.primRemoveSourceConnection(connection);
    }

    protected void removeTargetConnection(ConnectionEditPart connection) {
        if (connection.getTarget() != this) {
            return;
        }
        this.fireRemovingTargetConnection(connection, this.getTargetConnections().indexOf(connection));
        connection.setTarget(null);
        this.primRemoveTargetConnection(connection);
    }

    protected void refreshTargetLink(ILink link) {
        ProcessItemEditPart gep;
        if (link == null) {
            return;
        }
        if (link.getToProcessItem() == null) {
            link.setTarget();
            if (link.getToProcessItem() == null) {
                return;
            }
        }
        if ((gep = (ProcessItemEditPart)this.getViewer().getEditPartRegistry().get(link.getToProcessItem())) == null) {
            return;
        }
        gep.refreshTargetConnections();
    }
}

