/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.edit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.jboss.tools.struts.ui.editor.figures.ActionFeedbackFigure;
import org.jboss.tools.struts.ui.editor.figures.CommentFeedbackFigure;
import org.jboss.tools.struts.ui.editor.figures.GlobalExceptionFeedbackFigure;
import org.jboss.tools.struts.ui.editor.figures.GlobalForwardFeedbackFigure;
import org.jboss.tools.struts.ui.editor.figures.NodeFigure;
import org.jboss.tools.struts.ui.editor.figures.PageFeedbackFigure;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;

public class StrutsResizableEditPolicy
extends ResizableEditPolicy {
    protected IFigure createDragSourceFeedbackFigure() {
        IFigure figure = this.createFigure((GraphicalEditPart)this.getHost(), null);
        figure.setBounds(this.getInitialFeedbackBounds());
        this.addFeedback(figure);
        return figure;
    }

    protected IFigure createFigure(GraphicalEditPart part, IFigure parent) {
        IFigure ch = this.getCustomFeedbackFigure(part.getModel());
        if (parent != null) {
            parent.add(ch);
        }
        Rectangle bounds = part.getFigure().getBounds().getCopy();
        IFigure i1 = part.getFigure().getParent();
        while (i1 != ((GraphicalEditPart)part.getParent()).getFigure()) {
            i1.translateToParent((Translatable)bounds);
            i1 = i1.getParent();
        }
        ch.setBounds(bounds);
        Iterator i2 = part.getChildren().iterator();
        while (i2.hasNext()) {
            this.createFigure((GraphicalEditPart)i2.next(), ch);
        }
        return ch;
    }

    protected IFigure getCustomFeedbackFigure(Object modelPart) {
        Object figure = null;
        if (modelPart instanceof IProcessItem) {
            if (((IProcessItem)modelPart).getType().equals("action")) {
                figure = new ActionFeedbackFigure();
            } else if (((IProcessItem)modelPart).getType().equals("page")) {
                figure = new PageFeedbackFigure();
            } else if (((IProcessItem)modelPart).getType().equals("forward")) {
                figure = new GlobalForwardFeedbackFigure();
            } else if (((IProcessItem)modelPart).getType().equals("exception")) {
                figure = new GlobalExceptionFeedbackFigure();
            } else if (((IProcessItem)modelPart).getType().equals("comment")) {
                figure = new CommentFeedbackFigure();
            }
        } else {
            figure = new RectangleFigure();
            figure.setXOR(true);
            figure.setFill(true);
            figure.setBackgroundColor(NodeFigure.ghostFillColor);
            figure.setForegroundColor(NodeFigure.whiteColor);
        }
        return figure;
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }

    protected Rectangle getInitialFeedbackBounds() {
        return this.getHostFigure().getBounds();
    }

    Handle createHandle(GraphicalEditPart owner, int direction) {
        ResizeHandle handle = new ResizeHandle(owner, direction);
        handle.setCursor(SharedCursors.SIZEALL);
        handle.setDragTracker((DragTracker)new DragEditPartsTracker((EditPart)owner));
        return handle;
    }

    Handle createResizeHandle(GraphicalEditPart owner, int direction) {
        ResizeHandle handle = new ResizeHandle(owner, direction);
        return handle;
    }

    protected List createSelectionHandles() {
        ArrayList<Handle> list = new ArrayList<Handle>();
        list.add(this.createHandle((GraphicalEditPart)this.getHost(), 20));
        list.add(this.createHandle((GraphicalEditPart)this.getHost(), 12));
        list.add(this.createHandle((GraphicalEditPart)this.getHost(), 9));
        list.add(this.createHandle((GraphicalEditPart)this.getHost(), 17));
        list.add(this.createResizeHandle((GraphicalEditPart)this.getHost(), 16));
        list.add(this.createResizeHandle((GraphicalEditPart)this.getHost(), 8));
        return list;
    }
}

