/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.edit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.jboss.tools.struts.ui.editor.edit.ActionEditPart;
import org.jboss.tools.struts.ui.editor.edit.CommentEditPart;
import org.jboss.tools.struts.ui.editor.edit.GlobalForwardEditPart;
import org.jboss.tools.struts.ui.editor.edit.PageEditPart;
import org.jboss.tools.struts.ui.editor.edit.ProcessItemEditPart;
import org.jboss.tools.struts.ui.editor.edit.StrutsResizableEditPolicy;
import org.jboss.tools.struts.ui.editor.figures.ActionFeedbackFigure;
import org.jboss.tools.struts.ui.editor.figures.CommentFeedbackFigure;
import org.jboss.tools.struts.ui.editor.figures.GlobalExceptionFeedbackFigure;
import org.jboss.tools.struts.ui.editor.figures.GlobalForwardFeedbackFigure;
import org.jboss.tools.struts.ui.editor.figures.NodeFigure;
import org.jboss.tools.struts.ui.editor.figures.PageFeedbackFigure;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;
import org.jboss.tools.struts.ui.editor.model.IStrutsElement;
import org.jboss.tools.struts.ui.editor.model.commands.SetConstraintCommand;

public class StrutsXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command createAddCommand(EditPart childEditPart, Object constraint) {
        IStrutsElement part = (IStrutsElement)childEditPart.getModel();
        Rectangle rect = (Rectangle)constraint;
        SetConstraintCommand setConstraint = new SetConstraintCommand();
        setConstraint.setLocation(rect);
        setConstraint.setPart(part);
        setConstraint.setLabel("Reparenting JSFSubpart");
        setConstraint.setDebugLabel("LogicXYEP setConstraint");
        return setConstraint;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        SetConstraintCommand locationCommand = new SetConstraintCommand();
        locationCommand.setShell(child.getViewer().getControl().getShell());
        locationCommand.setPart((IStrutsElement)child.getModel());
        locationCommand.setLocation((Rectangle)constraint);
        return locationCommand;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof PageEditPart) {
            CustomPolicy policy = new CustomPolicy();
            return policy;
        }
        if (child instanceof GlobalForwardEditPart || child instanceof ActionEditPart || child instanceof CommentEditPart) {
            StrutsResizableEditPolicy policy = new StrutsResizableEditPolicy();
            policy.setResizeDirections(24);
            return policy;
        }
        return new StrutsResizableEditPolicy();
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        return null;
    }

    class CustomPolicy
    extends NonResizableEditPolicy {
        CustomPolicy() {
        }

        protected IFigure createDragSourceFeedbackFigure() {
            ProcessItemEditPart part = (ProcessItemEditPart)this.getHost();
            IFigure child = this.getCustomFeedbackFigure(part.getModel());
            this.addFeedback(child);
            Rectangle childBounds = part.getFigure().getBounds().getCopy();
            IFigure walker = part.getFigure().getParent();
            while (walker != ((GraphicalEditPart)part.getParent()).getFigure()) {
                walker.translateToParent((Translatable)childBounds);
                walker = walker.getParent();
            }
            child.setBounds(childBounds);
            return child;
        }

        protected IFigure getFeedbackLayer() {
            return this.getLayer("Scaled Feedback Layer");
        }

        protected IFigure getCustomFeedbackFigure(Object modelPart) {
            Object figure = null;
            if (modelPart instanceof IProcessItem) {
                if (((IProcessItem)modelPart).getType().equals("action")) {
                    figure = new ActionFeedbackFigure();
                } else if (((IProcessItem)modelPart).getType().equals("page")) {
                    figure = new PageFeedbackFigure();
                } else if (((IProcessItem)modelPart).getType().equals("forward")) {
                    figure = new GlobalForwardFeedbackFigure();
                } else if (((IProcessItem)modelPart).getType().equals("exception")) {
                    figure = new GlobalExceptionFeedbackFigure();
                } else if (((IProcessItem)modelPart).getType().equals("comment")) {
                    figure = new CommentFeedbackFigure();
                }
            } else {
                figure = new RectangleFigure();
                figure.setXOR(true);
                figure.setFill(true);
                figure.setBackgroundColor(NodeFigure.ghostFillColor);
                figure.setForegroundColor(NodeFigure.whiteColor);
            }
            return figure;
        }

        protected List createSelectionHandles() {
            ArrayList<Handle> list = new ArrayList<Handle>();
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 20));
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 12));
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 9));
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 17));
            return list;
        }

        Handle createHandle(GraphicalEditPart owner, int direction) {
            ResizeHandle handle = new ResizeHandle(owner, direction);
            handle.setCursor(SharedCursors.SIZEALL);
            handle.setDragTracker((DragTracker)new DragEditPartsTracker((EditPart)owner));
            return handle;
        }
    }
}

