/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.edit.xpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class DefaultRouter
extends AbstractRouter {
    protected static final int STEP = 8;
    protected static final int INTEGER = 10;
    private static Ray UP = new Ray(0, -1);
    private static Ray DOWN = new Ray(0, 1);
    private static Ray LEFT = new Ray(-1, 0);
    private static Ray RIGHT = new Ray(1, 0);
    private Map rowsUsed = new HashMap();
    private Map colsUsed = new HashMap();
    protected static final int STATUS_NOTHING = 0;
    protected static final int STATUS_HOLD = 2;
    protected static final int STATUS_SHIFT = 3;
    private Map reservedInfo = new HashMap();

    public void invalidate(Connection connection) {
        this.removeReservedLines(connection);
    }

    private int getColumnNear(Connection conn, int r, int n, int x, boolean flag) {
        int index = 0;
        int size = 0;
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        if (flag) {
            if (conn.getSourceAnchor().getOwner() != null) {
                if (this.getNearLink(conn, index, size) == null) {
                    flag = false;
                }
            } else {
                flag = false;
            }
        }
        if (flag) {
            int value = min + 100 + (size - index) * 8 - size / 2 * 8;
            if (value <= min) {
                return min + 8;
            }
            if (value >= max) {
                return max - 8;
            }
            return value;
        }
        int proximity = 0;
        int direction = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proximity < r) {
            Integer i = r + proximity * direction;
            if (!this.colsUsed.containsKey(i)) {
                this.colsUsed.put(i, i);
                this.reserveColumn(conn, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 8;
            }
            if (j >= max) {
                return j - 8;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 8;
        }
        return r;
    }

    protected Object getNearLink(Connection conn, int index, int size) {
        return null;
    }

    public void route(Connection conn) {
        if (this.preRoute(conn)) {
            return;
        }
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPoint);
        Ray start = new Ray(startPoint);
        Ray end = new Ray(endPoint);
        Ray average = start.getAveraged(end);
        Ray direction = new Ray(start, end);
        Ray startNormal = this.getStartDirection(conn);
        Ray endNormal = this.getEndDirection(conn);
        Vector<Integer> positions = new Vector<Integer>(5);
        boolean horizontal = true;
        positions.add(start.y);
        boolean bl = horizontal = !horizontal;
        if (start.x > end.x + 20 && Math.abs(end.y - start.y) < 100) {
            int i = startNormal.similarity(start.getAdded(startNormal.getScaled(10)));
            positions.add(i);
            boolean bl2 = horizontal = !horizontal;
            if (conn.getSourceAnchor().getOwner() == null) {
                i = average.y;
            } else {
                Rectangle rec = conn.getSourceAnchor().getOwner().getBounds();
                i = rec.y + rec.height + 8;
            }
            i -= i % 8;
            positions.add(i);
            horizontal = !horizontal;
            i = endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
            i -= i % 8;
            positions.add(i);
            horizontal = !horizontal;
        } else {
            int i;
            if (startNormal.dotProduct(direction) < 16) {
                i = startNormal.similarity(start.getAdded(startNormal.getScaled(10)));
                i -= i % 8;
                positions.add(i);
                horizontal = !horizontal;
            }
            i = horizontal ? average.y : average.x;
            i -= i % 8;
            positions.add(i);
            boolean bl3 = horizontal = !horizontal;
            if (startNormal.dotProduct(direction) < 16) {
                i = endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
                i -= i % 8;
                positions.add(i);
                horizontal = !horizontal;
            }
        }
        positions.add(end.y);
        this.postRoute(conn, start, end, startPoint, endPoint, positions);
    }

    protected void postRoute(Connection conn, Ray start, Ray end, Point startPoint, Point endPoint, Vector positions) {
    }

    protected boolean preRoute(Connection conn) {
        return false;
    }

    public void calcPositions(Connection conn, Vector positions) {
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPoint);
        Ray start = new Ray(startPoint);
        Ray end = new Ray(endPoint);
        Ray average = start.getAveraged(end);
        Ray direction = new Ray(start, end);
        Ray startNormal = this.getStartDirection(conn);
        Ray endNormal = this.getEndDirection(conn);
        boolean horizontal = true;
        positions.add(start.y);
        boolean bl = horizontal = !horizontal;
        if (start.x > end.x + 20 && Math.abs(end.y - start.y) < 100) {
            int i = startNormal.similarity(start.getAdded(startNormal.getScaled(10)));
            positions.add(i);
            boolean bl2 = horizontal = !horizontal;
            if (conn.getSourceAnchor().getOwner() == null) {
                i = average.y;
            } else {
                Rectangle rec = conn.getSourceAnchor().getOwner().getBounds();
                i = rec.y + rec.height + 8;
            }
            i -= i % 8;
            positions.add(i);
            horizontal = !horizontal;
            i = endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
            i -= i % 8;
            positions.add(i);
            horizontal = !horizontal;
        } else {
            int i;
            if (startNormal.dotProduct(direction) < 16) {
                i = startNormal.similarity(start.getAdded(startNormal.getScaled(10)));
                i -= i % 8;
                positions.add(i);
                horizontal = !horizontal;
            }
            i = horizontal ? average.y : average.x;
            i -= i % 8;
            positions.add(i);
            boolean bl3 = horizontal = !horizontal;
            if (startNormal.dotProduct(direction) < 16) {
                i = endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
                i -= i % 8;
                positions.add(i);
                horizontal = !horizontal;
            }
        }
        positions.add(end.y);
    }

    protected Ray getStartDirection(Connection conn) {
        return RIGHT;
    }

    protected Ray getEndDirection(Connection conn) {
        return LEFT;
    }

    protected int getRowNear(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proximity = 0;
        int direction = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proximity < r) {
            Integer i = r + proximity * direction;
            if (!this.rowsUsed.containsKey(i)) {
                this.rowsUsed.put(i, i);
                this.reserveRow(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 8;
            }
            if (j >= max) {
                return j - 8;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 8;
        }
        return r;
    }

    public void remove(Connection connection) {
        this.removeReservedLines(connection);
    }

    protected void removeReservedLines(Connection connection) {
        ReservedInfo rInfo = (ReservedInfo)this.reservedInfo.get(connection);
        if (rInfo == null) {
            return;
        }
        int i = 0;
        while (i < rInfo.reservedRows.size()) {
            this.rowsUsed.remove(rInfo.reservedRows.get(i));
            ++i;
        }
        i = 0;
        while (i < rInfo.reservedCols.size()) {
            this.colsUsed.remove(rInfo.reservedCols.get(i));
            ++i;
        }
        this.reservedInfo.remove(connection);
    }

    protected void reserveColumn(Connection connection, Integer column) {
        ReservedInfo info = (ReservedInfo)this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedCols.add(column);
    }

    protected void reserveRow(Connection connection, Integer row) {
        ReservedInfo info = (ReservedInfo)this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedRows.add(row);
    }

    protected void processPositions(Ray start, Ray end, List positions, boolean horizontal, Connection conn) {
        this.removeReservedLines(conn);
        int[] pos = new int[positions.size() + 2];
        pos[0] = horizontal ? start.x : start.y;
        int i = 0;
        while (i < positions.size()) {
            pos[i + 1] = (Integer)positions.get(i);
            ++i;
        }
        pos[++i] = horizontal == (positions.size() % 2 == 1) ? end.x : end.y;
        PointList points = new PointList();
        points.addPoint(new Point(start.x, start.y));
        i = 2;
        while (i < pos.length - 1) {
            Point p;
            int max;
            int min;
            boolean adjust;
            horizontal = !horizontal;
            int prev = pos[i - 1];
            int current = pos[i];
            boolean bl = adjust = i != pos.length - 2;
            if (horizontal) {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    pos[i] = current = this.getRowNear(conn, current, min, max);
                    current -= current % 8;
                    int n = i;
                    pos[n] = pos[n] - pos[i] % 8;
                }
                p = new Point(prev, current);
            } else {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    boolean flag = i == 2 && pos.length == 5;
                    pos[i] = current = this.getColumnNear(conn, current, min + 8 - 1, max - 8 + 1, flag);
                    current -= current % 8;
                    int n = i;
                    pos[n] = pos[n] - pos[i] % 8;
                }
                p = new Point(current, prev);
            }
            points.addPoint(p);
            ++i;
        }
        points.addPoint(new Point(end.x, end.y));
        conn.setPoints(points);
    }

    protected Ray getDirection(Rectangle r, Point p) {
        int distance = Math.abs(r.x - p.x);
        Ray direction = LEFT;
        int i = Math.abs(r.y - p.y);
        if (i <= distance) {
            distance = i;
            direction = UP;
        }
        if ((i = Math.abs(r.bottom() - p.y)) <= distance) {
            distance = i;
            direction = DOWN;
        }
        if ((i = Math.abs(r.right() - p.x)) < distance) {
            distance = i;
            direction = RIGHT;
        }
        return direction;
    }

    private class ReservedInfo {
        public List reservedRows = new ArrayList(2);
        public List reservedCols = new ArrayList(2);

        private ReservedInfo() {
        }
    }
}

