/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.jboss.tools.struts.ui.editor.edit.ProcessItemEditPart;
import org.jboss.tools.struts.ui.editor.figures.ProcessItemFigure;
import org.jboss.tools.struts.ui.editor.model.IProcessItem;

public class ActionFigure
extends ProcessItemFigure {
    public Font font;

    public ActionFigure(IProcessItem processItem, ProcessItemEditPart part) {
        super(processItem, part);
        this.setBorder((Border)new ActionBorder(blackColor));
        this.setBackgroundColor(new Color(null, 226, 239, 219));
        this.setForegroundColor(blackColor);
        if (processItem != null) {
            this.font = processItem.getStrutsModel().getOptions().getActionFont();
        }
        this.VERTICAL_ANCHOR_OFFSET = 8;
        this.init(0);
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        int width = r.width - 1;
        int height = r.height - 1;
        if (this.processItem.isConfirmed()) {
            g.setBackgroundColor(whiteColor);
        } else if (this.processItem.isAnotherModule()) {
            g.setBackgroundColor(whiteColor);
        } else {
            g.setBackgroundColor(lightGrayColor);
        }
        g.fillRectangle(1, 1, 22, 19);
        if (this.icon != null) {
            g.drawImage(this.icon, 4, 2);
        }
        if (this.processItem.hasErrors()) {
            g.drawImage(errorIcon, 4, 10);
        }
        if (this.processItem.isConfirmed()) {
            g.setBackgroundColor(this.getLocalBackgroundColor());
        } else if (this.processItem.isAnotherModule()) {
            g.setBackgroundColor(anotherModuleColor);
        } else {
            g.setBackgroundColor(lightGrayColor);
        }
        g.fillRectangle(24, 1, width - 25, 19);
        g.fillRectangle(1, 21, width - 2, height - 21);
        if (this.processItem.isConfirmed()) {
            g.setForegroundColor(blackColor);
        } else {
            g.setForegroundColor(darkGrayColor);
        }
        g.setFont(this.font);
        g.drawString(this.dottedString(this.processItem.getName(), width - 37, this.font), 31, 3);
    }

    class ActionBorder
    extends LineBorder {
        public ActionBorder(Color color) {
            super(color);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle r = ActionBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getCopy();
            graphics.translate(r.getLocation());
            int width = r.width - 1;
            int height = r.height - 1;
            if (ActionFigure.this.processItem != null && ActionFigure.this.processItem.isSwitchAction()) {
                graphics.setForegroundColor(blackColor);
                graphics.drawLine(23, 0, 23, height - 1);
                graphics.drawLine(0, 1, 0, height - 2);
                graphics.drawLine(1, 0, 23, 0);
                graphics.drawLine(1, 20, 23, 20);
                graphics.drawLine(1, height - 1, 23, height - 1);
                graphics.setLineStyle(3);
                graphics.drawLine(width - 1, 1, width - 1, height - 2);
                graphics.drawLine(24, 0, width - 2, 0);
                graphics.drawLine(24, 20, width - 2, 20);
                graphics.drawLine(24, height - 1, width - 2, height - 1);
            } else {
                if (ActionFigure.this.processItem != null && ActionFigure.this.processItem.isConfirmed()) {
                    graphics.setForegroundColor(blackColor);
                } else {
                    if (ActionFigure.this.processItem != null && ActionFigure.this.processItem.isAnotherModule()) {
                        graphics.setLineStyle(3);
                    }
                    graphics.setForegroundColor(darkGrayColor);
                }
                graphics.drawLine(1, 0, width - 2, 0);
                graphics.drawLine(width - 1, 1, width - 1, height - 2);
                graphics.drawLine(23, 0, 23, height - 1);
                graphics.drawLine(0, 1, 0, height - 2);
                graphics.drawLine(1, 20, width - 2, 20);
                graphics.drawLine(1, height - 1, width - 2, height - 1);
            }
        }
    }
}

