/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.ui.editor.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;
import org.jboss.tools.common.gef.GEFGraphicalViewer;
import org.jboss.tools.struts.ui.editor.StrutsEditor;
import org.jboss.tools.struts.ui.editor.figures.NodeFigure;
import org.jboss.tools.struts.ui.editor.model.IBreakPoint;
import org.jboss.tools.struts.ui.editor.model.IBreakPointListener;

public class BreakPointFigure
extends Figure
implements MouseListener,
IBreakPointListener {
    public static boolean itemFlag = false;
    public static boolean outputFlag = false;
    public static final Color greenColor = new Color(null, 28, 206, 0);
    public static final Color redColor = new Color(null, 255, 0, 0);
    boolean sheduled = false;
    IBreakPoint bp;
    EditPart part;
    boolean flag = false;

    public BreakPointFigure(EditPart editPart, IBreakPoint bp) {
        this.setSize(9, 9);
        this.bp = bp;
        this.part = editPart;
        this.addMouseListener(this);
        this.update();
    }

    public BreakPointFigure(EditPart editPart, IBreakPoint bp, boolean flag) {
        this(editPart, bp);
        this.flag = flag;
    }

    public void addNotify() {
        super.addNotify();
        this.bp.addBreakPointListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.bp.removeBreakPointListener(this);
    }

    public void breakPointChange() {
        this.update();
        this.repaint();
    }

    public void update() {
        if (this.bp.isDebugMode() || this.bp.getStatus() != 1) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    public void paintFigure(Graphics g) {
        this.update();
        Rectangle bounds = this.getBounds();
        g.translate(bounds.x, bounds.y);
        g.setForegroundColor(NodeFigure.blackColor);
        g.drawRectangle(0, 0, 8, 8);
        if (this.bp.isActive() && !this.sheduled) {
            StrutsEditor.blinker.addRedrawListener(this);
            this.sheduled = true;
        }
        if (!this.bp.isActive() && this.sheduled) {
            StrutsEditor.blinker.removeRedrawListener(this);
            this.sheduled = false;
        }
        if (StrutsEditor.blinker.isBlink() && this.bp.isActive()) {
            g.setBackgroundColor(greenColor);
        } else if (this.bp.getStatus() == 1) {
            g.setBackgroundColor(NodeFigure.whiteColor);
        } else if (this.bp.getStatus() == 2) {
            g.setBackgroundColor(NodeFigure.mediumGrayColor);
        } else if (this.bp.getStatus() == 4) {
            g.setBackgroundColor(redColor);
        }
        g.fillRectangle(1, 1, 7, 7);
        if (this.bp.getActiveStatus() == 1) {
            g.setForegroundColor(NodeFigure.whiteColor);
            g.drawLine(4, 2, 4, 6);
            g.drawLine(3, 3, 4, 3);
        } else if (this.bp.getActiveStatus() == 2) {
            g.setForegroundColor(NodeFigure.whiteColor);
            g.drawLine(2, 2, 5, 2);
            g.drawLine(6, 3, 6, 4);
            g.drawLine(4, 4, 6, 4);
            g.drawLine(2, 5, 3, 5);
            g.drawLine(2, 6, 6, 6);
        } else if (this.bp.getActiveStatus() == 3) {
            g.setForegroundColor(NodeFigure.whiteColor);
            g.drawLine(2, 2, 6, 2);
            g.drawLine(6, 2, 6, 3);
            g.drawLine(4, 4, 5, 4);
            g.drawLine(6, 5, 6, 6);
            g.drawLine(2, 6, 6, 6);
        }
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        if (me.button == 3) {
            if (this.flag) {
                ((GEFGraphicalViewer)this.part.getViewer()).setNoDeselect();
                this.part.getViewer().select(this.part);
            }
            if (this.bp.isProcessItem()) {
                itemFlag = true;
            } else {
                outputFlag = true;
            }
        }
    }

    public void mouseReleased(MouseEvent me) {
    }
}

